include	clib.inc
include	dir.inc
include	io.inc
include	iost.inc
include	string.inc
include	errno.inc
include	conio.inc
include	tinfo.inc
include	version.inc
include mouse.inc

	public	main
	public	_stklen
	public	configpath
	public	searchstring
	public	replacestring
	public	teflag
	public	fsflag
	public	telsize
	public	tepages

	extrn	_argc:word
	extrn	_argv:dword
	extrn	configfile:byte

_DATA	SEGMENT

_stklen	dw 	3000h

cp_info	label byte
	db	'Text Edit Version ',VERS?,' Copyright (c) 2012 Hjort Nidudsson',13,10
size_info = $ - offset cp_info

cp_usage label byte
	db	'Syntax is: TE [-options] <file>',13,10
	db	13,10
	db	'  -q',9,9,	'quiet - no logo',13,10
	db	'  -l<line>',9,	'Line number',13,10
size_usage = $ - offset cp_usage

cp_ini label byte
	db '[st.mask.*.asm]',10
	db '00=[common_asm]',10
	db '[st.mask.*.inc]',10
	db '00=[common_asm]',10
	db '[st.mask.*.c]',10
	db '00=[common_c]',10
	db '[st.mask.*.h]',10
	db '00=[common_c]',10
	db '[st.mask.*]',10
	db '00=Black',10
	db '01=<>',10
	db '02=[Common]',10
	db '03=#',10
	db '04=<!>',10
	db '[Blue]',10
	db '00=A 17',10
	db '[Black]',10
	db '00=A 07',10
	db '[Control]',10
	db '00=O 40',10
	db '[Quote]',10
	db '00=Q XB',10
	db '[Number]',10
	db '00=D XB',10
	db '[$]',10
	db '00=C XB $\',10
	db '[Operator]',10
	db '00=C XF .:!|/<[{()}]>,-*+?%&=^~";"',10
	db '[<>]',10
	db '00=N X6 < >',10
	db '[<!>]',10
	db '00=N X8 <! >',10
	db '[#]',10
	db '00=B X2 #',10
	db '[Common]',10
	db '00=Control',10
	db '01=Quote',10
	db '02=Number',10
	db '03=$',10
	db '04=Operator',10
	db '[if]',10
	db '00=W X2 if else endif',10
	db '[ifdef]',10
	db '00=B X2 ifdef ifndef',10
	db '[comment]',10
	db '00=B X8 ";"',10
	db '[include]',10
	db '00=B X2 include',10
	db '[segment]',10
	db '00=W X5 cs ds es ss',10
	db '[assert]',10
	db '00=B X4 assert',10
	db '[regs]',10
	db '00=W X2',10
	db '01=al bl cl dl ah bh ch dh ax bx cx dx si di bp sp',10
	db '[words]',10
	db '00=W X3',10
	db '01=mov and or xor add sub cmp test les lds push pop shl shr adc dec inc',10
	db '02=xchg cld std clc stc cwb cbw popa pusha mul div imul idiv sbb not neg',10
	db '03=lodsb stosb lodsw stosw rep repe repne repz repnz in out aam org',10
	db '[jumps]',10
	db '00=W X9',10
	db '01=jmp ja jb jc jz jna jnb jnc jnz jna jnz je jne jae jbe',10
	db '02=jl jg jle jge',10
	db '[call]',10
	db '00=W X6 call invoke int ret retf iret',10
	db '[directive]',10
	db '00=W XF',10
	db '01=public extrn label proc near far endp ends size struc',10
	db '02=segment seg offset ptr byte word dword db dw dd equ',10
	db '[base]',10
	db '00=W X6 bp si di bx bh bl',10
	db '[accumulator]',10
	db '00=W X4 eax ax ah al',10
	db '[segments]',10
	db '00=W XF code data stack _text _data',10
	db '[common_asm]',10
	db '00=Black',10
	db '01=[Common]',10
	db '02=regs',10
	db '03=segment',10
	db '04=accumulator',10
	db '05=base',10
	db '06=segments',10
	db '07=words',10
	db '08=call',10
	db '09=jumps',10
	db '10=directive',10
	db '11=assert',10
	db '12=if',10
	db '13=ifdef',10
	db '14=include',10
	db '15=comment',10
	db '[//]',10
	db '00=B X8 //',10
	db '[/**/]',10
	db '00=N X8 /* */',10
	db '[c.words]',10
	db '00=W XF const operator char int long void',10
	db '01=if else for do while break continue goto return',10
	db '02=switch case default public extern',10
	db '[common_c]',10
	db '00=Blue',10
	db '01=[Common]',10
	db '02=c.words',10
	db '03=//',10
	db '04=#',10
	db '05=/**/',10
size_ini = $ - offset cp_ini

te_cfg		db 'te.cfg',0
te_ini		db 'te.ini',0
option_q	db 0
arg_file	dd 0
arg_line	dw 0
configpath	db WMAXPATH dup(0)

searchstring	db 128 dup(0)
replacestring	db 128 dup(?)
fsflag 		db 0
teflag 		dw _T_TEDEFAULT
telsize 	dw 256
tepages 	dw 64
size_config	= $ - offset searchstring


_DATA	ENDS

_TEXT	SEGMENT

main	proc
	.if _argc == 1
	print_usage:
	    mov cx,size_usage
	    mov dx,offset cp_usage
	    call stderrmsg
	    xor ax,ax
	    ret
	.endif
	mov bx,word ptr _argv
	invoke strcpy, addr configpath, [bx]
	invoke strfn, dx::ax
	mov bx,ax
	mov byte ptr [bx-1],0
	invoke strfcat, addr configfile, addr configpath, addr te_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_RDONLY, A_OPEN) != -1
	    push ax
	    invoke osread, ax, addr searchstring, size_config
	    call close
	.endif
	mov si,1
    arg_loop:
	cmp si,_argc
	jae init_info
	les bx,_argv
	mov ax,si
	inc si
	shl ax,2
	add bx,ax
	les bx,es:[bx]
	mov ax,es:[bx]
	cmp al,'?'
	je print_usage
	cmp al,'/'
	je options
	cmp al,'-'
	je options
	mov word ptr arg_file,bx
	mov word ptr arg_file+2,es
	jmp arg_loop
    options:
	mov al,ah
	or al,20h
	.if al == 'q'
	    inc option_q
	.elseif al == 'l'
	    add bx,2
	    invoke strtol, es::bx
	    mov arg_line,ax
	.else
	    jmp print_usage
	.endif
	jmp arg_loop
    init_info:
	.if !option_q
	    mov cx,size_info
	    mov dx,offset cp_info
	    call stderrmsg
	.endif
	.if func(access, arg_file, 0)
	    invoke strcpy, addr cp_info, arg_file
	    call eropen
	    xor ax,ax
	    ret
	.endif
      ifdef __MOUSE__
	call mouseinit
	call mouseon
      endif
	invoke strfcat, addr configfile, addr configpath, addr te_ini
	.if func(access, dx::ax, 0)
	    .if func(osopen, addr configfile, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
		push ax
		invoke oswrite, ax, addr cp_ini, size_ini
		call close
	    .endif
	.endif
	invoke tedit, arg_file, arg_line
      ifdef __MOUSE__
	call mouseoff
      endif
	invoke strfcat, addr configfile, addr configpath, addr te_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
	    push ax
	    invoke oswrite, ax, addr searchstring, size_config
	    call close
	.endif
	xor ax,ax
	ret
main	endp

_TEXT	ENDS

	END
