ifdef DEBUG
include inc/src/assert.asm
else
DCALL	MACRO	a,b,c,d,e,f
	ENDM
DADD	MACRO	a,b,c,d,e,f
	ENDM
DSUB	MACRO	a,b,c,d,e,f
	ENDM
DMOV	MACRO	a,b,c,d,e,f
	ENDM
DPUSH	MACRO	a,b,c
	ENDM
DPOP	MACRO	a,b,c
	ENDM
endif ;	DEBUG

tracev	MACRO message,len
	local @@
  ifdef DEBUG
	push offset @@
	call assert_out
	DB message,0
	@@:
	add sp,len
  endif
	ENDM

assert	MACRO A,B,J,message
	local @@
  ifdef DEBUG
	pushf
	cmp A,B
	&J @@
	popf
	call assert_exit
	DB "cmp &A&,&B& (&J&) - ",message,0
	@@:
	popf
  endif
	ENDM

assertf	MACRO J,message
	local @@
  ifdef DEBUG
	&J @@
	call assert_exit
	DB "flag (&J&) - ",message,0
	@@:
  endif
	ENDM

assertt	MACRO A,B,J,message
	local @@
  ifdef DEBUG
	pushf
	test A,B
	&J @@
	popf
	call assert_exit
	DB "test &A&,&B& (&J&) - ",message,0
	@@:
	popf
  endif
	ENDM
