/* CCMT.C--
 * Copyright (c) 1997 Hjort Nidudsson
 *
 * Change history:
 * 16 Jul 1997	- Created.
 */

#include <io.h>
#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#define MAXLABEL	32
#define MAXTOKEN	1000

#define APOS		39
#define QUOTE		'"'
#define COMMENT		';'

#define FILE_C		1
#define FILE_H		2
#define FILE_I		3
#define FILE_A		4
#define FILE_M		5

char *cinfo = // Source Comment
"CCMT 1.00 Copyright (c) 1997 Hjort Nidudsson\n";
char *usage =
" Syntax: CCMT [-tulxh#*;dm] @listfile filename\n"
"   filename  .ASM file pathname\n"
"   @listfile  file name for token-list file (optional)\n"
"    default:  1. Search current directory\n"
"              2. Search program directory\n"
"               . Use program default list\n"
"   /T         Write the default TOKENLST.TXT to current directory\n"
"   /U         strupr(filename) -^ and ; comment\n"
"   /L         strlwr() ^\n"
"   /X         Exclude backup (.BAK) file\n"
"   /H         Write header info [.H|.C|.ASM|.INC|.MAK] = auto\n"
"   /#         assume # comment\n"
"   /;         assume ; comment\n"
"   /*         assume /* comment */\n"
"   /D         Write date in header info\n"
"   /M         Insert Modification: [date]\n"
;

/* CCMT.C--
 * Copyright (c) 1996-2008 Hjort Nidudsson
 *
 * Change history:
 * 10 Feb 2002	- Created.
 */
const char cp_copyright   [] = "Copyright (c) 1996-2008 Hjort Nidudsson";
const char cp_ahead[] =
"; %s--\n"
"; %s\n"
";\n"
"; Change history:\n"
;
const char cp_chead[] =
"/* %s--\n"
" * %s\n"
" *\n"
" * Change history:\n"
;
const char cp_mhead[] =
"# %s--\n"
"# %s\n"
;

char tchars[] =  "%.0123456789?ABCDEFGHIJKLMNOPQRSTUVWXYZ_";
/* These are the valid characters used in assembly files^ */
extern char token[MAXTOKEN][MAXLABEL];    /* default list */

wfblk fblock;

int arg_toupper = 0;
int arg_tolower = 0;
int arg_date = 0;
int arg_xclude = 0;
int arg_writehead = 0;
int arg_insertdate = 0;
char *arg_tokenfile = NULL;

int tcount = 347 + 32; // 380
int ftype = 0;
int fdate = 0;
int create = 0;

char filename[WMAXPATH];
char unixname[WMAXPATH];
char tempfile[WMAXPATH];
char procname[WMAXPATH];
char tokfile[] = "TOKENLST.TXT";

char tword[512];
char temp[512];
char line[512];

FILE *fp_src;
FILE *fp_out;

#ifdef __GNUC__
char *setext(char *b, const char *e, const char *argv)
{
	strcpy(b, argv);
	strcpy(strrchr(b, '.') + 1, e);
	return b;
}

int strtrim(char *p)
{
	int count;

	if ((count = strlen(p)) != 0) {
		do {
			if ((unsigned char)p[count - 1] <= ' ')
				p[--count] = '\0';
			else
				break;
		} while (count);
	}
	return count;
}
#endif

char *sgetcase(char *s)
{
	if (arg_toupper)
		return strupr(s);
	if (arg_tolower)
		return strlwr(s);
	return s;
}

int getcase(int c)
{
	if (arg_toupper)
		return toupper(c);
	if (arg_tolower)
		return tolower(c);
	return c;
}

int istoken(int c)
{
	int ch,i;

	ch = toupper(c);
	for (i = 0; tchars[i]; i++) {
		if (ch == tchars[i])
			return 1;
	}
	return 0;
}

int cmptword(int o)
{
	int i;

	for (i = 0; token[i][0]; i++) {
		if (o == strlen(token[i])) {
			if (strnicmp(token[i], tword, o) == 0) {
				strcat(temp, token[i]);
				return o;
			}
		}
	}
	return 0;
}

int cmpword(char *q)
{
	char *p;
	int i,o;

	strcpy(tword, q);
	strtrim(tword);
	for (p = tword; istoken(*p); p++)
		;
	*p = 0;
	o = strlen(tword);
	if (o < 2) {
		strcat(temp, tword);
		return o;
	}
	for (i = 0; token[i][0]; i++) {
		if (o == strlen(token[i])) {
			if (strnicmp(token[i], tword, o) == 0) {
				strcat(temp, token[i]);
				return o;
			}
		}
	}
	if ((p = strchr(tword, '.')) != NULL) {
		p[0] = 0;
		o = strlen(tword);
		if ((i = cmptword(o)) != 0)
			return i;
		p[0] = '.';
		o = strlen(tword);
//		p[1] = 0;
//		o++;
	}

	strcat(temp, sgetcase(tword));
	return o;
}

int parseline(void)
{
	int ch,i,z,o,quote,apos;
	char *p,*q,*b;

	quote = 0;
	apos  = 0;
	b     = temp;
	q     = line;
	memset(b, 0, 512);
	while (*q) {
		/* char */
		if (*q == COMMENT) {
			if (temp[0])
				fputs(temp, fp_out);
			fputs(q, fp_out);
			return 1;
		}
		if (quote == 0 && *q == APOS) {
			if (apos)
				apos = 0;
			else
				apos = 1;
			*b++ = *q++;
			continue;
		}
		if (apos == 0 && *q == QUOTE) {
			if (quote)
				quote = 0;
			else
				quote = 1;
			*b++ = *q++;
			continue;
		}
		if (apos || quote || *q < 33) {
			*b++ = *q++;
			continue;
		}
		if (istoken(*q) == 0) {
			*b++ = getcase(*q++);
			continue;
		}
		/* word */
		o = cmpword(q);
		b += o;
		q += o;
	}
	if (temp[0])
		fputs(temp, fp_out);
	return 1;
}

#ifdef __GNUC__
int read_token(char *argv)
#else
int read_token(void)
#endif
{
	char *p;
	FILE *fp;

	if (arg_tokenfile) {
		if ((fp = fopen(arg_tokenfile,"rt")) == NULL) {
			perror(arg_tokenfile);
			return 0;
		}
	} else if ((fp = fopen(tokfile,"rt")) == NULL) {
#ifdef __GNUC__
		setext(temp, "TXT", argv);
#else
		setext(temp, "TXT");
#endif
		strcpy(strrchr(temp, '\\') + 1, tokfile);
		if ((fp = fopen(temp,"rt")) == NULL)
			return 0;
	}

	tcount = 0;
	while (tcount < MAXTOKEN) {
		if (fgets(temp, 256, fp) == NULL)
			break;
		if ((p = strchr(temp, COMMENT)) != NULL) {
			*p = 0;
		}
		if (strtrim(temp) < 2)
			continue;
		if (istoken(temp[0]) == 0)
			continue;
		strcpy(token[tcount++], temp);
	}
	fclose(fp);
	return tcount;
}

int write_token(void)
{
	int i;
	FILE *fp;

	if (access(tokfile, 0) == 0) {
		printf("The file %s exist!\n owerwrite? (y, n): ", tokfile);
		i = getch();
		printf("%c\n\n", i);
		if (toupper(i) != 'Y') {
			return 1;
		}
	}
	if ((fp = fopen(tokfile,"wt")) == NULL) {
		perror(tokfile);
		return 1;
	}

	fprintf(fp,
	"; %s - Configuration file\n;\n"
	"; MAXIDLEN: 32\n"
	"; MAXTOKEN: 1000\n;\n"
	"; These are the valid characters used as identifiers\n;\n"
	";\t%%.0123456789?ABCDEFGHIJKLMNOPQRSTUVWXYZ\n;\n",
	tokfile);

	for (i = 0; token[i][0]; i++)
		fprintf(fp, "%s\n", token[i]);
	fprintf(fp, ";\n; %d of total %d (%d free)\n;\n",
		i, MAXTOKEN, MAXTOKEN - tcount);
	fclose(fp);
	return 0;
}

void InsertProc(void)
/**

include		clib.inc

_TEXT		SEGMENT
_TEXT		ENDS

PPROC		%s
USES		DS,si,di
ARG		x,y:	WORD,\
		wstr:	DWORD,\
		string:	DPTR,\
		count:	WORD
		mov	cx,count
		MLDS	si,string
		les	di,wstr
		cld
@@success:	xor	ax,ax
@@toend:	ret
@@error:	push	ax
		call	dosmaperr
		mov	ax,-1
		jmp	short @@toend
PEND		%s

		END
**/
{
    fprintf(fp_out,
	"\n"
	"INCLUDE\t\tclib.inc\n\n"
	"_TEXT\t\tSEGMENT\n"
	"_TEXT\t\tENDS\n\n"
	"PPROC\t\t%s\n"
	"ARG\t\tx,y:\tWORD,\\\n"
	"\t\twstr:\tDWORD,\\\n"
	"\t\tstring:\tDPTR,\\\n"
	"\t\tcount:\tWORD\n"
	"\t\tUSES\tDS,si,di\n"
	"\t\tmov\tcx,count\n"
	"\t\tMLDS\tsi,string\n"
	"\t\tles\tdi,wstr\n"
	"\t\tcld\n"
	"@@success:\txor\tax,ax\n"
	"@@toend:\tret\n"
	"@@error:\tpush\tax\n"
	"\t\tcall\tdosmaperr\n"
	"\t\tmov\tax,-1\n"
	"\t\tjmp\tSHORT @@toend\n"
	"PEND\t\t%s\n\n"
	"\t\tEND\n",
	procname, procname, procname);
}

int write_head(const char *form)
{
	strcpy(temp, fblock.name);
	strupr(temp);
	fprintf(fp_out, form, temp, cp_copyright);//, cp_doszip);
	return 1;
}

const char *cp_mnd[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Des"
};

char *datetostring(char *p, WORD dt)
{
	WORD d,m,y;

	d = dwtoday(dt);
	m = dwtomnd(dt);
	y = dwtoyear(dt);
	sprintf(p, "%d %s %02d\t-", d, cp_mnd[m-1], y);
	return p;
}

int write_creation(const char *str)
{
	if (create) {
		fprintf(fp_out, str);
		fprintf(fp_out, "%s Created\n", datetostring(temp, fblock.date_create));
		return 1;
	}
	fprintf(fp_out, "%s\n", str);
	return 0;
}

int write_modification(const char *str)
{
	fprintf(fp_out, str);
	fprintf(fp_out, "%s\n", datetostring(temp, fblock.date_modified));
	return 1;
}

int write_chead(void)
{
	write_head(cp_chead);
	if (arg_date) {
		write_modification(" * ");
	} else if (create) {
		write_creation(" * ");
	}
	fprintf(fp_out, " */\n");
	return 1;
}

int write_hhead(void)
{
	char *b, *p;

	write_chead();
	if (create == 0)
		return 1;

	b = temp;
	strcpy(b, "__INC_");
	strcat(b, procname);
	strupr(b);
	p = b + 5;
	do {
		if (!istoken(*p)) {
			*p = 0;
			break;
		}
	} while (*++p);
	fprintf(fp_out,
		"#ifndef %s\n"
		"#define %s\n"
		"#ifn!defined(__INC_DEFS)\n"
		" #include <defs.h>\n"
		"#endif\n"
		"#ifdef __cplusplus\n"
		" extern \"C\" {\n"
		"#endif\n"
		"#ifdef __cplusplus\n"
		" }\n"
		"#endif /* __cplusplus */\n"
		"#endif /* %s */\n", b, b, b);
	return 1;
}

int write_ihead(void)
{
	write_head(cp_ahead);
	if (arg_date) {
		write_creation("; ");
		write_modification("; ");
	}
	fprintf(fp_out, ";\n");
	return 1;
}

int write_ahead(void)
{
	write_ihead();
	if (create)
		InsertProc();
	return 1;
}

int write_mhead(void)
{
	write_head(cp_mhead);
	if (arg_date) {
		write_creation("# ");
		write_modification("# ");
	}
	fprintf(fp_out, "#\n");
	return 1;
}

int insertdate(void)
{
	char c,ci = 0;
	char b[64];

	switch (ftype) {
	case FILE_C:
	case FILE_H:
		ci++;
		c = '*';
		break;
	case FILE_A:
	case FILE_A:
		c = ';';
		break;
	case FILE_M:
		c = '#';
		break;
	default:
		return 0;
	}
	do {
		if (fgets(line, 511, fp_src) == NULL)
			break;
		fputs(line, fp_out);
		if (strstr(line, "Change history:") != NULL) {
			if (ci)
				fprintf(fp_out, " * ");
			else
				fprintf(fp_out, "%c ", c);
			fprintf(fp_out, "%s\n", datetostring(b, dwdosdate()));
			//fgets(line, 511, fp_src);
			break;
		}
		if (line[ci] != c)
			break;
	} while (1);
	return 0;
}

int init_srcfile(char *fn)
{
	ffblk ff;
	char *p;
	int c,h;

	if (!filexist(fn)) { /* Create a new source file */
		if ((h = osopen(fn, _A_NORMAL, M_WRONLY, A_CREATE | A_TRUNC)) != -1) {
			close(h);
		} else {
			perror(fn);
			return 0;
		}
		create++;
		arg_writehead++;
	}
	c = 0; /* Get short file-info */
	if (findfirst(fn, &ff, _A_ALLFILES) == 0) {
		strcpy(fblock.name, ff.ff_name);
		strcpy(fblock.shname, ff.ff_name);
		fblock.time_modified = ff.ff_ftime;
		fblock.date_modified = ff.ff_fdate;
		c++;
	}
	/* Get long-name file-info */
	if ((h = wfindfirst(fn, &fblock, _A_ALLFILES)) != -1) {
		wcloseff(h);
		c++;
	}
	if (c == 0) { /* File not found */
		perror(fn);
		trace();
		return 0;
	}
	strcpy(filename, wlongpath(fn, NULL));
	strcpy(unixname, filename + 3);
	dostounix(unixname);
	strcpy(tempfile, filename);
	if ((p = strchr(tempfile, '.')) == NULL)
		strcat(tempfile, ".tmp");
	else
		strcpy(p, ".tmp");
	strcpy(procname, strfn(filename));
	if ((p = strchr(procname, '.')) != NULL)
		*p++ = 0;
	if (ftype == 0 && p != NULL) {
		switch (toupper(p[0])) {
		case 'H': ftype = FILE_H; break;
		case 'C': ftype = FILE_C; break;
		case 'A': ftype = FILE_A; break;
		case 'I': ftype = FILE_I; break;
		case 'M': ftype = FILE_M;
		default:
			break;
		}
	}
	return 1;
}

int main(int argc, char *argv[])
{
	int c;
	char *p,*q;

	puts(cinfo);
	if (argc < 2) {
		puts(usage);
		return 0;
	}

	for (c = 1; c < argc; c++) {
		switch (argv[c][0]) {
		case '?':
			puts(usage);
			return 0;
		case '/':
		case '-':
			switch (argv[c][1] | 0x20) {
			case 'u':
				arg_toupper++;
				break;
			case 'l':
				arg_tolower++;
				break;
			case 'x':
				arg_xclude++;
				break;
			case 't':
				return write_token();
			case ';':
				ftype = FILE_A;
				break;
			case '*':
				ftype = FILE_C;
				break;
			case '#':
				ftype = FILE_M;
				break;
			case 'd':
				arg_date++;
				break;
			case 'h':
				arg_writehead++;
				break;
			case 'm':
				arg_insertdate++;
				break;
			default:
				puts(usage);
				return 0;
			}
			break;
		default:
			if (argv[c][0] == '@') {
				arg_tokenfile = &argv[c][1];
			} else {
				if (init_srcfile(argv[c]) == 0)
					return 1;
			}
			break;
		}
	}
#ifdef __GNUC__
	read_token(argv[0]);
#else
	read_token();
#endif
	if ((fp_src = fopen(filename,"rt")) == NULL) {
		perror(filename);
		return 0;
	}
	if ((fp_out = fopen(tempfile, "wt")) == NULL) {
		perror(tempfile);
		fclose(fp_src);
		return 0;
	}
	if (arg_insertdate)
		insertdate();
	if (arg_writehead) {
		switch (ftype) {
		case FILE_C: write_chead(); break;
		case FILE_H: write_hhead(); break;
		case FILE_A: write_ahead(); break;
		case FILE_I: write_ihead(); break;
		case FILE_M: write_mhead(); break;
		}
	}
	do {
		if (fgets(line, 511, fp_src) == NULL)
			break;
		if (arg_writehead || arg_insertdate)
			fputs(line, fp_out);
		else
			parseline();
	} while (1);
	fclose(fp_out);
	fclose(fp_src);
	q = filename;
	if (arg_xclude == 0 && create == 0) {
		strcpy(temp, q);
		if ((p = strrchr(temp, '.')) != NULL)
			strcpy(p, ".bak");
		else
			strcat(temp, ".bak");
		remove(temp);
		rename(q, temp);
	} else {
		remove(q);
	}
	rename(tempfile, q);
	return 0;
}

