/*
 * CONFIG.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <ini.h>
#include <string.h>
#include <errno.h>
#include <dzmain.h>

extern char *argv_cfgpath;

char programpath[MAXPATH];

#define PANELFLAG  	(_W_VISIBLE|_W_SORTTYPE|_W_HIDDEN)
#define CONFIGFLAG      (_C_AUTOSAVE|_C_SMALLPANELS|_C_INSMOVDN)

DZCFG config = {
	DOSZIP_VERSION,
	CONFIGFLAG,
	0xFF,		/* BYTE: Confirm */
	0,		/* BYTE: Console */
	TV_HEXOFFSET |  /* BYTE: Text View */
	FSEARCH_SUB,	/* BYTE: File Search */
	0,              /* WORD: Compress */
	{
		0,	/* PanelA: fcb[index] */
		0       /* PanelB: fcb[index] */
	},{
		0,      /* PanelA: panel[index] */
		0       /* PanelB: panel[index] */
	},{
		{	/* PanelA: PATH */
			PANELFLAG,
			"*.*",
			"C:\\DOSZIP",
			"",
			""
		},{     /* PanelB: PATH */
			PANELFLAG | _W_PANELID | _W_MINISTATUS,
			"*.*",
			"",
			"",
			""
		},
	},{ /* Operation Filter */
		0xFFFF, 0, 0, 0L, 0L, "*.*", ""
	},{ /* Default Color */
		{
			0x00,0x10,0x70,0x70,0x40,0x30,0x30,0x70
		},{
			0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
			0x08,0x0B,0x00,0x00,0x0F,0x0A,0x0F,0x0F
		},{
			0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63
		}
	},{ /* Pending file -- to be deleted on startup */
		""
	}
};

int config_init(void)
{
	strcpy(programpath, configfile);
	*strrchr(programpath, '\\') = 0;
	if (argv_cfgpath != NULL && filexist(argv_cfgpath)) {
		strfcat(configfile, argv_cfgpath, "DZ.");
		configfile_extp = strrchr(configfile, '.');
		return 1;
	}
	if (envconf == NULL)
		return 1;
	strfcat(configfile, envconf, "DZ.");
	configfile_extp = strrchr(configfile, '.');
	return 1;
}

int config_read(void)
{
	int h,z,v;

	if ((h = iniopen(OPENCFG_READ)) != -1) {
		if (osread(h, &v, 2) != 2 ||
			v != DOSZIP_VERSION) {
			//v > DOSZIP_VERSION ||
			//v < DOSZIP_MINVERS) {
			close(h);
			return 0;
		}
		z = osread(h, &config.dzflag, sizeof(DZCFG) - 2);
		close(h);
		if (z == sizeof(DZCFG) - 2)
			return 1;
	}
	return 0;
}

int config_write(void)
{
	int h, z;

	if ((h = iniopen(OPENCFG_WRITE)) != -1) {
		z = oswrite(h, &config, sizeof(DZCFG));
		close(h);
		return (z == sizeof(DZCFG));
	}
	return 0;
}

static int create_INI(void)
{
	int h;

	if ((h = iniopen(OPENINI_WRITE)) != -1) {
		oswrite(h, default_ini, strlen(default_ini));
		close(h);
	}
	return 1;
}

void init_tools(void)
{
	if (!filexist(filename_INI()))
		create_INI();
}

int cmsavesetup(void)
{
	if (rsmodal(IDD_SaveSetup)) {
		if (config_write() == 0)
			return stderror(filename_CFG(), EMEROPEN, 0);
		return 1;
	}
	return 0;
}

/******** Resource begin SaveSetup *
	{ 0x041C,   2,   0, {27, 7,27, 7} },
	{ 0x0000,   0, 'S', { 3, 5, 8, 1} },
	{ 0x0200,   0, 'C', {14, 5,10, 1} },
********* Resource data  *******************/
static int SaveSetup_RC[] = {
	0x01D1,0x041C,0x0002,0x071B,0x071B,0x0000,0x5300,0x0503,
	0x0108,0x0200,0x4300,0x050E,0x010A,0x1BF0,0xF050,0x2A6F,
	0x5050,0xF05C,0x5005,0x2A20,0x502A,0x5C50,0x07F0,0x2050,
	0x06F0,0xF02A,0x2008,0x03F0,0xF02A,0x200A,0x2A2A,0x0BF0,
	0x5320,0x7465,0x7075,0x2AF0,0x4420,0x206F,0x6F79,0x2075,
	0x6977,0x6873,0x7420,0x206F,0x6173,0x6576,0x08F0,0x7420,
	0x6568,0x6320,0x7275,0x6572,0x746E,0x7320,0x7465,0x7075,
	0xF03F,0x2025,0x6153,0x6576,0x2020,0xF0DC,0x2004,0x6143,
	0x636E,0x6C65,0x2020,0xF0DC,0x2006,0x08F0,0xF0DF,0x2003,
	0x0AF0,0x20DF,0x2A20,
}; //	150 byte
ROBJ *IDD_SaveSetup = (ROBJ *)&SaveSetup_RC;
/******** Resource end   SaveSetup */
