/*
 * CMSCREEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <string.h>
#include <dzmain.h>
#include <arch.h>
#include <errno.h>

const char
	cp_loadcolor	[] = "Load color",
	cp_savecolor	[] = "Save color";

static DOBJ *dialog;
const char cp_cmdreload[] = "ECHO.";

enum {  ID_DATE,
	ID_TIME,
	ID_COLOR1,
	ID_COLOR2,
	ID_COLOR3,
	ID_COLOR4,
	ID_COLOR5,
	ID_COLOR6,
	ID_USECOLOR,
	ID_EDITATTRIB,
	ID_EDITPAL,
	ID_STANDARD,
	ID_LOAD,
	ID_SAVE,
	ID_OK,
	ID_CANCEL,
	IDCOUNT		};

static COLOR color_Red;
static COLOR color_Black;
static COLOR color_Blue;
static COLOR color_Navy;
static COLOR color_Green;
static COLOR color_Yellow;

static int screen_editattrib(void);
static int screen_editpal(void);
static int screen_standard(void);
static int screen_usecolor(void);
static int screen_loadcolor(void);
static int screen_savecolor(void);
static int screen_reload(const char *);

int screen_reload(const char *p)
{
	memcpy(&config.dzcolor, p, 40);
	ex_command(cp_cmdreload);
	return _C_ESCAPE;
}

int screen_editattrib(void)
{
	if (editattrib())
		return screen_reload(at_background);
	return _C_NORMAL;
}

int screen_editpal(void)
{
	if (editpal())
		memcpy(&config.dzcolor, at_background, 40);
	return _C_NORMAL;
}

int screen_standard(void)
{
	void *p = NULL;

	switch (tdgetbitflag(&dialog->object[ID_COLOR1], 6, _O_RADIO)) {
	case 0x0001: p = &color_Navy; 	console |= CON_COLOR; break;
	case 0x0002: p = &color_Green; 	console |= CON_COLOR; break;
	case 0x0004: p = &color_Yellow;	console |= CON_COLOR; break;
	case 0x0008: p = &color_Red; 	resetpal(); break;
	case 0x0010: p = &color_Black;	resetpal(); break;
	case 0x0020: p = &color_Blue;	resetpal(); break;
	default:
		return _C_NORMAL;
	}
	return screen_reload(p);
}

int screen_usecolor(void)
{
	TOBJ *o;
	int result,f;

	o = &dialog->object[ID_USECOLOR];
	f = (o->flag & _O_FLAGB);
	result = tdcheckevent();
	if (f != (o->flag & _O_FLAGB)) {
		if (o->flag & _O_FLAGB)
			loadpal(at_palett);
		else
			resetpal();
	}
	return result;
}

int screen_loadcolor(void)
{
	int z,h;
	char path[MAXPATH];
	char pal[MAXPATH];

	strfcat(path, programpath, "pal");
	strcpy(pal, "default");
	h = tgetline(cp_loadcolor, pal, 20, MAXPATH);
	if (h == 0 || pal[0] == 0)
		return 0;
	strfcat(path, NULL, pal);
	if (strchr(path, '.') == NULL)
		strcat(path, ".pal");
	if ((h = osopen(path, 0, M_RDONLY, A_OPEN)) == -1)
		return stderror(path, EMEROPEN, 0);
	z = osread(h, at_background, sizeof(COLOR));
	close(h);
	if (z != sizeof(COLOR))
		return _C_NORMAL;
	return screen_reload(at_background);
}

int screen_savecolor(void)
{
	int h;
	char path[MAXPATH];
	char pal[MAXPATH];

	strfcat(path, programpath, "pal");
	strcpy(pal, "default");
	h = tgetline(cp_savecolor, pal, 20, MAXPATH);
	if (h == 0 || pal[0] == 0)
		return 0;
	if (filexist(path) == 0 && wsmkdirlocal(path) == 0)
		return stderror(path, EMEROPEN, 0);
	strfcat(path, NULL, pal);
	if (strchr(path, '.') == NULL)
		strcat(path, ".pal");
	if ((h = getouthandle(path)) == -1)
		return stderror(path, EMEROPEN, 0);
	oswrite(h, at_background, sizeof(COLOR));
	close(h);
	return _C_NORMAL;
}

int cmscreen(void)
{
	DOBJ *d;
	TOBJ *o;

	if ((d = rsopen(IDD_Screen)) == 0)
		return 0;
	dialog = d;
	o = d->object;
	if (console & CON_COLOR)
		o[ID_USECOLOR].flag |= _O_FLAGB;
	o[ID_EDITATTRIB].proc = screen_editattrib;
	o[ID_EDITPAL].proc    = screen_editpal;
	o[ID_STANDARD].proc   = screen_standard;
	o[ID_USECOLOR].proc   = screen_usecolor;
	o[ID_LOAD].proc       = screen_loadcolor;
	o[ID_SAVE].proc       = screen_savecolor;
	if (console & CON_UDATE)
		o[ID_DATE].flag |= _O_FLAGB;
	if (console & CON_UTIME)
		o[ID_TIME].flag |= _O_FLAGB;
	tdinit(d);
	if (rsevent(IDD_Screen, d)) {
		if (o[ID_TIME].flag & _O_FLAGB) {
			console |= CON_UTIME;
		} else {
			console &= ~CON_UTIME;
			scputc(72, 0, 0, 8, ' ');
		}
		if (o[ID_DATE].flag & _O_FLAGB) {
			console |= CON_UDATE;
		} else {
			console &= ~CON_UDATE;
			scputc(63, 0, 0, 8, ' ');
		}
	}
	twclose(d);
	return (_end == 1) ? _C_ESCAPE : _C_NORMAL;
}

COLOR color_Red = {
	{ 0x00,0x40,0x40,0x70,0x10,0x70,0x30,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x07,0x00,0x04,0x0A,0x0F,0x04 },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Black = {
	{ 0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x00 },
	{ 0x07,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x0B,0x07,0x07,0x0F,0x0A,0x0B,0x0B },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Blue = {
	{ 0x00,0x10,0x70,0x70,0x40,0x30,0x30,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x0B,0x00,0x00,0x0F,0x0A,0x0F,0x0F },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Navy = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x0D,0x0F,0x09,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,136,7,7,4,63,3,7,56,59,0,0,4,3,63,63 }
};

COLOR color_Green = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x09,0x0F,0x09,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,152,3,2,4,10,10,10,56,58,0,0,4,7,58,63 }
};

COLOR color_Yellow = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,54,6,6,4,62,3,6,56,48,0,0,4,2,63,0 }
};

/******** Resource begin Screen *
	{ 0x041C,  16,  14, {13, 4,55,16} },
	{ 0x0002,   0, 'E', { 5, 3, 8, 1} },
	{ 0x0002,   0, 'I', {19, 3, 8, 1} },
	{ 0x0001,   0, 'N', { 5, 6, 8, 1} },
	{ 0x0001,   0, 'G', { 5, 7, 9, 1} },
	{ 0x0001,   0, 'Y', { 5, 8,10, 1} },
	{ 0x0001,   0, 'R', {19, 6, 7, 1} },
	{ 0x0001,   0, 'K', {19, 7,10, 1} },
	{ 0x0101,   0, 'D', {19, 8,11, 1} },
	{ 0x2002,   0, 'U', { 5,11,24, 1} },
	{ 0x4000,   0, 'A', {35, 3,16, 1} },
	{ 0x4000,   0, 'P', {35, 5,16, 1} },
	{ 0x4000,   0, 'S', {35, 7,16, 1} },
	{ 0x4000,   0, 'L', {35, 9,16, 1} },
	{ 0x4000,   0, 'v', {35,11,16, 1} },
	{ 0x0000,   0, 'O', { 4,14, 6, 1} },
	{ 0x0A00,   0, 'C', {14,14,10, 1} },
********* Resource data  *******************/
static int Screen_RC[] = {
	0x0845,0x041C,0x0E10,0x040D,0x1037,0x0002,0x4500,0x0305,
	0x0108,0x0002,0x4900,0x0313,0x0108,0x0001,0x4E00,0x0605,
	0x0108,0x0001,0x4700,0x0705,0x0109,0x0001,0x5900,0x0805,
	0x010A,0x0001,0x5200,0x0613,0x0107,0x0001,0x4B00,0x0713,
	0x010A,0x0101,0x4400,0x0813,0x010B,0x2002,0x5500,0x0B05,
	0x0118,0x4000,0x4100,0x0323,0x0110,0x4000,0x5000,0x0523,
	0x0110,0x4000,0x5300,0x0723,0x0110,0x4000,0x4C00,0x0923,
	0x0110,0x4000,0x7600,0x0B23,0x0110,0x0000,0x4F00,0x0E04,
	0x0106,0x0A00,0x4300,0x0E0E,0x010A,0x37F0,0xF050,0x2A7A,
	0xF02E,0x2A0B,0xF02E,0x2A0A,0x07F0,0x5C50,0x08F0,0x2050,
	0x27F0,0xF02A,0x2010,0x26F0,0xF02A,0x5007,0xF05C,0x5008,
	0xF020,0x2A0C,0xF02E,0x2A0D,0xF02E,0x2A0C,0x10F0,0xF020,
	0x2A0C,0xF02E,0x2A11,0xF02E,0x2A07,0x5050,0xF05C,0x500D,
	0xF020,0x2A0C,0xF02E,0x2A0D,0xF02E,0x2A0C,0x10F0,0xF020,
	0x2A26,0x5050,0xF05C,0x500D,0xF020,0x2A27,0x10F0,0xF020,
	0x2A0C,0xF02E,0x2A19,0x04F0,0x5C50,0x0BF0,0x2050,0x27F0,
	0xF02A,0x2010,0x3EF0,0x502A,0x5C50,0x03F0,0x2050,0x03F0,
	0x502A,0x5C50,0x07F0,0x2050,0x23F0,0xF02A,0x2006,0x04F0,
	0xF02A,0x200A,0x1EF0,0xF02A,0x2018,0x6353,0x6572,0x6E65,
	0x53F0,0xDA20,0x20C4,0x654D,0x756E,0x6220,0x7261,0xF020,
	0xC410,0xF0BF,0x201A,0x20B3,0x205B,0x205D,0x6144,0x6574,
	0x06F0,0x5B20,0x5D20,0x5420,0x6D69,0xF065,0x2004,0xF0B3,
	0x2005,0x6445,0x7469,0x6120,0x7474,0x6972,0xF062,0x2003,
	0xF0DC,0x2006,0xF0C0,0xC41B,0xF0D9,0x2004,0x10F0,0xF0DF,
	0x2006,0xC4DA,0x5320,0x6174,0x646E,0x7261,0x2064,0x6F63,
	0x6F6C,0x2072,0x0AF0,0xBFC4,0x05F0,0x4520,0x6964,0x2074,
	0x6170,0x656C,0x7474,0x2065,0xDC20,0x06F0,0xB320,0x2820,
	0x2920,0x4E20,0x7661,0xF079,0x2006,0x2028,0x2029,0x6552,
	0xF064,0x2005,0xF0B3,0x2004,0x10F0,0xF0DF,0x2006,0x20B3,
	0x2028,0x2029,0x7247,0x6565,0xF06E,0x2005,0x2028,0x2029,
	0x6C42,0x6361,0xF06B,0x2003,0xC4C3,0xF0C4,0x2003,0x6553,
	0x2074,0x7473,0x6E61,0x6164,0x6472,0x2020,0xF0DC,0x2006,
	0x20B3,0x2028,0x2029,0x6559,0x6C6C,0x776F,0x04F0,0x2820,
	0x2907,0x4420,0x6665,0x7561,0x746C,0xB320,0x04F0,0xF020,
	0xDF10,0x06F0,0xC020,0xC4C4,0xF0C2,0xC418,0xF0D9,0x2005,
	0x6F4C,0x6461,0x6320,0x6C6F,0x726F,0x04F0,0xDC20,0x06F0,
	0xDA20,0xC4C4,0xF0C1,0xC418,0xF0BF,0x2004,0x10F0,0xF0DF,
	0x2006,0x20B3,0x205B,0x205D,0x7355,0x2065,0x7267,0x7061,
	0x6968,0x6163,0x206C,0x6F63,0x6F6C,0x7372,0x2020,0xF0B3,
	0x2005,0x6153,0x6576,0x6320,0x6C6F,0x726F,0x04F0,0xDC20,
	0x06F0,0xC020,0x1BF0,0xD9C4,0x04F0,0xF020,0xDF10,0x40F0,
	0x4F20,0x206B,0xDC20,0x05F0,0x4320,0x6E61,0x6563,0x206C,
	0xDC20,0x23F0,0xF020,0xDF06,0x04F0,0xF020,0xDF0A,0x1EF0,
	0x2A20,
}; //	690 byte
ROBJ *IDD_Screen = (ROBJ *)&Screen_RC;
/******** Resource end   Screen */
