/*
 * CMOPTION.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dzmain.h>

enum {	P_INSMOVDN,
	P_SELECTDIR,
	P_CDCLRRDONLY,
	P_OK,
	P_CANCEL,
	P_COUNT		};

int cmpanel(void)
{
	DOBJ *d;
	TOBJ *o;

	if ((d = rsopen(IDD_Panel)) == 0)
		return 0;
/*** Init Dialog ***/
	o = &d->object[P_INSMOVDN];
	if (cflag & _C_INSMOVDN)
		o[P_INSMOVDN].flag |= _O_FLAGB;
	if (cflag & _C_SELECTDIR)
		o[P_SELECTDIR].flag |= _O_FLAGB;
	if (cflag & _C_CDCLRDONLY)
		o[P_CDCLRRDONLY].flag |= _O_FLAGB;
	tdinit(d);
/*** Get result ***/
	if (rsevent(IDD_Panel, d)) {
		cflag &= ~(_C_INSMOVDN|_C_SELECTDIR|_C_HORIZONTAL|_C_CDCLRDONLY);
		if (o[P_INSMOVDN].flag & _O_FLAGB)
			cflag |= _C_INSMOVDN;
		if (o[P_SELECTDIR].flag & _O_FLAGB)
			cflag |= _C_SELECTDIR;
		if (o[P_CDCLRRDONLY].flag & _O_FLAGB)
			cflag |= _C_CDCLRDONLY;
		tdclose(d);
		return 1;
	}
	tdclose(d);
	return 0;
}

enum {	CO_COPY,
	CO_MOVE,
	CO_DELETE,
	CO_DELSUBDIR,
	CO_DELSYSTEM,
	CO_DELHIDDEN,
	CO_EXIT,
	CO_OK,
	CO_CANCEL,
	CO_COUNT	};

int cmconfirm(void)
{
	DOBJ *d;

	if ((d = rsopen(IDD_Confirm)) == NULL)
		return 0;
	tdsetbitflag(d->object, CO_OK, _O_FLAGB, config.confirm);
	tdinit(d);
	if (rsevent(IDD_Confirm, d) != 0)
		config.confirm = tdgetbitflag(d->object, CO_OK, _O_FLAGB);
	twclose(d);
	return 0;
}

enum {  D_SCREEN,
	D_PANELS,
	D_CONFIRM,
	D_COMPRESS,
	D_AUTOSAVE,
	D_SAVECMD,
	D_OK,
	D_CANCEL,
	D_COUNT		};

int cmoptions(void)
{
	DOBJ *d;
	TOBJ *o;
	int result;

	if ((d = rsopen(IDD_Configuration)) == 0)
		return 0;
/*** Init Dialog ***/
	o = d->object;
	o[D_SCREEN].proc = cmscreen;
	o[D_PANELS].proc = cmpanel;
	o[D_CONFIRM].proc = cmconfirm;
	o[D_COMPRESS].proc = cmcompression;
	if (cflag & _C_AUTOSAVE)
		o[D_AUTOSAVE].flag |= _O_FLAGB;
	if ((cflag & _C_SAVEDZCMD) == 0)
		o[D_SAVECMD].flag |= _O_FLAGB;
	tdinit(d);
	result = rsevent(IDD_Configuration, d);
	if (result) {
		cflag &= ~(_C_AUTOSAVE | _C_SAVEDZCMD);
		if (o[D_AUTOSAVE].flag & _O_FLAGB)
			cflag |= _C_AUTOSAVE;
		if (!(o[D_SAVECMD].flag & _O_FLAGB))
			cflag |= _C_SAVEDZCMD;
	}
	tdclose(d);
	if (result)
		redraw_panels();
	return result;
}

/******** Resource begin Configuration *
	{ 0x041C,   8,   7, {11, 3,58,19} },
	{ 0x4000,   0, 'S', { 4, 2,17, 1} },
	{ 0x4000,   0, 'P', { 4, 4,17, 1} },
	{ 0x4000,   0, 'F', { 4, 6,17, 1} },
	{ 0x4000,   0, 'M', { 4, 8,17, 1} },
	{ 0x0002,   0, 'A', { 6,11,19, 1} },
	{ 0x0002,   0, 'H', {29,11,23, 1} },
	{ 0x0000,   0, 'O', { 4,17, 6, 1} },
	{ 0x0200,   0, 'C', {14,17,10, 1} },
********* Resource data  *******************/
static int Configuration_RC[] = {
	0x098A,0x041C,0x0708,0x030B,0x133A,0x4000,0x5300,0x0204,
	0x0111,0x4000,0x5000,0x0404,0x0111,0x4000,0x4600,0x0604,
	0x0111,0x4000,0x4D00,0x0804,0x0111,0x0002,0x4100,0x0B06,
	0x0113,0x0002,0x4800,0x0B1D,0x0117,0x0000,0x4F00,0x1104,
	0x0106,0x0200,0x4300,0x110E,0x010A,0x3AF0,0xF050,0x2A3E,
	0x5050,0xF05C,0x500E,0xF020,0x2A29,0x11F0,0xF020,0x2A28,
	0x5050,0xF05C,0x500E,0xF020,0x2A29,0x11F0,0xF020,0x2A28,
	0x05F0,0x5C50,0x0BF0,0x2050,0x29F0,0xF02A,0x2011,0x28F0,
	0xF02A,0x5004,0xF05C,0x500C,0xF020,0x2A29,0x11F0,0xF020,
	0x2A68,0xF02E,0x2A22,0xF13F,0x2A32,0x5050,0xF05C,0x5003,
	0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,0x2A26,0x06F0,
	0xF020,0x2A04,0x0AF0,0xF020,0x2A21,0x16F0,0x4320,0x6E6F,
	0x6966,0x7567,0x6172,0x6974,0x6E6F,0x57F0,0x5320,0x7263,
	0x6565,0xF06E,0x2009,0x20DC,0x6553,0x656C,0x7463,0x7320,
	0x7263,0x6565,0x206E,0x706F,0x6974,0x6E6F,0xF073,0x2013,
	0x11F0,0xF0DF,0x202A,0x6150,0x656E,0x206C,0x704F,0x6974,
	0x6E6F,0x2073,0xDC20,0x4320,0x6E6F,0x6966,0x7567,0x6572,
	0x4320,0x6D6F,0x616D,0x646E,0x7265,0x5020,0x6E61,0x6C65,
	0xF073,0x200E,0x11F0,0xF0DF,0x202A,0x6F43,0x666E,0x7269,
	0x616D,0x6974,0x6E6F,0x2073,0xDC20,0x5320,0x7465,0x522F,
	0x7365,0x7465,0x5020,0x6F72,0x7267,0x6D61,0x5020,0x6F72,
	0x706D,0x7374,0x0FF0,0xF020,0xDF11,0x2AF0,0x4320,0x6D6F,
	0x7270,0x7365,0x6973,0x6E6F,0x04F0,0xDC20,0x4320,0x6E6F,
	0x6966,0x7567,0x6572,0x4320,0x6D6F,0x616D,0x646E,0x7265,
	0x4320,0x6D6F,0x7270,0x7365,0x6973,0x6E6F,0x09F0,0xF020,
	0xDF11,0x28F0,0xDA20,0x30F0,0xBFC4,0x08F0,0xB320,0x5B20,
	0x5D20,0x4120,0x7475,0x206F,0x6173,0x6576,0x7320,0x7465,
	0x7075,0x04F0,0x5B20,0x5D20,0x4120,0x7475,0x206F,0x6564,
	0x656C,0x6574,0x4820,0x7369,0x6F74,0x7972,0xB320,0x08F0,
	0xC020,0x30F0,0xD9C4,0x09F0,0x4E20,0x746F,0x3A65,0x4320,
	0x6568,0x6B63,0x7420,0x6568,0x4120,0x7475,0x206F,0x6173,
	0x6576,0x6320,0x6568,0x6B63,0x6220,0x786F,0x7420,0x206F,
	0x7561,0x6F74,0x7320,0x7661,0xF065,0x2010,0x6874,0x2065,
	0x6F63,0x666E,0x6769,0x7275,0x7461,0x6F69,0x2E6E,0x5920,
	0x756F,0x6320,0x6E61,0x6D20,0x6E61,0x6175,0x6C6C,0x2079,
	0x6173,0x6576,0x12F0,0x7920,0x756F,0x2072,0x6F63,0x666E,
	0x6769,0x7275,0x7461,0x6F69,0x206E,0x7962,0x7020,0x6572,
	0x7373,0x6E69,0x2067,0x6853,0x6669,0x2B74,0x3946,0xF02E,
	0x2047,0x6B4F,0x2020,0xF0DC,0x2005,0x6143,0x636E,0x6C65,
	0x2020,0xF0DC,0x2026,0x06F0,0xF0DF,0x2004,0x0AF0,0xF0DF,
	0x2021,0x2A2A,
}; //	644 byte
ROBJ *IDD_Configuration = (ROBJ *)&Configuration_RC;
/******** Resource end   Configuration */

/******** Resource begin Confirm *
	{ 0x041C,   9,   7, {36, 5,30,14} },
	{ 0x0002,   0, 'P', { 5, 3, 8, 1} },
	{ 0x0002,   0, 'M', { 5, 4, 8, 1} },
	{ 0x0002,   0, 'D', { 5, 5,10, 1} },
	{ 0x0002,   0, 'R', { 5, 6,20, 1} },
	{ 0x0002,   0, 'S', { 5, 7,17, 1} },
	{ 0x0002,   0, 'H', { 5, 8,17, 1} },
	{ 0x0002,   0, 'E', { 5, 9,16, 1} },
	{ 0x0000,   0, 'O', { 4,12, 6, 1} },
	{ 0x0200,   0, 'C', {13,12,10, 1} },
********* Resource data  *******************/
static int Confirm_RC[] = {
	0x0420,0x041C,0x0709,0x0524,0x0E1E,0x0002,0x5000,0x0305,
	0x0108,0x0002,0x4D00,0x0405,0x0108,0x0002,0x4400,0x0505,
	0x010A,0x0002,0x5200,0x0605,0x0114,0x0002,0x5300,0x0705,
	0x0111,0x0002,0x4800,0x0805,0x0111,0x0002,0x4500,0x0905,
	0x0110,0x0000,0x4F00,0x0C04,0x0106,0x0200,0x4300,0x0C0D,
	0x010A,0x1EF0,0xF050,0x2A47,0xF02E,0x2A1B,0xF02E,0x2A1D,
	0xF02E,0x2A26,0xF02E,0x2A1B,0xF02E,0x2A1D,0xF02E,0x2A16,
	0xF02E,0x2A54,0x5B5B,0xF05C,0x5B03,0x2A20,0x502A,0x5C50,
	0x07F0,0x2050,0x0BF0,0xF02A,0x2006,0x03F0,0xF02A,0x200A,
	0x06F0,0xF02A,0x200B,0x6F43,0x666E,0x7269,0xF06D,0x202D,
	0xC4DA,0x4320,0x6E6F,0x6966,0x6D72,0x7461,0x6F69,0x736E,
	0xF020,0xC406,0xF0BF,0x2006,0x20B3,0x205B,0x205D,0x6F43,
	0x7970,0x0DF0,0xB320,0x06F0,0xB320,0x5B20,0x5D20,0x4D20,
	0x766F,0xF065,0x200D,0xF0B3,0x2006,0x20B3,0x205B,0x205D,
	0x6544,0x656C,0x6574,0x0BF0,0xB320,0x06F0,0xB320,0x5B20,
	0x5D20,0x4420,0x6C65,0x7465,0x2065,0x6944,0x6572,0x7463,
	0x726F,0x2079,0xF0B3,0x2006,0x20B3,0x205B,0x205D,0x6544,
	0x656C,0x6574,0x5320,0x7379,0x6574,0xF06D,0x2004,0xF0B3,
	0x2006,0x20B3,0x205B,0x205D,0x6544,0x656C,0x6574,0x4820,
	0x6469,0x6564,0xF06E,0x2004,0xF0B3,0x2006,0x20B3,0x205B,
	0x205D,0x7845,0x7469,0x5020,0x6F72,0x7267,0x6D61,0x05F0,
	0xB320,0x06F0,0xC020,0x16F0,0xD9C4,0x27F0,0x4F20,0x206B,
	0xDC20,0x04F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,0x0BF0,
	0xF020,0xDF06,0x03F0,0xF020,0xDF0A,0x06F0,0x2A20,
}; //	382 byte
ROBJ *IDD_Confirm = (ROBJ *)&Confirm_RC;
/******** Resource end   Confirm */

/******** Resource begin Panel *
	{ 0x041C,   5,   3, {29, 6,37, 9} },
	{ 0x0002,   0, 'I', { 5, 3,21, 1} },
	{ 0x0002,   0, 'S', { 5, 4,22, 1} },
	{ 0x0002,   0, 'L', { 5, 5,27, 1} },
	{ 0x0000,   0, 'O', { 4, 7, 6, 1} },
	{ 0x0200,   0, 'C', {13, 7,10, 1} },
********* Resource data  *******************/
static int Panel_RC[] = {
	0x032F,0x041C,0x0305,0x061D,0x0925,0x0002,0x4900,0x0305,
	0x0115,0x0002,0x5300,0x0405,0x0116,0x0002,0x4C00,0x0505,
	0x011B,0x0000,0x4F00,0x0704,0x0106,0x0200,0x4300,0x070D,
	0x010A,0x25F0,0xF050,0x2A53,0xF02E,0x2A24,0xF02E,0x2A25,
	0xF02E,0x2A43,0x5B5B,0xF05C,0x5B03,0x2A20,0x502A,0x5C50,
	0x07F0,0x2050,0x12F0,0xF02A,0x2006,0x03F0,0xF02A,0x200A,
	0x0DF0,0xF02A,0x2010,0x6150,0x656E,0xF06C,0x2038,0xC4DA,
	0x5020,0x6E61,0x6C65,0x4F20,0x7470,0x6F69,0x736E,0xF020,
	0xC40D,0xF0BF,0x2006,0x20B3,0x205B,0x205D,0x6E49,0x6573,
	0x7472,0x6D20,0x766F,0x7365,0x6420,0x776F,0xF06E,0x2007,
	0xF0B3,0x2006,0x20B3,0x205B,0x205D,0x6553,0x656C,0x7463,
	0x4420,0x7269,0x6365,0x6F74,0x6972,0x7365,0x06F0,0xB320,
	0x06F0,0xB320,0x5B20,0x5D20,0x4320,0x656C,0x7261,0x7220,
	0x6165,0x2064,0x6E6F,0x796C,0x6620,0x6F72,0x206D,0x4443,
	0xB320,0x06F0,0xC020,0x1DF0,0xD9C4,0x09F0,0x4F20,0x206B,
	0xDC20,0x04F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,0x12F0,
	0xF020,0xDF06,0x03F0,0xF020,0xDF0A,0x0DF0,0x2A20,
}; //	270 byte
ROBJ *IDD_Panel = (ROBJ *)&Panel_RC;
/******** Resource end   Panel */
