/*
 * CMGLOBAL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <errno.h>
#include <dzmain.h>

int notsup(void)
{
	ermsg(NULL, sys_errlist[ENOSYS]);
	return 0;
}

int ccell_edit(int __do_copy);
int cmcopycell(void) /* Shift+F2 */
{
	return ccell_edit(1);
}

int cmrename(void) /* F2 */
{
	return ccell_edit(0);
}

int cmclrcmdl(void) /* Ctrl+Esc */
{
	com.base[0] = 0;
	com_initline();
	return com_hndevent(HOME);
}

int cmctrlenter(void) /* Ctrl+Enter */
{
	fblk *b;

	if ((b = panel_curobj(cpanel)) == NULL)
		return 0;
	if (ISUPDIR(b->flag))
		return 0;
	if (com.ti.bp[0])
		strcat(com.ti.bp, " ");
	strcat(com.ti.bp, b->name);
	return com_hndevent(END);
}

int cmupdir(void) /* Ctrl+PgUp */
{
	fblk *b;

	if (panel_state(cpanel) == 0)
		return 0;
	panel_hndevent(cpanel, HOME);
	b = cpanel->ide->fcb[0];
	if (!ISUPDIR(b->flag))
		return 0;
	return panel_hndevent(cpanel, ENTER);
}

int cmsubdir(void) /* Ctrl+PgDn */
{
	fblk *b;

	if ((b = panel_curobj(cpanel)) == NULL)
		return 0;
	if (!ISSUBDIR(b->flag))
		return 0;
	return panel_hndevent(cpanel, ENTER);
}

int cmpanelsize(void)
{
	return cmtogglesz();
}

static int cmpath(int id)
{
	char *p,*q;
	char b[WMAXPATH];
	WSUB *w;

	if (panel_state(cpanel) == 0)
		return 0;
	if ((p = inientryid(cp_directory, id)) == NULL)
		return 0;
	if (p[0] == '<' && p[1] == '>')
		return 0;
	if ((q = strchr(p, ',')) == NULL)
		return 0;
	strncpy(b, strstart(q + 1), WMAXPATH);
	ex_convert(b);
	if (*b != '[') {
		w = cpanel->ide;
		strcpy(w->path, b);
		panel_update_fcb(cpanel);
		com_setdevice(cpanel->ide);
		return 1;
	}
	return 0;
}

int cmpath0(void) { return cmpath(0); }
int cmpath1(void) { return cmpath(1); }
int cmpath2(void) { return cmpath(2); }
int cmpath3(void) { return cmpath(3); }
int cmpath4(void) { return cmpath(4); }
int cmpath5(void) { return cmpath(5); }
int cmpath6(void) { return cmpath(6); }
int cmpath7(void) { return cmpath(7); }
int cmpath8(void) { return cmpath(8); }
int cmpath9(void) { return cmpath(9); }

