/* WSADDENT.C--
 * Copyright (c) 1996-2008 Hjort Nidudsson
 *
 * Change history:
 * 29 Oct 2008	- Function to add a file block from archive
 */

#include <arch.h>
#include <string.h>
#include <alloc.h>

FBLK *wsaddentry(WSUB *ws, WORD flag, WORD time, WORD date, DWORD size)
{
	int x;
	char *p;
	FBLK *b;

	if ((x = strlen(ws->arch)) != 0) {
		if (strnicmp(entryname, ws->arch, x) != 0)
			goto out_null;
		if (x >= strlen(entryname))
			goto out_null;
		if (entryname[x] != '\\')
			goto out_null;
		strcpy(entryname, &entryname[x + 1]);
	}
	if ((p = strchr(entryname, '\\')) != NULL) {
		*p = '\0';
		flag |= _A_SUBDIR;
		if (wsearch(ws, entryname) == -1)
			goto out_new;
		goto out_null;
	}
	if ((x = wsearch(ws, entryname)) != -1) {
		/* Update a previous added SUBDIR */
		ws->fcb[x]->date = date;
		ws->fcb[x]->time = time;
		ws->fcb[x]->flag = flag;
		goto out_null;
	}
out_new:
	if (!ISSUBDIR(flag) && cmpwarg(entryname, ws->mask) == 0)
		goto out_null;
	if (!(b = (FBLK *)malloc(strlen(entryname) + sizeof(FBLK) + 12)))
		goto out_null;
	b->flag = _A_ARCH | flag;
	b->size = size;
	b->date = date;
	b->time = time;
	strcpy(b->name, entryname);
	ws->fcb[ws->count] = b;
	return b;
out_null:
	return NULL;
}
