; CLIP.ASM--
; Copyright (c) 1996 Hjort Nidudsson
;
include		clib.inc
include		clip.inc
include		alloc.inc
include		string.inc

_DATA		SEGMENT

WINOLDAP        DW	0000h
Clipbsize	DW	0000h
Clipboard	DD	00000000h

_DATA		ENDS

_TEXT		SEGMENT

		.386p

CLEARCLIPBOARD:	xor	eax,eax
		mov	Clipbsize,ax
		cmp	eax,Clipboard
		je	SHORT @@toend
		push	Clipboard
		mov     Clipboard,eax
		call	free
@@toend:	ret

INT_2F:		xor	ax,ax
		cmp	WINOLDAP,ax
		je	SHORT @@toend
		mov	ax,dx
		int	2Fh
@@toend:	ret

_TEXT		ENDS

PPROC		ClipboardFree
		call	CLEARCLIPBOARD
		ret
PEND            ClipboardFree

PPROC		ClipboardInit
		xor	ax,ax
		mov	WINOLDAP,ax
		mov	ax,1700h
		int	2Fh
		mov	dx,ax
		xor	ax,ax		; AX <> 1700h
		cmp	dx,1700h        ; - AL = WINOLDAP major version
		jz	SHORT @@toend	; - AH = WINOLDAP minor version
		mov	WINOLDAP,dx
@@toend:	inc	ax
		ret
PEND		ClipboardInit

PPROC		ClipboardOpen
		mov	dx,1701h
		call	INT_2F
		xor	ax,ax
		inc	ax
		ret
PEND		ClipboardOpen

PPROC		ClipboardClose
		mov	dx,1708h
		call	INT_2F
		ret
PEND		ClipboardClose

PPROC		ClipboardEmpty
		mov	dx,1702h
		call	INT_2F
		call	CLEARCLIPBOARD
		ret
PEND 		ClipboardEmpty

PPROC		ClipboardCopy
ARG		string:	DWORD,\
		length:	WORD
		call	CLEARCLIPBOARD
		xor	ax,ax
		cmp	WINOLDAP,ax
		je	SHORT @@alloc
		mov	dx,1		; set type to text
		mov	cx,length	; SI:CX = size of data
		push	si
		mov	si,ax		; HSIZE = 0
		les	bx,string	; ES:BX = data
		mov	ax,1703h
		int	2Fh
		pop	si
		or	ax,ax
		jnz	SHORT @@toend
@@alloc:	mov	ax,length
		inc	ax
		push	ax
		call	malloc
		jz	SHORT @@toend
		mov	Clipboard,eax
		push	eax
		mov	es,dx
		mov	bx,ax
		mov	ax,length
		mov	Clipbsize,ax
		push	string
		push	ax
		add	bx,ax
		xor	al,al
		mov	es:[bx],al
		call	memcpy
@@toend:	ret
PEND 		ClipboardCopy

PPROC		ClipboardPaste
		xor	dx,dx
		cmp	WINOLDAP,dx
		je	SHORT @@local
		inc	dx
		mov	ax,1704h
		int	2Fh
		or	dx,dx
		jnz	SHORT @@local
		or	ax,ax
		jz	SHORT @@local
		cmp	ax,MAXCLIPSIZE
		jae	SHORT @@local
		push	ax
		push	ax
		call	CLEARCLIPBOARD
		call	malloc
		pop	dx
		jz	SHORT @@toend
		mov	Clipbsize,dx
		mov	Clipboard,eax
		push	eax
		push	dx
		call	memzero
		mov	dx,1
		les	bx,Clipboard
		mov	ax,1705h
		;push	si
		int	2Fh
		;pop	si
@@clipboard:	mov	ax,WORD PTR Clipboard
		mov	dx,WORD PTR Clipboard+2
		jmp	SHORT @@toend
@@local:	xor	ax,ax
		mov	dx,ax
		cmp	ax,Clipbsize
		jne	SHORT @@clipboard
@@toend:	push	dx
		push	ax
		pop	eax
		or	ax,ax
		ret
PEND 		ClipboardPaste

PPROC		ClipboardSize
		xor	dx,dx
		cmp	WINOLDAP,dx
		je	SHORT @@local
		inc	dx
		mov	ax,1704h
		int	2Fh
		or	dx,dx
		jz	SHORT @@toend
@@local:	mov	ax,Clipbsize
@@toend:	xor	dx,dx
		ret
PEND 		ClipboardSize

		END