/* OOPEN.C--
 * Copyright (c) 2008 Hjort Nidudsson
 *
 * Change history:
 * 10 Nov 2008	- Created
 */

#include <io.h>
#include <arch.h>
#include <iost.h>

int oopen(const char *file, int mode)
{
	int h;

	if (mode == M_RDONLY)
		h = openfile(file, M_RDONLY, A_OPEN);
	else
		h = getouthandle(file);
	if (h < 1) /* 0 = skip file, -1 = error */
		return h;
	if (mode == M_RDONLY) {
		if (oinitst(OSTDI) == 0) {
			close(h);
			return -1;
		}
		STDI.file = h;
	} else {
		if (oinitst(OSTDO) == 0) {
			close(h);
			return -1;
		}
		STDO.file = h;
	}
	return h;
}
