/*
 * WSRDZIP.C - Read files and directories from .ZIP archive
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <alloc.h>
#include <string.h>
#include <arch.h>

#define zattrib(w, a) (w = (((WORD)a&_A_FATTRIB) | zip_attrib))

unsigned int	zip_attrib;
static int 	ff_handle = -1;
static CZIP 	ff_entry;

static void 	wzipclose(void);
static FBLK *	wzipalloc(CZIP *, int);
static int 	wzipreadentry(CZIP *);
static int 	wzipcompare(WSUB *);
static FBLK *	wzipfindfirst(WSUB *, ZCEN *);
static FBLK *	wzipfindnext(WSUB *);

void wzipclose(void)
{
	if (ff_handle != -1) {
		close(ff_handle);
		ff_handle = -1;
	}
}

FBLK *wzipalloc(CZIP *ff, int flag)
{
	FBLK *	b;
	DWORD *	wp;
	char *	cp;
	int 	size;

	size = strlen(entryname) + sizeof(FBLK);
	if (!(b = (FBLK *)malloc(size + 12)))
		return NULL;
	if (flag == 2) {
		if (ff->version_made == 0 && ISSUBDIR((int)ff->ext_attrib))
			zattrib(b->flag, ff->ext_attrib);
		else
			zattrib(b->flag, _A_SUBDIR);
	} else {
		zattrib(b->flag, ff->ext_attrib);
		b->size = ff->fsize;
	}
	b->date = ff->date;
	b->time = ff->time;
	strcpy(b->name, entryname);
	cp = (char*)b + size;
	wp = (DWORD*)cp;
	wp[0] = ff->offset_local;
	wp[1] = ff->crc;
	wp[2] = ff->csize;
	return b;
}

int wzipreadentry(CZIP *z)
{
	if (osread(ff_handle , z, sizeof(CZIP)) != sizeof(CZIP))
		return 0;
	if (z->signature != ZID_CENTRAL)
		return 0;
	if (osread(ff_handle, entryname, z->fnsize) != z->fnsize)
		return 0;
	zip_attrib = _A_ZIP | _A_ARCH;
	if (z->bitflag & 1)
		zip_attrib |= _A_ENCRYPTED;
	if (z->bitflag & 8)
		zip_attrib |= _A_EXTLOCHD;
	entryname[z->fnsize] = 0;
	if (entryname[z->fnsize - 1] == '/')
		entryname[z->fnsize - 1] = 0;
	if (z->extsize + z->cmtsize)
		lseek(ff_handle, z->extsize + z->cmtsize, SEEK_CUR);
	unixtodos(entryname);
	return 1;
}

int wzipcompare(WSUB *w)
{
	int x;
	char *q;

	q = w->arch;
	x = strlen(q);
	if (x > 0 && strnicmp(entryname, q, x) != 0)
		return 0;
	if (x >= strlen(entryname))
		return 0;
	if (x && entryname[x] != '\\')
		return 0;
	if (x > 0)
		strcpy(entryname, &entryname[x + 1]);
	if (entryname[0] == ',')
		strcpy(entryname, &entryname[1]);
	if ((q = strchr(entryname, '\\')) != NULL) {
		*q = 0;
		if (wsearch(w, entryname) == -1)
			return 2;
		return 0;
	}
	if ((x = wsearch(w, entryname)) != -1) {
		w->fcb[x]->date = ff_entry.date;
		w->fcb[x]->time = ff_entry.time;
		if (ff_entry.version_made == 0)
			zattrib(w->fcb[x]->flag, ff_entry.ext_attrib);
		return 0;
	}
	return 1;
}

FBLK *wzipfindnext(WSUB *w)
{
	int q;
	CZIP *z = &ff_entry;

	if (wzipreadentry(z) != 0) do {
		if ((q = wzipcompare(w)) == 0)
			continue;
		return wzipalloc(z, q);
	} while (wzipreadentry(z) != 0);
	return NULL;
}

FBLK *wzipfindfirst(WSUB *w, ZCEN *zc)
{
	if ((ff_handle = wsopenarch(w)) == -1)
		return NULL;
	lseek(ff_handle, zc->offset_sd, SEEK_SET);
	return wzipfindnext(w);
}

int wzipread(WSUB *q)
{
	FBLK *b;
	ZCEN z;

	wsfree(q);
	if (wzipgetendcentral(q, &z))
		return ARCHIVE_ERROR;
	q->fcb[0] = fbupdir(_A_ZIP);
	q->count = 1;
	if ((b = wzipfindfirst(q, &z)) != NULL) {
		do {
			if (ISSUBDIR(b->flag) == 0 &&
				cmpwarg(b->name, q->mask) == 0) {
				free(b);
				continue;
			}
			q->fcb[q->count] = b;
			if (++q->count >= q->maxfb)
				break;
		} while ((b = wzipfindnext(q)) != NULL);
	}
	wzipclose();
	return q->count;
}
