/*
 * OPENTEMP.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <string.h>

char *arc_maketemp(char *tmp)
{
	char *q;

	strcpy(tmp, __outfile);
	if ((q = strrchr(tmp, '.')) == NULL)
		return strcat(tmp, ARCTEMP_EXT);
	strcpy(q, ARCTEMP_EXT);
	return tmp;
}

int arc_renametemp(void)
{
	char tmp[WMAXPATH];

	arc_maketemp(tmp);
	if (strcmp(tmp, __outfile) && filexist(tmp) == 1) {
		remove(__outfile);
		return rename(tmp, __outfile); /* --> 0 or -1 */
	}
	return -1;
}

int arc_opentemp(void)
{
	char tmp[WMAXPATH];

	return getouthandle(arc_maketemp(tmp));
}

int arc_deltemp(void)
{
	char tmp[WMAXPATH];

	return remove(arc_maketemp(tmp));
}
