/* GZIPREAD.C--
 * Copyright (c) 2007 Hjort Nidudsson
 *
 * Change history:
 * 04 Apr 2007	- Created
 */

#include <alloc.h>
#include <string.h>
#include <arch.h>

int wgzread(WSUB *q)
{
	int 	x;
	GZIP 	z;
	FBLK *	b;

	wsfree(q);
	if (openarch(q->path, q->file) == 0)
		return 0;
	if (oread(&z, sizeof(GZIP) - 8) != sizeof(GZIP) - 8
		|| z.magic != GZ_HEADERID) {
		oclose(OSTDI);
		return 0;
	}
	if ((z.flag & GZ_CONTINUATION) != 0)
		_ios[__STDI].i += 2;
	if ((z.flag & GZ_EXTRA_FIELD) != 0) {
		oread(&x, 2);
		oseek(x, SEEK_CUR);
	}
	oread(entryname, ARCMAXFNAME);
	oseek(0L/*-4*/, SEEK_END);
	/*oread(&z.crc, 4);*/
	q->count  = 1;
	q->fcb[0] = fbupdir(_A_GZ);
	x = strlen(entryname) + sizeof(FBLK);
	if ((b = (FBLK *)malloc(x)) != NULL) {
		strcpy(b->name, entryname);
		b->flag = _A_GZ | _A_ARCH;
		b->size = _ios[__STDI].offs/*+4*/;
		b->time = 0;
		b->date = 0;
		q->fcb[1] = b;
		q->count++;
	}
	oclose(OSTDI);
	return q->count;
}
