; OUPDCRC.ASM -- update CRC value
;
; if compress --> read bytes, write bits (use ios_bb as CRC)
; else        --> read bits, write bytes (update CRC on write)
;
; ARG   	AX	= size of buffer
; 		DX	= start offset in ->bp
;               DS:SI	= IOST

INCLUDE 	clib.inc
INCLUDE 	iost.inc

		extrn	crctab: DWORD

_TEXT		SEGMENT
		PUBLIC	oupdcrc

oupdcrc:	push	di
		mov	cx,ax		; size to update
		les	bx,[si.ios_bp]
		add	bx,dx		; update from read offset
		mov	edx,[si.ios_bb]	; current CRC value
@@crc:		xor	ax,ax		; update CRC value
		mov	al,dl
		xor	al,ES:[bx]
		shl	ax,2
		mov	di,ax
		mov	eax,[di.crctab]
		shr	edx,8
		xor	eax,edx
		mov	edx,eax
		inc	bx
		dec	cx
		jnz	short @@crc
		mov	[si.ios_bb],edx	; save CRC value
		pop	di
		ret

_TEXT		ENDS

		END
