/* DZIP.H--
 * Copyright (c) 2008 Hjort Nidudsson
 *
 * Change history:
 * 29 Oct 2008	- Created
 */
#ifndef __INC_DZIP
#define __INC_DZIP

#include <iost.h>
#include <wsub.h>

#define DZIPID		0x5A44

#define M0_STORE	0x0000
#define M1_FAST		0x0040
#define M2_EXTRA	0x0080
#define M3_MAXIMUM	0x00C0

#define _DZENCRYPTED	0x0200
#define _DZCENTRALID	0x4000
#define _DZLOCALID	0x8000

#define __WINA		2
#define __WINB		3
#define __CLEN		4
#define __COFF		5
#define __CO01		6
#define __CBUF		7
#define __CB01		8
#define __CB02		9

#define OWINA		((WORD)&_ios[__WINA])
#define OWINB		((WORD)&_ios[__WINB])
#define OCLEN		((WORD)&_ios[__CLEN])
#define OCOFF		((WORD)&_ios[__COFF])
#define OCO01		((WORD)&_ios[__CO01])
#define OCBUF		((WORD)&_ios[__CBUF])
#define OCB01		((WORD)&_ios[__CB01])
#define OCB02		((WORD)&_ios[__CB02])

#define DBITS		14
#define DSIZE		(WORD)(1 << DBITS)
#define CSIZE		(DSIZE << 1)
#define LSIZE		(CSIZE >> 1)

#define CBITS		6
#define CODELENGTHS	(WORD)(1 << CBITS)
#define CODEWINDOWB	(CODELENGTHS - 1)

#define DZIP_DATA	0
#define DZIP_CODE	1
#define DZIP_BYTE	2
#define DZIP_FEOF	3

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct { /* Local file header */
	WORD	ID;
	WORD	flag;
      } DZIPL; /* 4 byte */

typedef struct { /* Central file header */
	WORD	ID;
	WORD	flag;
	WORD	time;
	WORD	date;
	DWORD	size;
	WORD	name;
	DWORD	offset;
	DWORD	csize;
	DWORD	crc;
/*	[file name (variable size)] */
      } DZIPC; /* 26 byte */

typedef struct end_central_directory { /* End of central directory record */
	WORD	ID;
	WORD	version;
	DWORD	count;	/* entries in the central directory */
	DWORD	offset;	/* offset to start central directory */
      }	DZIPE;

int _CType dzipread(WSUB *);
int _CType dzipdel(WSUB *, FBLK *);
int _CType dzipadd(long __size, int __date, int __time, char __attrib);
int _CType dzipren(const char *__newname, WORD __newattrib);
int _CType dzipcopy(WSUB *, FBLK *, const char *__destpath);

FBLK * _CType wsaddentry(WSUB *, WORD __flag, WORD __time, WORD __date, DWORD);

extern int _CType clengths[CODELENGTHS];

#ifdef __cplusplus
 }
#endif
#endif