/*
 * FBALLOCW.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <fblock.h>
#include <string.h>
#include <alloc.h>

FBLK *fballocwf(const wfblk *ff, int flag)
{
	int size;
	FBLK *b;

	size = strlen(ff->name) + sizeof(FBLK);
	if (!(b = (FBLK *)malloc(size)))
		return NULL;

	b->flag = flag | (ff->attrib & _A_FATTRIB);
	b->size = ff->size_low;
	if (ISSUBDIR(b->flag)) {
		b->date = ff->date_create;
		b->time = ff->time_create;
	} else {
		b->date = ff->date_modified;
		b->time = ff->time_modified;
	}
	strcpy(b->name, ff->name);
	if (ISSUBDIR(b->flag) && stricmp(b->name, "..") == 0)
		b->flag |= _A_UPDIR;

	return b;
}