/*
 * _TINFO.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC__TINFO
#define __INC__TINFO
#include <rect.h>

#define _TCONTINUE	0
#define _TEXITCMD	1

#define _tcurlp(o)	(o->bp + (o->yoffs * o->bcol))
#define _tcursp(o)	(_tcurlp(o) + o->boffs)

typedef struct {
	char *	bp;
	RECT	rc;
	int	bcol;
	int	brow;
	int	yoffs;
	int	boffs;
	int	xoffs;
	int	count;
      } tinfo;

int _CType tiedit(tinfo *);
int _CType timodal(tinfo *);
int _CType tiseto(tinfo *);
int _CType tiputs(tinfo *);
int _CType tinextword(tinfo *);
int _CType tiprevword(tinfo *);
int _CType titoend(tinfo *);

#endif /* __INC__TINFO */