# make startup file for Jonah.
#
# 3/26/98 J Wray
#
# This allows us to make additional global definitions before
# make is run within the Jonah build tree.  It also handles the various 
# phases of the build.

.IF "$(SYSTEM_LIBDIR)" == ""
SYSTEM_LIBDIR:=c:/DevStudio/VC/Lib
.END


.IF "$(BUILD_PHASE)" == ""
BUILD_PHASE=PREBUILD
RECURSING=no
.ELSE
RECURSING=yes
.END

HAVERCS=no              # If you do not have MKS RCS, set to no
#HAVERCS=yes            # If you do not have MKS RCS, set to no

# Allow redefinition on command line of macros defined here,
# without warning messages
__SILENT:=$(.SILENT)
.SILENT:=yes

# suffix definitions
E:=.exe
O:=.obj
S:=.asm
A:=.lib
P:=.pas                 # Pascal
F:=.for                 # Fortran
D:=.dll

# Other macros
.IMPORT: ROOTDIR
TMPDIR:=$(ROOTDIR)/tmp
SHELL:=$(NULL)
.IMPORT .IGNORE: TMPDIR SHELL COMSPEC

# If SHELL not defined, use COMSPEC, assumed to be command.com.
# If SHELL is defined, it is assumed to be the MKS Toolkit Korn Shell

.IF $(SHELL)==$(NULL)
.IF $(COMSPEC)==$(NULL)
    SHELL:=$(ROOTDIR)/bin/sh$E
.ELSE
    SHELL:=$(COMSPEC)
.END
.END
GROUPSHELL := $(SHELL)

.IF $(SHELL)==$(COMSPEC)
    DIRSEPSTR := \/:
    SHELLMETAS := *?"<>|
    SHELLFLAGS := $(SWITCHAR)c
    GROUPFLAGS := $(SHELLFLAGS)
    GROUPSUFFIX := .bat
.ELSE
    SHELLMETAS := ;*?"<>|()&][$$\#`'
    SHELLFLAGS := -c
    GROUPSUFFIX := .ksh
    GROUPFLAGS := $(NULL)
.END

# Command names
CC      := cl                   # Microsoft C/C++
LD      := link                 # Microsoft LINK
AS      := masm                 # Microsoft MASM

MAKE    = $(MAKECMD) $(MFLAGS)
CO      := co                   # MKS RCS Check out
AR      := ar                   # MKS AR librarian, provided with MKS Toolkit
RM      := rm                   # UNIX-style rm, provided with MKS Toolkit
YACC    := yacc                 # MKS LEX&YACC
LEX     := lex

PC      := anypc                # Your Pascal compiler
FC      := anyf77               # Your Fortran compiler

LEXYY   := lex_yy               # MKS LEX output
YTAB    := ytab                 # MKS YACC output

# Command flags and default args
ARFLAGS=ruv -F coff
CFLAGS=-nologo                  # no logo
ASFLAGS=-mx -t                  # dual-case, and no logos
COFLAGS=-q                      # check-out
LDFLAGS=-LIBPATH=Y:/lib/nt -LIBPATH=Z:/lib/nt -LIBPATH=$(SYSTEM_LIBDIR) 
                                # response file, dual-case
LDLIBS:=                        # additional libraries
LFLAGS=                         # for LEX
YFLAGS=                         # for YACC
RMFLAGS=                        # for RM
FFLAGS=                         # for FORTRAN
PFLAGS=                         # for Pascal

DEFINES=-DJONAH

# Implicit generation rules
# We don't provide .f rules here.  They may be added.

%$O: %.c;       $(CC) -c $(CFLAGS) $(DEFINES) $^
%$O: %.cpp;     $(CC) -c $(CFLAGS) $(DEFINES) $^
%$O: %$S;       $(AS) $(ASFLAGS) $^
%$O: %$P;       $(PC) -c $(PFLAGS) $^
%$O: $(BACKING_OBJDIR)/%$O;	cp -m $^ $@

# Full interface to LINK -- run with response file
# Be sure to replace all / filepaths with backslash
DIRSEPSTR := \/:
#%$E: %$O;      $(LD) $(LDFLAGS) /OUT:$(@:s;/;\;) @<+ $(&:t"\n":s;/;\;)
#                         $(LDLIBS:t"\n":s;/;\;)
#                       +>
%$E:    ;       $(LD) $(LDFLAGS) /OUT:$(@:s;/;\;) @<+ $(&:t"\n":s;/;\;)
			  $(LDLIBS:t"\n":s;/;\;)
			+>

%.c: %.y;       $(YACC) $(YFLAGS) -o $@ $^
%.cpp: %.y;     $(YACC) -LC $(YFLAGS) -o $@ $^
%$P: %.y;       $(YACC) -LP $(YFLAGS) -o $@ $^

%.c: %.l;       $(LEX) $(LFLAGS) -o $@ $^
%.cpp: %.l;     $(LEX) -LC $(LFLAGS) -o $@ $^
%$P: %.l;       $(LEX) -LP $(LFLAGS) -o $@ $^

# Intermediate target file removal
.REMOVE:;       $(RM) $(RMFLAGS) $?

# RCS support
.IF $(HAVERCS)==yes
% .PRECIOUS: RCS/%;     -$(CO) $(COFLAGS) $^
%.c .PRECIOUS: RCS/%.c; -$(CO) $(COFLAGS) $^
%.h .PRECIOUS: RCS/%.h; -$(CO) $(COFLAGS) $^
%.cpp .PRECIOUS: RCS/%.cpp;     -$(CO) $(COFLAGS) $^
%.hpp .PRECIOUS: RCS/%.hpp;     -$(CO) $(COFLAGS) $^
%.l .PRECIOUS: RCS/%.l; -$(CO) $(COFLAGS) $^
%.y .PRECIOUS: RCS/%.y; -$(CO) $(COFLAGS) $^
%$P .PRECIOUS: RCS/%$P; -$(CO) $(COFLAGS) $^
%$S .PRECIOUS: RCS/%$S; -$(CO) $(COFLAGS) $^
%$F .PRECIOUS: RCS/%$F; -$(CO) $(COFLAGS) $^
.END

# Archive support

#LIBSUFFIX :=    $A
#%$(LIBSUFFIX) .PRECIOUS .LIBRARY:;      $(AR) $(ARFLAGS) $@ $?

#DLLSUFFIX :=    $D
#%$(DLLSUFFIX) .PRECIOUS .LIBRARY:;      $(LD) /INC $(DLLLDFLAGS) /OUT:$@ $?

%.h : %.msg ; $(TOOLSDIR)/gencat $? $(LIBDIR)/jonahmsg.cat $@

# Turn on warnings
.SILENT:=$(__SILENT)

.IMPORT .IGNORE : DEBUGMAKE
.IMPORT .IGNORE : SRCDIR
.IMPORT .IGNORE : MAKEDIR

.IF "$(DEBUGMAKE)" == ""
VFLAG=
.ELSE
VFLAG=-v
.END

MK_PLATFORM:=$(OS)
OBJROOT:=/Obj/$(OS)
SRCROOT:=/Src


.IF "$(SRCDIR)" == ""
.IF "$(MKDIR)" == ""
SRCDIR:=$(MAKEDIR)
.ELSE
SRCDIR:=$(MKDIR)
.END
.END

.IF "$(OBJDIR)" == ""
OBJDIR:=$(OBJROOT)/$(SRCDIR:u:s!Y:/SRC!!)
.END

.IF "$(LIBDIR)" == ""
LIBDIR:=/lib/$(OS)
.END

.IF "$(MCH_LIBDIR)" == ""
.IF "$(MK_PLATFORM)" == "NT"
MCH_LIBDIR:= \lib\$(OS)
.ELSE
MCH_LIBDIR:= $(LIBDIR)
.END
.END

.IF "$(EXEDIR)" == ""
EXEDIR:=/bin/$(OS)
.END

.IF "$(TOOLSDIR)" == ""
TOOLSDIR:=/tools/$(OS)
.END

BACKING_SRCDIR:= $(SRCDIR:s/Y://:^"Z:")
BACKING_LIBDIR:= $(LIBDIR:s/Y://:^"Z:")
BACKING_BINDIR:= $(BINDIR:s/Y://:^"Z:")
BACKING_OBJDIR:= $(OBJDIR:s/Y://:^"Z:")
BACKING_TOOLSDIR:= $(TOOLSDIR:s/Y://:^"Z:")


defaultbuild : all


.INCLUDEDIRS : . Y:/ Z:/

.MAKEFILES : Makefile $(PWD:s/Y://:^"Z:")/Makefile
