/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <JonahMsg.h>
#include <pkiMsg.h>
#include <xpgmsg.h>

#define MAX_MSG_SIZE 1024

pki_msgcat_handle_t Jonah_default_catalog;

class iniObj {
public:
  iniObj(void) {
    Jonah_default_catalog = pkiCatOpen("Jonahmsg.cat");
  };
  ~iniObj() {
    pkiCatClose(Jonah_default_catalog);
  };
};



static iniObj myIniObj;



size_t Jonah_sprintMsg(char * buffer,
                       size_t bufferSize,
                       uint32 status,
                       const char * defaultMsg,
                       ...) {

  size_t charsWritten;
  va_list args;

  va_start(args, defaultMsg);

  charsWritten = PKI_OSSRV_vprintMsg(buffer, 
                                     bufferSize,
                                     Jonah_default_catalog,
                                     status,
                                     defaultMsg,
                                     args);
  va_end(args);
  return charsWritten;
}








void Jonah_fprintMsg (FILE * file, 
                      uint32 status, 
                      const char * defaultMsg,
                      ...) {
  char buffer[MAX_MSG_SIZE];
  va_list args;

  va_start(args, defaultMsg);

  PKI_OSSRV_vprintMsg(buffer, 
                      sizeof(buffer),
                      Jonah_default_catalog,
                      status,
                      defaultMsg,
                      args);
  va_end(args);
  fputs(buffer, file);

}

size_t Jonah_getMsg(char * buffer,
                    size_t bufferSize,
                    uint32 status) {
  size_t res;

  res = PKI_OSSRV_getMsg(buffer,
                         bufferSize,
                         Jonah_default_catalog,
                         status,
                         "");
  if (res == 0) {
// status code not found
    res = Jonah_sprintMsg(buffer,
                          bufferSize,
                          MSG_UNKNOWN_MSG,
                          "Unknown error 0x%lX\n",
                          status);
  };
  return res;
}