/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <apiNotify.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <Jonah.h>

#define MESSAGE_TIMESTAMPS 1

static void (* ApiNotifyC)(uint32 eventId, 
			   uint32 eventStatus) = NULL;

static void (* ApiDisplayC)(uint32 eventId, 
			    const utf8String message) = NULL;

uint32 MscRegisterCallbacks(
	     void (* JNH_Notify)(uint32 eventId, 
				 uint32 eventStatus),
	     void (* JNH_Display)(uint32 displayType,
				  const utf8String message)) {
  ApiNotifyC = JNH_Notify;
  ApiDisplayC = JNH_Display;
  return 0;
}


void ApiNotify(uint32 eventId, 
	       uint32 eventStatus) {
  if (ApiNotifyC) ApiNotifyC(eventId, eventStatus);
}

void ApiDisplay(uint32 eventId, 
		const utf8String message) {
  utf8String msgCopy = NULL;
  char timeBuf[50] = {0};
  time_t now;

  if (ApiDisplayC) {
#ifdef MESSAGE_TIMESTAMPS    
#ifndef TIMESTAMPS_ON_STATUSBAR
    if (eventId != DISPLAY_STATUSBAR) {
#endif
      now = time(NULL);
      strftime(timeBuf, sizeof(timeBuf), "%a, %x %X : ", localtime(&now));
      timeBuf[sizeof(timeBuf)-1] = 0; // Just in case...
      msgCopy = (utf8String)malloc(strlen((const char *)message)+1+strlen(timeBuf));
      strcpy((char *)msgCopy, timeBuf);
      strcat((char *)msgCopy, (const char *)message);
#ifndef TIMESTAMPS_ON_STATUSBAR
    } else {
#endif
#endif
      msgCopy = (utf8String)malloc(strlen((const char *)message)+1);
      strcpy((char *)msgCopy, (const char *)message);    
#if defined(MESSAGE_TIMESTAMPS) && !defined(TIMESTAMPS_ON_STATUSBAR)
    };
#endif

    ApiDisplayC(eventId, msgCopy);
  };
}
