/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef QDISAM_H_
#define QDISAM_H_

#include <stdio.h>
#include <stdlib.h>
#include <platform.h>
#include <asnbase.h>

#define ISM_OK 0

#include "ismmsg.h"


// QDISAM is _not_ threadsafe.  If invoked from a multi-threaded environment, 
// the caller must provide synchronization so that only one member function of
// a QDISAM object is active at any one time.


class EXPORTCLASS isam {
private:
  FILE * datFile;
  FILE * bitFile;
  FILE * idxFile;
  unsigned char * keymap;
  bool keymap_valid;
  size_t keymap_size;
  char dir[1024];
  size_t logicalBlocksize;
  size_t physicalBlocksize;
  size_t elements;
  size_t initialElements;
  size_t idxRecords;
  size_t bitBytes;
  long block2fptr(uint32 block);
  unsigned char * buffer;
  unsigned char * bitmap;
  void rebuild_keymap(void);
public:
  isam(const char * dir);
  ~isam();
// Set build_keymap to true to rebuild the keymap from the index.
// You must have a valid keymap before you can invoke new_key to
// allocate a fresh key.  If you're only going to read or update
// existing records, or if you're going to call one of the
// enumerate_XXX members before allocating a new key, you can 
// save time by omitting this step.
  uint32 open(const char * table,
              bool build_keymap = true);
  uint32 create(const char * table,
                unsigned elements = 1024,
                unsigned blocksize = 512);
  uint32 close(void);
  uint32 fetch(uint32 key, uint32 &flags, buffer_t & record);
  uint32 store(uint32 key, uint32 flags, r_buffer_t & record, bool overwrite);
  uint32 delete_record(uint32);
  uint32 new_key(void);
  uint32 rebuild_index(void);
  uint32 compact(void);
// The enumerate_XXX members return a buffer_t containing an array of 
// uint32 values, listing the keys present in the database that match
// the specified criteria.  _all lists all keys, _bits matches those
// records whose flags intersect the provided bitmask, and _match
// lists records whos flags, masked with the mask, are equal to the 
// provided flag-value. These functions also re-calculate the keymap, 
// so if you are going to invoke one of these routines before calling 
// new_key, you can save time by not re-building the keymap when you 
// open the ISAM store.
  uint32 enumerate_all(buffer_t & keys, buffer_t * flags = NULL);
  uint32 enumerate_bits(uint32 mask, buffer_t & keys, buffer_t * flags = NULL);
  uint32 enumerate_match(uint32 mask, uint32 value, buffer_t & keys, buffer_t * flags = NULL);
};


#endif