
/* SCCSID: inc/cssmerr.h, dss_cdsa_fwk, fwk_rel3, dss_980403 1.43 4/13/98 10:38:25 */

/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

 /*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef _CSSMERR_H
#define _CSSMERR_H

#define CSSM_CSP_BASE_ERROR     ( 1000UL )    /* Defined by CSSM */
#define CSSM_CSP_PRIVATE_ERROR  ( 2000UL )    /* Defined by individual CSPs */
#define CSSM_CSP_END_ERROR      ( 2999UL )
#define CSSM_CL_BASE_ERROR      ( 3000UL )    /* Defined by CSSM */
#define CSSM_CL_PRIVATE_ERROR   ( 4000UL )    /* Definted by indiv CLs */
#define CSSM_CL_END_ERROR       ( 4999UL )
#define CSSM_DL_BASE_ERROR      ( 5000UL )    /* Defined by CSSM */
#define CSSM_DL_PRIVATE_ERROR   ( 6000UL )    /* Defined by indiv DBs */
#define CSSM_DL_END_ERROR       ( 6999UL )
#define CSSM_TP_BASE_ERROR      ( 7000UL )    /* Defined by CSSM */
#define CSSM_TP_PRIVATE_ERROR   ( 8000UL )    /* Defined by indiv TPs */
#define CSSM_TP_END_ERROR       ( 8999UL )

#define CSSM_BASE_ERROR         ( 10000UL )
#define CSSM_END_ERROR          ( 19999UL )

#define CSSM_IsCSPError(err) (((err >= CSSM_CSP_BASE_ERROR) && \
    (err <= CSSM_CSP_END_ERROR)) ? 1 : 0)
#define CSSM_IsCLError(err) (((err >= CSSM_CL_BASE_ERROR) && \
    (err <= CSSM_CL_END_ERROR)) ? 1 : 0)
#define CSSM_IsDLError(err) (((err >= CSSM_DL_BASE_ERROR) && \
    (err <= CSSM_DL_END_ERROR)) ? 1 : 0)
#define CSSM_IsTPError(err) (((err >= CSSM_TP_BASE_ERROR) && \
    (err <= CSSM_TP_END_ERROR)) ? 1 : 0)
#define CSSM_IsKRSPError(err) (((err >= CSSM_KRSP_BASE_ERROR) && \
    (err <= CSSM_KRSP_END_ERROR)) ? 1 : 0)
#define CSSM_IsCSSMError(err) (((err >= CSSM_BASE_ERROR) && \
    (err <= CSSM_END_ERROR)) ? 1 : 0)
                                    

/* Cryptographic Service Provider Error Codes */

#define CSSM_CSP_UNKNOWN_ERROR               ( CSSM_CSP_BASE_ERROR +1L )
#define CSSM_CSP_REGISTER_ERROR              ( CSSM_CSP_BASE_ERROR +2L )
#define CSSM_CSP_VERSION_ERROR               ( CSSM_CSP_BASE_ERROR +3L )
#define CSSM_CSP_CONVERSION_ERROR            ( CSSM_CSP_BASE_ERROR +4L )
#define CSSM_CSP_NO_TOKENINFO                ( CSSM_CSP_BASE_ERROR +5L )
#define CSSM_CSP_INTERNAL_ERROR              ( CSSM_CSP_BASE_ERROR +6L )
#define CSSM_CSP_SERIAL_REQUIRED             ( CSSM_CSP_BASE_ERROR +7L )
#define CSSM_CSP_NOT_IMPLEMENTED             ( CSSM_CSP_BASE_ERROR +8L )

#define CSSM_CSP_MEMORY_ERROR                ( CSSM_CSP_BASE_ERROR +10L )
#define CSSM_CSP_NOT_ENOUGH_BUFFER           ( CSSM_CSP_BASE_ERROR +11L )
#define CSSM_CSP_ERR_OUTBUF_LENGTH           ( CSSM_CSP_BASE_ERROR +12L )
#define CSSM_CSP_NO_OUTBUF                   ( CSSM_CSP_BASE_ERROR +13L )
#define CSSM_CSP_ERR_INBUF_LENGTH            ( CSSM_CSP_BASE_ERROR +14L )
#define CSSM_CSP_ERR_KEYBUF_LENGTH           ( CSSM_CSP_BASE_ERROR +15L )
#define CSSM_CSP_NO_SLOT                     ( CSSM_CSP_BASE_ERROR +16L )       

#define CSSM_CSP_INVALID_CSP_HANDLE          ( CSSM_CSP_BASE_ERROR +20L )
#define CSSM_CSP_INVALID_POINTER             ( CSSM_CSP_BASE_ERROR +21L )
#define CSSM_CSP_INVALID_CERTIFICATE         ( CSSM_CSP_BASE_ERROR +22L )
#define CSSM_CSP_INVALID_ALGORITHM           ( CSSM_CSP_BASE_ERROR +23L )
#define CSSM_CSP_INVALID_WINDOW_HANDLE       ( CSSM_CSP_BASE_ERROR +24L )
#define CSSM_CSP_INVALID_CALLBACK            ( CSSM_CSP_BASE_ERROR +25L )
#define CSSM_CSP_INVALID_CONTEXT             ( CSSM_CSP_BASE_ERROR +26L )
#define CSSM_CSP_INVALID_CONTEXT_HANDLE      ( CSSM_CSP_BASE_ERROR +27L )
#define CSSM_CSP_INVALID_CONTEXT_POINTER     ( CSSM_CSP_BASE_ERROR +28L )
#define CSSM_CSP_INVALID_DATA_POINTER        ( CSSM_CSP_BASE_ERROR +29L )
#define CSSM_CSP_INVALID_DATA_COUNT          ( CSSM_CSP_BASE_ERROR +30L )
#define CSSM_CSP_INVALID_KEY_LENGTH          ( CSSM_CSP_BASE_ERROR +31L )
#define CSSM_CSP_INVALID_KEY                 ( CSSM_CSP_BASE_ERROR +32L )
#define CSSM_CSP_INVALID_KEY_POINTER         ( CSSM_CSP_BASE_ERROR +33L )
#define CSSM_CSP_INVALID_ALGORITHM_MODE      ( CSSM_CSP_BASE_ERROR +34L )
#define CSSM_CSP_INVALID_PADDING             ( CSSM_CSP_BASE_ERROR +35L )
#define CSSM_CSP_INVALID_KEY_ATTRIBUTE       ( CSSM_CSP_BASE_ERROR +36L )
#define CSSM_CSP_INVALID_PARAM_LENGTH        ( CSSM_CSP_BASE_ERROR +37L )
#define CSSM_CSP_INVALID_IV_SIZE             ( CSSM_CSP_BASE_ERROR +38L )
#define CSSM_CSP_INVALID_SIGNATURE           ( CSSM_CSP_BASE_ERROR +39L )
#define CSSM_CSP_INVALID_DEVICE_ID           ( CSSM_CSP_BASE_ERROR +40L )
#define CSSM_CSP_INVALID_KEYCLASS            ( CSSM_CSP_BASE_ERROR +41L )
#define CSSM_CSP_INVALID_MODULE_HANDLE       ( CSSM_CSP_BASE_ERROR +42L )
#define CSSM_CSP_INVALID_KEY_TYPE             ( CSSM_CSP_BASE_ERROR +43L )
#define CSSM_CSP_INVALID_ITERATION_COUNT     ( CSSM_CSP_BASE_ERROR +44L )

#define CSSM_CSP_FILE_NOT_EXISTS             ( CSSM_CSP_BASE_ERROR +50L )
#define CSSM_CSP_FILE_NOT_OPEN               ( CSSM_CSP_BASE_ERROR +51L )
#define CSSM_CSP_FILE_OPEN_FAILED            ( CSSM_CSP_BASE_ERROR +52L )
#define CSSM_CSP_FILE_CREATE_FAILED          ( CSSM_CSP_BASE_ERROR +53L )
#define CSSM_CSP_FILE_READ_FAILED            ( CSSM_CSP_BASE_ERROR +54L )
#define CSSM_CSP_FILE_WRITE_FAILED           ( CSSM_CSP_BASE_ERROR +55L )
#define CSSM_CSP_FILE_CLOSE_FAILED           ( CSSM_CSP_BASE_ERROR +56L )
#define CSSM_CSP_FILE_COPY_FAILED            ( CSSM_CSP_BASE_ERROR +57L )
#define CSSM_CSP_FILE_DELETE_FAILED          ( CSSM_CSP_BASE_ERROR +58L )
#define CSSM_CSP_FILE_FORMAT_ERROR           ( CSSM_CSP_BASE_ERROR +59L)

#define CSSM_CSP_PUBKEY_GET_ERROR            ( CSSM_CSP_BASE_ERROR +65L )
#define CSSM_CSP_QUERY_SIZE_FAILED           ( CSSM_CSP_BASE_ERROR +66L )
#define CSSM_CSP_UNKNOWN_ALGORITHM           ( CSSM_CSP_BASE_ERROR +67L )
#define CSSM_CSP_OPERATION_UNSUPPORTED       ( CSSM_CSP_BASE_ERROR +68L )
#define CSSM_CSP_VECTOROFBUFS_UNSUPPORTED    ( CSSM_CSP_BASE_ERROR +69L )
#define CSSM_CSP_STAGED_OPERATION_UNSUPPORTED ( CSSM_CSP_BASE_ERROR+70L )
#define CSSM_CSP_KEY_MODULUS_UNSUPPORTED     ( CSSM_CSP_BASE_ERROR +71L )
#define CSSM_CSP_KEY_LENGTH_UNSUPPORTED      ( CSSM_CSP_BASE_ERROR +72L )
#define CSSM_CSP_PADDING_UNSUPPORTED         ( CSSM_CSP_BASE_ERROR +73L )
#define CSSM_CSP_IV_SIZE_UNSUPPORTED         ( CSSM_CSP_BASE_ERROR +74L )
#define CSSM_CSP_GET_APIMEMFUNC_ERROR        ( CSSM_CSP_BASE_ERROR +75L )
#define CSSM_CSP_INPUT_LENGTH_OVERSIZE       ( CSSM_CSP_BASE_ERROR +76L )
#define CSSM_CSP_INPUT_LENGTH_ERROR          ( CSSM_CSP_BASE_ERROR +77L )
#define CSSM_CSP_INPUT_DATA_ERROR            ( CSSM_CSP_BASE_ERROR +78L )
#define CSSM_CSP_UNSUPPORTED_STORAGE_MASK    ( CSSM_CSP_BASE_ERROR +79L )
#define CSSM_CSP_OPERATION_IN_PROGRESS       ( CSSM_CSP_BASE_ERROR +80L )
#define CSSM_CSP_NO_WRITE_PERMISSIONS        ( CSSM_CSP_BASE_ERROR +81L )
#define CSSM_CSP_EXCLUSIVE_UNAVAILABLE       ( CSSM_CSP_BASE_ERROR +82L )
#define CSSM_CSP_UPDATE_WITHOUT_INIT         ( CSSM_CSP_BASE_ERROR +83L )
#define CSSM_CSP_LOGIN_FAILED                ( CSSM_CSP_BASE_ERROR +84L )
#define CSSM_CSP_ALREADY_LOGGED_IN           ( CSSM_CSP_BASE_ERROR +85L )
#define CSSM_CSP_NOT_LOGGED_IN               ( CSSM_CSP_BASE_ERROR +86L )
#define CSSM_CSP_KEY_PROTECTED               ( CSSM_CSP_BASE_ERROR +87L )
#define CSSM_CSP_CALLBACK_FAILED             ( CSSM_CSP_BASE_ERROR +88L )
#define CSSM_CSP_ROUNDS_UNSUPPORTED          ( CSSM_CSP_BASE_ERROR +89L )
#define CSSM_CSP_EFFECTIVE_BITS_UNSUPPORTED  ( CSSM_CSP_BASE_ERROR +90L )
#define CSSM_CSP_INCOMPATIBLE_VERSION        ( CSSM_CSP_BASE_ERROR +91L )
#define CSSM_CSP_INCOMPATIBLE_KEY_VERSION    ( CSSM_CSP_BASE_ERROR +92L )
#define CSSM_CSP_ALGORITHM_UNSUPPORTED       ( CSSM_CSP_BASE_ERROR +93L )
#define CSSM_CSP_OPERATION_FAILED             ( CSSM_CSP_BASE_ERROR +94L )

#define CSSM_CSP_PARAM_NO_PARAM              ( CSSM_CSP_BASE_ERROR +100L )
#define CSSM_CSP_PARAM_NO_PASSWORD           ( CSSM_CSP_BASE_ERROR +101L )
#define CSSM_CSP_PARAM_NO_SEED               ( CSSM_CSP_BASE_ERROR +102L )
#define CSSM_CSP_PARAM_NO_KEY                ( CSSM_CSP_BASE_ERROR +103L )
#define CSSM_CSP_PARAM_NO_SALT               ( CSSM_CSP_BASE_ERROR +104L )
#define CSSM_CSP_PARAM_NO_MODULUS            ( CSSM_CSP_BASE_ERROR +105L )
#define CSSM_CSP_PARAM_NO_OUTPUT_SIZE        ( CSSM_CSP_BASE_ERROR +106L )
#define CSSM_CSP_PARAM_NO_KEY_LENGTH         ( CSSM_CSP_BASE_ERROR +108L )
#define CSSM_CSP_PARAM_NO_MODE               ( CSSM_CSP_BASE_ERROR +109L )
#define CSSM_CSP_PARAM_NO_DATA               ( CSSM_CSP_BASE_ERROR +110L )
#define CSSM_CSP_PARAM_NO_INIT_VECTOR        ( CSSM_CSP_BASE_ERROR +111L )
#define CSSM_CSP_PARAM_NO_PADDING            ( CSSM_CSP_BASE_ERROR +112L )
#define CSSM_CSP_PARAM_NO_ROUNDS             ( CSSM_CSP_BASE_ERROR +113L )
#define CSSM_CSP_PARAM_NO_RANDOM             ( CSSM_CSP_BASE_ERROR +114L )
#define CSSM_CSP_PARAM_NO_REMAINDATA         ( CSSM_CSP_BASE_ERROR +115L )
#define CSSM_CSP_PARAM_NO_ALG_PARAMS         ( CSSM_CSP_BASE_ERROR +116L )
#define CSSM_CSP_PARAM_INVALID_VALUE         ( CSSM_CSP_BASE_ERROR +117L )
#define CSSM_CSP_PARAM_NO_EFFECTIVE_BITS     ( CSSM_CSP_BASE_ERROR +118L )
#define CSSM_CSP_PARAM_NO_PRIME              ( CSSM_CSP_BASE_ERROR +119L )
#define CSSM_CSP_PARAM_NO_BASE               ( CSSM_CSP_BASE_ERROR +120L )
#define CSSM_CSP_PARAM_NO_SUBPRIME           ( CSSM_CSP_BASE_ERROR +121L )
#define CSSM_CSP_PARAM_NO_ALG_ID             ( CSSM_CSP_BASE_ERROR +122L ) 
#define CSSM_CSP_PARAM_NO_KEY_TYPE           ( CSSM_CSP_BASE_ERROR +123L )
#define CSSM_CSP_PARAM_NO_ITERATION_COUNT    ( CSSM_CSP_BASE_ERROR +124L )

/* password error*/
#define CSSM_CSP_PASSWORD_INCORRECT          ( CSSM_CSP_BASE_ERROR +130L)
#define CSSM_CSP_PASSWORD_SAME               ( CSSM_CSP_BASE_ERROR +131L)
#define CSSM_CSP_PASSWORD_LENGTH_ERROR       ( CSSM_CSP_BASE_ERROR +132L)
#define CSSM_CSP_PASSWORD_INVALID             ( CSSM_CSP_BASE_ERROR +133L )

/* key, key management messages and errors */
#define CSSM_CSP_PRIKEY_LOAD_ERROR           ( CSSM_CSP_BASE_ERROR +140L )
#define CSSM_CSP_PRIKEY_NOT_FOUND            ( CSSM_CSP_BASE_ERROR +141L )
#define CSSM_CSP_PRIKEY_ALREADY_EXIST        ( CSSM_CSP_BASE_ERROR +142L )
#define CSSM_CSP_PRIKEY_GET_ERROR            ( CSSM_CSP_BASE_ERROR +143L )
#define CSSM_CSP_PRIKEY_PUBKEY_INCONSISTENT  ( CSSM_CSP_BASE_ERROR +144L )

#define CSSM_CSP_KEY_DUPLICATE               ( CSSM_CSP_BASE_ERROR +150L )
#define CSSM_CSP_KEY_BAD_KEY                 ( CSSM_CSP_BASE_ERROR +151L )
#define CSSM_CSP_KEY_BAD_LENGTH              ( CSSM_CSP_BASE_ERROR +152L )
#define CSSM_CSP_KEY_NO_PARAM                ( CSSM_CSP_BASE_ERROR +153L )
#define CSSM_CSP_KEY_ALGID_NOTMATCH          ( CSSM_CSP_BASE_ERROR +154L )
#define CSSM_CSP_KEY_BLOBTYPE_INCORRECT      ( CSSM_CSP_BASE_ERROR +155L )
#define CSSM_CSP_KEY_CLASS_INCORRECT         ( CSSM_CSP_BASE_ERROR +156L )
#define CSSM_CSP_KEY_DELETE_FAILED           ( CSSM_CSP_BASE_ERROR +157L )
#define CSSM_CSP_KEY_USAGE_INCORRECT         ( CSSM_CSP_BASE_ERROR +158L )
#define CSSM_CSP_KEY_NOT_PROTECTED           ( CSSM_CSP_BASE_ERROR +159L )
#define CSSM_CSP_KEY_FORMAT_INCORRECT        ( CSSM_CSP_BASE_ERROR +160L )
                                        
/* random number generation (RNG) messages and errors */
#define CSSM_CSP_RNG_FAILED                  ( CSSM_CSP_BASE_ERROR +200L )
#define CSSM_CSP_RNG_UNKNOWN_ALGORITHM       ( CSSM_CSP_BASE_ERROR +201L )
#define CSSM_CSP_RNG_NO_METHOD               ( CSSM_CSP_BASE_ERROR +202L )
                                        
/* unique ID generation (UIDG) messages and errors */
#define CSSM_CSP_UIDG_FAILED                 ( CSSM_CSP_BASE_ERROR +220L )
#define CSSM_CSP_UIDG_UNKNOWN_ALGORITHM      ( CSSM_CSP_BASE_ERROR +221L )
#define CSSM_CSP_UIDG_NO_METHOD              ( CSSM_CSP_BASE_ERROR +222L )

/* key generation (KGP) messages and errors */
#define CSSM_CSP_KEYGEN_FAILED               ( CSSM_CSP_BASE_ERROR +210L )
#define CSSM_CSP_KEYGEN_UNKNOWN_ALGORITHM    ( CSSM_CSP_BASE_ERROR +211L )
#define CSSM_CSP_KEYGEN_NO_METHOD            ( CSSM_CSP_BASE_ERROR +212L )

/* encryption/decryption */
#define CSSM_CSP_ENC_UNKNOWN_ALGORITHM       ( CSSM_CSP_BASE_ERROR +230L )
#define CSSM_CSP_ENC_NO_METHOD               ( CSSM_CSP_BASE_ERROR +231L )
#define CSSM_CSP_ENC_FAILED                  ( CSSM_CSP_BASE_ERROR +232L )
#define CSSM_CSP_ENC_INIT_FAILED             ( CSSM_CSP_BASE_ERROR +233L )
#define CSSM_CSP_ENC_UPDATE_FAILED           ( CSSM_CSP_BASE_ERROR +234L )
#define CSSM_CSP_ENC_FINAL_FAILED            ( CSSM_CSP_BASE_ERROR +235L )
#define CSSM_CSP_ENC_BAD_IV_LENGTH           ( CSSM_CSP_BASE_ERROR +236L )
#define CSSM_CSP_ENC_IV_ERROR                ( CSSM_CSP_BASE_ERROR +237L )
#define CSSM_CSP_ENC_BAD_KEY_LENGTH          ( CSSM_CSP_BASE_ERROR +238L )
#define CSSM_CSP_ENC_UNKNOWN_MODE            ( CSSM_CSP_BASE_ERROR +239L )

#define CSSM_CSP_DEC_UNKNOWN_ALGORITHM       ( CSSM_CSP_BASE_ERROR +250L )
#define CSSM_CSP_DEC_NO_METHOD               ( CSSM_CSP_BASE_ERROR +251L )
#define CSSM_CSP_DEC_FAILED                  ( CSSM_CSP_BASE_ERROR +253L )
#define CSSM_CSP_DEC_INIT_FAILED             ( CSSM_CSP_BASE_ERROR +254L )
#define CSSM_CSP_DEC_UPDATE_FAILED           ( CSSM_CSP_BASE_ERROR +255L )
#define CSSM_CSP_DEC_FINAL_FAILED            ( CSSM_CSP_BASE_ERROR +256L )
#define CSSM_CSP_DEC_BAD_IV_LENGTH           ( CSSM_CSP_BASE_ERROR +257L )
#define CSSM_CSP_DEC_IV_ERROR                ( CSSM_CSP_BASE_ERROR +258L )
#define CSSM_CSP_DEC_BAD_KEY_LENGTH          ( CSSM_CSP_BASE_ERROR +259L )
#define CSSM_CSP_DEC_UNKNOWN_MODE            ( CSSM_CSP_BASE_ERROR +260L )

/* sign/verify messages and errors */
#define CSSM_CSP_SIGN_UNKNOWN_ALGORITHM      ( CSSM_CSP_BASE_ERROR +350L )
#define CSSM_CSP_SIGN_NO_METHOD              ( CSSM_CSP_BASE_ERROR +351L )
#define CSSM_CSP_SIGN_FAILED                 ( CSSM_CSP_BASE_ERROR +352L )
#define CSSM_CSP_SIGN_INIT_FAILED            ( CSSM_CSP_BASE_ERROR +353L )
#define CSSM_CSP_SIGN_UPDATE_FAILED          ( CSSM_CSP_BASE_ERROR +354L )
#define CSSM_CSP_SIGN_FINAL_FAILED           ( CSSM_CSP_BASE_ERROR +355L )

#define CSSM_CSP_VERIFY_FAILED               ( CSSM_CSP_BASE_ERROR +360L )
#define CSSM_CSP_VERIFY_INIT_FAILED          ( CSSM_CSP_BASE_ERROR +361L )
#define CSSM_CSP_VERIFY_UPDATE_FAILED        ( CSSM_CSP_BASE_ERROR +362L )
#define CSSM_CSP_VERIFY_FINAL_FAILED         ( CSSM_CSP_BASE_ERROR +363L )
#define CSSM_CSP_VERIFY_UNKNOWN_ALGORITHM    ( CSSM_CSP_BASE_ERROR +365L )
#define CSSM_CSP_VERIFY_NO_METHOD            ( CSSM_CSP_BASE_ERROR +366L )

/* digest functions errors */
#define CSSM_CSP_DIGEST_UNKNOWN_ALGORITHM    ( CSSM_CSP_BASE_ERROR +380L )
#define CSSM_CSP_DIGEST_NO_METHOD            ( CSSM_CSP_BASE_ERROR +382L )
#define CSSM_CSP_DIGEST_FAILED               ( CSSM_CSP_BASE_ERROR +383L )
#define CSSM_CSP_DIGEST_INIT_FAILED          ( CSSM_CSP_BASE_ERROR +384L )
#define CSSM_CSP_DIGEST_UPDATE_FAILED        ( CSSM_CSP_BASE_ERROR +385L )
#define CSSM_CSP_DIGEST_CLONE_FAILED         ( CSSM_CSP_BASE_ERROR +386L )
#define CSSM_CSP_DIGEST_FINAL_FAILED         ( CSSM_CSP_BASE_ERROR +387L )
                                        
/* mac functions errors */
#define CSSM_CSP_MAC_UNKNOWN_ALGORITHM       ( CSSM_CSP_BASE_ERROR +390L )
#define CSSM_CSP_MAC_NO_METHOD               ( CSSM_CSP_BASE_ERROR +392L )
#define CSSM_CSP_MAC_FAILED                  ( CSSM_CSP_BASE_ERROR +393L )
#define CSSM_CSP_MAC_INIT_FAILED             ( CSSM_CSP_BASE_ERROR +394L )
#define CSSM_CSP_MAC_UPDATE_FAILED           ( CSSM_CSP_BASE_ERROR +395L )
#define CSSM_CSP_MAC_CLONE_FAILED            ( CSSM_CSP_BASE_ERROR +396L )
#define CSSM_CSP_MAC_FINAL_FAILED            ( CSSM_CSP_BASE_ERROR +397L )

/* key exchange errors */
#define CSSM_CSP_KEYEXCH_GENPARAM_FAILED     ( CSSM_CSP_BASE_ERROR +410L )
#define CSSM_CSP_KEYEXCH_PHASE1_FAILED       ( CSSM_CSP_BASE_ERROR +411L )
#define CSSM_CSP_KEYEXCH_PHASE2_FAILED       ( CSSM_CSP_BASE_ERROR +412L )
#define CSSM_CSP_KEYEXCH_UNKNOWN_ALGORITHM   ( CSSM_CSP_BASE_ERROR +413L )
#define CSSM_CSP_KEYEXCH_NO_METHOD           ( CSSM_CSP_BASE_ERROR +414L )

/* pass through custom error*/
#define CSSM_CSP_INVALID_PASSTHROUGH_ID      ( CSSM_CSP_BASE_ERROR +420L )
#define CSSM_CSP_INVALID_PASSTHROUGH_PARAMS  ( CSSM_CSP_BASE_ERROR +421L )

/* wrap/unwrap error*/
#define CSSM_CSP_WRAP_UNKNOWN_ALGORITHM      ( CSSM_CSP_BASE_ERROR +450L )
#define CSSM_CSP_WRAP_NO_METHOD              ( CSSM_CSP_BASE_ERROR +451L )
#define CSSM_CSP_WRAP_FAILED                 ( CSSM_CSP_BASE_ERROR +452L )
#define CSSM_CSP_UNWRAP_UNKNOWN_ALGORITHM    ( CSSM_CSP_BASE_ERROR +456L )
#define CSSM_CSP_UNWRAP_NO_METHOD            ( CSSM_CSP_BASE_ERROR +457L )
#define CSSM_CSP_UNWRAP_FAILED               ( CSSM_CSP_BASE_ERROR +458L )

#define CSSM_CSP_DEVICE_ERROR                ( CSSM_CSP_BASE_ERROR +470L )
#define CSSM_CSP_DEVICE_MEMORY_ERROR         ( CSSM_CSP_BASE_ERROR +471L )
#define CSSM_CSP_DEVICE_REMOVED              ( CSSM_CSP_BASE_ERROR +472L )
#define CSSM_CSP_DEVICE_NOT_PRESENT          ( CSSM_CSP_BASE_ERROR +473L )
#define CSSM_CSP_DEVICE_UNKNOWN              ( CSSM_CSP_BASE_ERROR +474L )

#define CSSM_CSP_PERMISSIONS_READ_ONLY       ( CSSM_CSP_BASE_ERROR +490L )
#define CSSM_CSP_PERMISSIONS_WRITE_PROTECT   ( CSSM_CSP_BASE_ERROR +491L )
#define CSSM_CSP_PERMISSIONS_NOT_EXCLUSIVE   ( CSSM_CSP_BASE_ERROR +492L )

/* query size error*/
#define CSSM_CSP_QUERY_SIZE_UNKNOWN             ( CSSM_CSP_BASE_ERROR +500L )
#define CSSM_CSP_QUERY_KEYSIZEINBITS_UNKNOWN ( CSSM_CSP_BASE_ERROR +501L )


/* Porting Library Error Codes */

/* memory allocation, pointers, strings */
#define CSSM_MALLOC_FAILED                   ( CSSM_BASE_ERROR + 1 )
#define CSSM_CALLOC_FAILED                   ( CSSM_BASE_ERROR + 2 )
#define CSSM_REALLOC_FAILED                  ( CSSM_BASE_ERROR + 3 )

/* file I/O */
#define CSSM_FWRITE_FAILED                   ( CSSM_BASE_ERROR + 10 )
#define CSSM_FREAD_FAILED                    ( CSSM_BASE_ERROR + 11 )
#define CSSM_CANT_FSEEK                      ( CSSM_BASE_ERROR + 12 )
#define CSSM_INVALID_FILE_PTR                ( CSSM_BASE_ERROR + 13 )
#define CSSM_END_OF_FILE                     ( CSSM_BASE_ERROR + 14 )

/* misc Errors */
#define CSSM_CANT_GET_USER_NAME              ( CSSM_BASE_ERROR + 20 )
#define CSSM_GETCWD_FAILED                   ( CSSM_BASE_ERROR + 21 )
#define CSSM_ENV_VAR_NOT_FOUND               ( CSSM_BASE_ERROR + 22 )
#define CSSM_BAD_HASH_CONTEXT_INDEX          ( CSSM_BASE_ERROR + 23 )
#define CSSM_SET_ERROR_FAILED                ( CSSM_BASE_ERROR + 24 )

/* dynamic Library */
#define CSSM_FREE_LIBRARY_FAILED             ( CSSM_BASE_ERROR + 30 )
#define CSSM_LOAD_LIBRARY_FAILED             ( CSSM_BASE_ERROR + 31 )
#define CSSM_CANT_GET_PROC_ADDR              ( CSSM_BASE_ERROR + 32 )
#define CSSM_CANT_GET_MODULE_HANDLE          ( CSSM_BASE_ERROR + 33 )
#define CSSM_CANT_GET_MODULE_FILE_NAME       ( CSSM_BASE_ERROR + 34 )
#define CSSM_INVALID_LIB_HANDLE              ( CSSM_BASE_ERROR + 35 )
#define CSSM_BAD_MODULE_HANDLE               ( CSSM_BASE_ERROR + 36 )

/* registry errors */
#define CSSM_CANT_CREATE_KEY                 ( CSSM_BASE_ERROR + 40 )
#define CSSM_CANT_SET_VALUE                  ( CSSM_BASE_ERROR + 41 )
#define CSSM_CANT_GET_VALUE                  ( CSSM_BASE_ERROR + 42 )
#define CSSM_CANT_DELETE_SECTION             ( CSSM_BASE_ERROR + 43 )
#define CSSM_CANT_DELETE_KEY                 ( CSSM_BASE_ERROR + 44 )
#define CSSM_CANT_ENUM_KEY                   ( CSSM_BASE_ERROR + 45 )
#define CSSM_CANT_OPEN_KEY                   ( CSSM_BASE_ERROR + 46 )
#define CSSM_CANT_QUERY_KEY                  ( CSSM_BASE_ERROR + 47 )

/* mutex/synchronization Errors */
#define CSSM_CANT_CREATE_MUTEX               ( CSSM_BASE_ERROR + 50 )
#define CSSM_LOCK_MUTEX_FAILED               ( CSSM_BASE_ERROR + 51 )
#define CSSM_TRYLOCK_MUTEX_FAILED            ( CSSM_BASE_ERROR + 52 )
#define CSSM_UNLOCK_MUTEX_FAILED             ( CSSM_BASE_ERROR + 53 )
#define CSSM_CANT_CLOSE_MUTEX                ( CSSM_BASE_ERROR + 54 )
#define CSSM_INVALID_MUTEX_PTR               ( CSSM_BASE_ERROR + 55 )

/* shared memory file errors */
#define CSSM_CANT_CREATE_SHARED_MEMORY_FILE  ( CSSM_BASE_ERROR + 60 )
#define CSSM_CANT_OPEN_SHARED_MEMORY_FILE    ( CSSM_BASE_ERROR + 61 )
#define CSSM_CANT_MAP_SHARED_MEMORY_FILE     ( CSSM_BASE_ERROR + 62 )
#define CSSM_CANT_UNMAP_SHARED_MEMORY_FILE   ( CSSM_BASE_ERROR + 63 )
#define CSSM_CANT_FLUSH_SHARED_MEMORY_FILE   ( CSSM_BASE_ERROR + 64 )
#define CSSM_CANT_CLOSE_SHARED_MEMORY_FILE   ( CSSM_BASE_ERROR + 65 )
#define CSSM_INVALID_PERMS                   ( CSSM_BASE_ERROR + 66 )
#define CSSM_BAD_FILE_HANDLE                 ( CSSM_BASE_ERROR + 67 )
#define CSSM_BAD_FILE_ADDR                   ( CSSM_BASE_ERROR + 68 )

/* key formats */
#define CSSM_KEY_FORMAT_NOT_SUPPORTED		 ( CSSM_BASE_ERROR + 80 )

/* general */
#define CSSM_BAD_PTR_PASSED                  ( CSSM_BASE_ERROR + 100 )

/* CSSM API Error Codes */

#define CSSM_INVALID_POINTER                 ( CSSM_BASE_ERROR + 301L )
#define CSSM_EXPIRED                         ( CSSM_BASE_ERROR + 302L )
#define CSSM_MEMORY_ERROR                    ( CSSM_BASE_ERROR + 303L )
#define CSSM_INVALID_ATTRIBUTE               ( CSSM_BASE_ERROR + 304L )
#define CSSM_NOT_INITIALIZE                  ( CSSM_BASE_ERROR + 305L )
#define CSSM_INSTALL_FAIL                    ( CSSM_BASE_ERROR + 306L )
#define CSSM_REGISTRY_ERROR                  ( CSSM_BASE_ERROR + 307L )
#define CSSM_INVALID_CONTEXT_HANDLE          ( CSSM_BASE_ERROR + 308L )
#define CSSM_INVALID_CSP_HANDLE              ( CSSM_BASE_ERROR + 309L )
#define CSSM_INVALID_TP_HANDLE               ( CSSM_BASE_ERROR + 310L )
#define CSSM_INVALID_CL_HANDLE               ( CSSM_BASE_ERROR + 311L )
#define CSSM_INVALID_DL_HANDLE               ( CSSM_BASE_ERROR + 312L )
#define CSSM_INCOMPATIBLE_VERSION            ( CSSM_BASE_ERROR + 313L )
#define CSSM_ATTACH_FAIL                     ( CSSM_BASE_ERROR + 314L )
#define CSSM_NO_ADDIN                        ( CSSM_BASE_ERROR + 315L )
#define CSSM_FUNCTION_NOT_IMPLEMENTED        ( CSSM_BASE_ERROR + 316L )
#define CSSM_INVALID_CONTEXT_POINTER         ( CSSM_BASE_ERROR + 317L )
#define CSSM_INVALID_MANIFEST_ATTRIB_POINTER ( CSSM_BASE_ERROR + 318L )
#define CSSM_MODE_UNSUPPORTED            	 ( CSSM_BASE_ERROR + 319L )
#define CSSM_KEY_LENGTH_UNSUPPORTED          ( CSSM_BASE_ERROR + 320L )
#define CSSM_IV_SIZE_UNSUPPORTED             ( CSSM_BASE_ERROR + 321L )
#define CSSM_PADDING_UNSUPPORTED             ( CSSM_BASE_ERROR + 322L )
#define CSSM_KEY_MODULUS_UNSUPPORTED         ( CSSM_BASE_ERROR + 323L )
#define CSSM_PARAM_NO_KEY                    ( CSSM_BASE_ERROR + 324L )

#define CSSM_INVALID_SERVICE_MASK            ( CSSM_BASE_ERROR + 340L )	
#define CSSM_INVALID_SUBSERVICEID            ( CSSM_BASE_ERROR + 341L )
#define CSSM_INVALID_INFO_LEVEL		         ( CSSM_BASE_ERROR + 342L )

#define CSSM_ADDIN_AUTHENTICATION_FAILED     ( CSSM_BASE_ERROR + 344L )
#define CSSM_EISL_PKCS7_INVALID			     ( CSSM_BASE_ERROR + 345L )
#define CSSM_EISL_SIGROOT_INVALID		     ( CSSM_BASE_ERROR + 346L )
#define CSSM_EISL_MANIFEST_SECTION_NOT_FOUND ( CSSM_BASE_ERROR + 347L )
#define CSSM_EISL_MODULE_VERIFICATION_FAILED ( CSSM_BASE_ERROR + 348L )
#define CSSM_EISL_MODULE_LOAD_FAILED	     ( CSSM_BASE_ERROR + 349L )

#define CSSM_INVALID_ATTRIBUTE_COUNT		 ( CSSM_BASE_ERROR + 358L )
#define CSSM_INVALID_ADDIN_HANDLE			 ( CSSM_BASE_ERROR + 500L )
#define CSSM_INVALID_GUID					 ( CSSM_BASE_ERROR + 501L )
#define CSSM_MEM_FUNCS_NOT_MATCHING			 ( CSSM_BASE_ERROR + 502L )
#define CSSM_VALUE_TOO_LARGE				 ( CSSM_BASE_ERROR + 503L )
#define CSSM_VALUE_TOO_SMALL				 ( CSSM_BASE_ERROR + 504L )


/* Certificate Library Error Codes */

#define CSSM_CL_UNKNOWN_FORMAT               ( CSSM_CL_BASE_ERROR + 1 )
#define CSSM_CL_UNKNOWN_TAG                  ( CSSM_CL_BASE_ERROR + 2 )
#define CSSM_CL_INVALID_CONTEXT              ( CSSM_CL_BASE_ERROR + 3 )
#define CSSM_CL_INVALID_CL_HANDLE            ( CSSM_CL_BASE_ERROR + 4 )
#define CSSM_CL_INVALID_CC_HANDLE            ( CSSM_CL_BASE_ERROR + 5 )
#define CSSM_CL_INVALID_CERT_POINTER         ( CSSM_CL_BASE_ERROR + 6 )
#define CSSM_CL_INVALID_FIELD_POINTER        ( CSSM_CL_BASE_ERROR + 7 )
#define CSSM_CL_INVALID_TEMPLATE             ( CSSM_CL_BASE_ERROR + 8 )
#define CSSM_CL_INVALID_DATA_POINTER         ( CSSM_CL_BASE_ERROR + 9 )
#define CSSM_CL_INVALID_SCOPE                ( CSSM_CL_BASE_ERROR + 10 )
#define CSSM_CL_CERT_CREATE_FAIL             ( CSSM_CL_BASE_ERROR + 12 )
#define CSSM_CL_CERT_VIEW_FAIL               ( CSSM_CL_BASE_ERROR + 13 )
#define CSSM_CL_CERT_GET_FIELD_VALUE_FAIL    ( CSSM_CL_BASE_ERROR + 14 )
#define CSSM_CL_CERT_GET_KEY_INFO_FAIL       ( CSSM_CL_BASE_ERROR + 15 )
#define CSSM_CL_CERT_IMPORT_FAIL             ( CSSM_CL_BASE_ERROR + 16 )
#define CSSM_CL_CERT_EXPORT_FAIL             ( CSSM_CL_BASE_ERROR + 17 )
#define CSSM_CL_PASS_THROUGH_FAIL            ( CSSM_CL_BASE_ERROR + 18 )
#define CSSM_CL_CERT_DESCRIBE_FORMAT_FAIL    ( CSSM_CL_BASE_ERROR + 19 )
#define CSSM_CL_UNSUPPORTED_OPERATION        ( CSSM_CL_BASE_ERROR + 20 )
#define CSSM_CL_MEMORY_ERROR                 ( CSSM_CL_BASE_ERROR + 21 )
#define CSSM_CL_CERT_SIGN_FAIL               ( CSSM_CL_BASE_ERROR + 22 )
#define CSSM_CL_CERT_UNSIGN_FAIL             ( CSSM_CL_BASE_ERROR + 23 )
#define CSSM_CL_CERT_VERIFY_FAIL             ( CSSM_CL_BASE_ERROR + 24 )
#define CSSM_CL_RESULTS_HANDLE               ( CSSM_CL_BASE_ERROR + 25 )
#define CSSM_CL_INVALID_SIGNER_CERTIFICATE   ( CSSM_CL_BASE_ERROR + 26 )
#define CSSM_CL_NO_FIELD_VALUES              ( CSSM_CL_BASE_ERROR + 27 )
#define CSSM_CL_INVALID_CRL_PTR              ( CSSM_CL_BASE_ERROR + 28 )
#define CSSM_CL_CERT_ABORT_QUERY_FAIL        ( CSSM_CL_BASE_ERROR + 29 )
#define CSSM_CL_CRL_CREATE_FAIL              ( CSSM_CL_BASE_ERROR + 30 )
#define CSSM_CL_CRL_SET_FAIL                 ( CSSM_CL_BASE_ERROR + 31 )
#define CSSM_CL_CRL_ADD_CERT_FAIL            ( CSSM_CL_BASE_ERROR + 32 )
#define CSSM_CL_CRL_REMOVE_CERT_FAIL         ( CSSM_CL_BASE_ERROR + 33 )
#define CSSM_CL_CRL_SIGN_FAIL                ( CSSM_CL_BASE_ERROR + 34 )
#define CSSM_CL_CRL_VERIFY_FAIL              ( CSSM_CL_BASE_ERROR + 35 )
#define CSSM_CL_IS_CERT_IN_CRL_FAIL          ( CSSM_CL_BASE_ERROR + 36 )
#define CSSM_CL_CRL_GET_FIELD_VALUE_FAIL     ( CSSM_CL_BASE_ERROR + 37 )
#define CSSM_CL_CRL_ABORT_QUERY_FAIL         ( CSSM_CL_BASE_ERROR + 38 )
#define CSSM_CL_CRL_DESCRIBE_FORMAT_FAIL     ( CSSM_CL_BASE_ERROR + 39 )
#define CSSM_CL_INVALID_POINTER              ( CSSM_CL_BASE_ERROR + 40 )
#define CSSM_CL_INVALID_DATA                 ( CSSM_CL_BASE_ERROR + 41 )
#define CSSM_CL_INITIALIZE_FAIL              ( CSSM_CL_BASE_ERROR + 42 )

#define CSSM_CL_INVALID_REVOKER_CERT_PTR     ( CSSM_CL_BASE_ERROR + 101 )
#define CSSM_CL_NO_REVOKED_CERTS_IN_CRL      ( CSSM_CL_BASE_ERROR + 102 )
#define CSSM_CL_CERT_NOT_FOUND_IN_CRL        ( CSSM_CL_BASE_ERROR + 103 )
#define CSSM_CL_CRL_SIGNSCOPE_NOT_SUPPORTED  ( CSSM_CL_BASE_ERROR + 104 )
#define CSSM_CL_CRL_VERIFYSCOPE_NOT_SUPPORTED (CSSM_CL_BASE_ERROR + 105 )
#define CSSM_CL_CRL_NOT_SIGNEDBY_SIGNER      ( CSSM_CL_BASE_ERROR + 106 )
#define CSSM_CL_CRL_NO_FIELD_OID             ( CSSM_CL_BASE_ERROR + 107 )

#define CSSM_CL_SIG_NOT_IN_CERT              ( CSSM_CL_BASE_ERROR + 100 )
#define CSSM_CL_INVALID_REVOKED_CERT_PTR     ( CSSM_CL_BASE_ERROR + 108 )
#define CSSM_CL_INVALID_INPUT_PTR            ( CSSM_CL_BASE_ERROR + 109 )

#define CSSM_CL_KEY_ALGID_NOT_SUPPORTED      ( CSSM_CL_BASE_ERROR + 110 )
#define CSSM_CL_GET_KEY_ATTRIBUTE_FAIL       ( CSSM_CL_BASE_ERROR + 111 )
#define CSSM_CL_CERT_ENCODE_FAIL             ( CSSM_CL_BASE_ERROR + 112 )
#define CSSM_CL_CERT_DECODE_FAIL             ( CSSM_CL_BASE_ERROR + 113 )
#define CSSM_CL_SIGNATURE_ALGID_NOT_SUPPORTED ( CSSM_CL_BASE_ERROR + 114 )
#define CSSM_CL_KEY_FORMAT_UNKNOWN           ( CSSM_CL_BASE_ERROR + 115 )
#define CSSM_CL_INVALID_CERT_ISSUER_NAME     ( CSSM_CL_BASE_ERROR + 116 )
#define CSSM_CL_INVALID_CERT_SUBJECT_NAME    ( CSSM_CL_BASE_ERROR + 117 )
#define CSSM_CL_MISSING_CERT_SUBJECT_NAME    ( CSSM_CL_BASE_ERROR + 118 )
#define CSSM_CL_MISSING_CERT_ISSUER_NAME     ( CSSM_CL_BASE_ERROR + 119 )
#define CSSM_CL_MISSING_CERT_VALIDITY        ( CSSM_CL_BASE_ERROR + 120 )
#define CSSM_CL_MISSING_SUBJECT_PUB_KEY      ( CSSM_CL_BASE_ERROR + 121 )
#define CSSM_CL_FIELD_NOT_PRESENT            ( CSSM_CL_BASE_ERROR + 122 )
#define CSSM_CL_SIGNER_CERT_EXPIRED			 ( CSSM_CL_BASE_ERROR + 123 )
#define CSSM_CL_SUBJECT_CERT_EXPIRED		 ( CSSM_CL_BASE_ERROR + 124 )
#define CSSM_CL_INCOMPATIBLE_CSP			 ( CSSM_CL_BASE_ERROR + 125 )
#define CSSM_CL_GET_CSP_HANDLE_ATTRIBUTE_FAIL ( CSSM_CL_BASE_ERROR + 126)
#define CSSM_CL_GET_GUID_FROM_HANDLE_FAIL	 ( CSSM_CL_BASE_ERROR + 127)


/* Trust Policy Library Error Codes */

#define CSSM_TP_NOT_LOADED                   ( CSSM_TP_BASE_ERROR + 1 )
#define CSSM_TP_INVALID_TP_HANDLE            ( CSSM_TP_BASE_ERROR + 2 )
#define CSSM_TP_INVALID_CL_HANDLE            ( CSSM_TP_BASE_ERROR + 3 )
#define CSSM_TP_INVALID_DL_HANDLE            ( CSSM_TP_BASE_ERROR + 4 )
#define CSSM_TP_INVALID_DB_HANDLE            ( CSSM_TP_BASE_ERROR + 5 )
#define CSSM_TP_INVALID_CC_HANDLE            ( CSSM_TP_BASE_ERROR + 6 )
#define CSSM_TP_INVALID_CERTIFICATE          ( CSSM_TP_BASE_ERROR + 7 )
#define CSSM_TP_NOT_SIGNER                   ( CSSM_TP_BASE_ERROR + 8 )
#define CSSM_TP_NOT_TRUSTED                  ( CSSM_TP_BASE_ERROR + 9 )
#define CSSM_TP_CERT_VERIFY_FAIL             ( CSSM_TP_BASE_ERROR + 10 )
#define CSSM_TP_CERTIFICATE_CANT_OPERATE     ( CSSM_TP_BASE_ERROR + 11 )
#define CSSM_TP_MEMORY_ERROR                 ( CSSM_TP_BASE_ERROR + 12 )
#define CSSM_TP_CERT_SIGN_FAIL               ( CSSM_TP_BASE_ERROR + 13 )
#define CSSM_TP_INVALID_CRL                  ( CSSM_TP_BASE_ERROR + 14 )
#define CSSM_TP_CERT_REVOKE_FAIL             ( CSSM_TP_BASE_ERROR + 15 )
#define CSSM_TP_CRL_VERIFY_FAIL              ( CSSM_TP_BASE_ERROR + 16 )
#define CSSM_TP_CRL_SIGN_FAIL                ( CSSM_TP_BASE_ERROR + 17 )
#define CSSM_TP_APPLY_CRL_TO_DB_FAIL         ( CSSM_TP_BASE_ERROR + 18 )
#define CSSM_TP_INVALID_GUID                 ( CSSM_TP_BASE_ERROR + 19 )
#define CSSM_TP_UNISTALL_FAIL                ( CSSM_TP_BASE_ERROR + 20 )
#define CSSM_TP_INCOMPATIBLE_VERSION         ( CSSM_TP_BASE_ERROR + 21 )
#define CSSM_TP_INVALID_ACTION               ( CSSM_TP_BASE_ERROR + 22 )
#define CSSM_TP_VERIFY_ACTION_FAIL           ( CSSM_TP_BASE_ERROR + 23 )
#define CSSM_TP_INVALID_DATA_POINTER         ( CSSM_TP_BASE_ERROR + 24 )
#define CSSM_TP_INVALID_ID                   ( CSSM_TP_BASE_ERROR + 25 )
#define CSSM_TP_PASS_THROUGH_FAIL            ( CSSM_TP_BASE_ERROR + 26 )
#define CSSM_TP_INVALID_CSP_HANDLE			 ( CSSM_TP_BASE_ERROR + 27 )
#define CSSM_TP_ANCHOR_NOT_SELF_SIGNED		 ( CSSM_TP_BASE_ERROR + 28 )
#define CSSM_TP_ANCHOR_NOT_FOUND			 ( CSSM_TP_BASE_ERROR + 29 )
#define CSSM_TP_INVALID_KEY_FORMAT			 ( CSSM_TP_BASE_ERROR + 30 )


/* Data Library Error Codes */

#define CSSM_DL_NOT_LOADED                   ( CSSM_DL_BASE_ERROR + 1 )
#define CSSM_DL_INVALID_DL_HANDLE            ( CSSM_DL_BASE_ERROR + 2 ) 
#define CSSM_DL_DATASTORE_NOT_EXISTS         ( CSSM_DL_BASE_ERROR + 3 ) 
#define CSSM_DL_MEMORY_ERROR                 ( CSSM_DL_BASE_ERROR + 4 ) 
#define CSSM_DL_DB_OPEN_FAIL                 ( CSSM_DL_BASE_ERROR + 5 ) 
#define CSSM_DL_INVALID_DB_HANDLE            ( CSSM_DL_BASE_ERROR + 6 ) 
#define CSSM_DL_DB_CLOSE_FAIL                ( CSSM_DL_BASE_ERROR + 7 ) 
#define CSSM_DL_DB_CREATE_FAIL               ( CSSM_DL_BASE_ERROR + 8 ) 
#define CSSM_DL_DB_DELETE_FAIL               ( CSSM_DL_BASE_ERROR + 9 ) 
#define CSSM_DL_INVALID_PTR                  ( CSSM_DL_BASE_ERROR + 10 )
#define CSSM_DL_DB_IMPORT_FAIL               ( CSSM_DL_BASE_ERROR + 11 )
#define CSSM_DL_DB_EXPORT_FAIL               ( CSSM_DL_BASE_ERROR + 12 )
#define CSSM_DL_INVALID_CERTIFICATE_PTR      ( CSSM_DL_BASE_ERROR + 13 )
#define CSSM_DL_CERT_INSERT_FAIL             ( CSSM_DL_BASE_ERROR + 14 )
#define CSSM_DL_CERTIFICATE_NOT_IN_DB        ( CSSM_DL_BASE_ERROR + 15 )
#define CSSM_DL_CERT_DELETE_FAIL             ( CSSM_DL_BASE_ERROR + 16 )
#define CSSM_DL_CERT_REVOKE_FAIL             ( CSSM_DL_BASE_ERROR + 17 )
#define CSSM_DL_INVALID_SELECTION_PTR        ( CSSM_DL_BASE_ERROR + 18 )
#define CSSM_DL_NO_CERTIFICATE_FOUND         ( CSSM_DL_BASE_ERROR + 19 )
#define CSSM_DL_CERT_GETFIRST_FAIL           ( CSSM_DL_BASE_ERROR + 20 )
#define CSSM_DL_NO_MORE_CERTS                ( CSSM_DL_BASE_ERROR + 21 )
#define CSSM_DL_CERT_GET_NEXT_FAIL           ( CSSM_DL_BASE_ERROR + 22 )
#define CSSM_DL_CERT_ABORT_QUERY_FAIL        ( CSSM_DL_BASE_ERROR + 23 )
#define CSSM_DL_INVALID_CRL_PTR              ( CSSM_DL_BASE_ERROR + 24 )
#define CSSM_DL_CRL_INSERT_FAIL              ( CSSM_DL_BASE_ERROR + 25 )
#define CSSM_DL_CRL_NOT_IN_DB                ( CSSM_DL_BASE_ERROR + 26 )
#define CSSM_DL_CRL_DELETE_FAIL              ( CSSM_DL_BASE_ERROR + 27 )
#define CSSM_DL_NO_CRL_FOUND                 ( CSSM_DL_BASE_ERROR + 28 )
#define CSSM_DL_CRL_GET_FIRST_FAIL           ( CSSM_DL_BASE_ERROR + 29 )
#define CSSM_DL_NO_MORE_CRLS                 ( CSSM_DL_BASE_ERROR + 30 )
#define CSSM_DL_CRL_GET_NEXT_FAIL            ( CSSM_DL_BASE_ERROR + 31 )
#define CSSM_DL_CRL_ABORT_QUERY_FAIL         ( CSSM_DL_BASE_ERROR + 32 )
#define CSSM_DL_GET_DB_NAMES_FAIL            ( CSSM_DL_BASE_ERROR + 33 )
#define CSSM_DL_INVALID_PASSTHROUGH_ID       ( CSSM_DL_BASE_ERROR + 34 )
#define CSSM_DL_PASS_THROUGH_FAIL            ( CSSM_DL_BASE_ERROR + 35 )
#define CSSM_DL_INVALID_POINTER              ( CSSM_DL_BASE_ERROR + 36 )
#define CSSM_DL_NO_DATASOURCES               ( CSSM_DL_BASE_ERROR + 37 )
#define CSSM_DL_INCOMPATIBLE_VERSION         ( CSSM_DL_BASE_ERROR + 38 )
#define CSSM_DL_INVALID_FIELD_INFO           ( CSSM_DL_BASE_ERROR + 39 )
#define CSSM_DL_INVALID_ATTRIBUTE_NAME_FORMAT ( CSSM_DL_BASE_ERROR + 40 )
#define CSSM_DL_CONJUNCTIVE_NOT_SUPPORTED    ( CSSM_DL_BASE_ERROR + 41 )
#define CSSM_DL_OPERATOR_NOT_SUPPORTED       ( CSSM_DL_BASE_ERROR + 42 )
#define CSSM_DL_NO_MORE_OBJECT               ( CSSM_DL_BASE_ERROR + 43 )
#define CSSM_DL_INVALID_RESULTS_HANDLE       ( CSSM_DL_BASE_ERROR + 44 )
#define CSSM_DL_INVALID_ATTRIBUTE_NAME       ( CSSM_DL_BASE_ERROR + 45 )
#define CSSM_DL_INVALID_ATTRIBUTE            ( CSSM_DL_BASE_ERROR + 46 )
#define CSSM_DL_UNKNOWN_KEY_TYPE             ( CSSM_DL_BASE_ERROR + 47 )
#define CSSM_DL_BUFFER_TOO_SMALL             ( CSSM_DL_BASE_ERROR + 48 )

#define CSSM_DL_INVALID_DATA_POINTER         ( CSSM_DL_BASE_ERROR + 100 )
#define CSSM_DL_INVALID_DLINFO_POINTER       ( CSSM_DL_BASE_ERROR + 101 )
#define CSSM_DL_INSTALL_FAIL                 ( CSSM_DL_BASE_ERROR + 102 )
#define CSSM_DL_INVALID_GUID                 ( CSSM_DL_BASE_ERROR + 103 )
#define CSSM_DL_UNINSTALL_FAIL               ( CSSM_DL_BASE_ERROR + 104 )
#define CSSM_DL_LIST_MODULES_FAIL            ( CSSM_DL_BASE_ERROR + 105 )
#define CSSM_DL_ATTACH_FAIL                  ( CSSM_DL_BASE_ERROR + 107 )
#define CSSM_DL_DETACH_FAIL                  ( CSSM_DL_BASE_ERROR + 108 )
#define CSSM_DL_GET_INFO_FAIL                ( CSSM_DL_BASE_ERROR + 109 )
#define CSSM_DL_FREE_INFO_FAIL               ( CSSM_DL_BASE_ERROR + 110 )
#define CSSM_DL_INVALID_DLINFO_PTR           ( CSSM_DL_BASE_ERROR + 111 )
#define CSSM_DL_INVALID_CL_HANDLE            ( CSSM_DL_BASE_ERROR + 112 )

#define CSSM_DL_INVALID_CRL                  ( CSSM_DL_BASE_ERROR + 114 )
#define CSSM_DL_INVALID_CRL_POINTER          ( CSSM_DL_BASE_ERROR + 115 )

#define CSSM_DL_INVALID_RECORD_TYPE          ( CSSM_DL_BASE_ERROR + 116 )
#define CSSM_DL_DATA_INSERT_FAIL             ( CSSM_DL_BASE_ERROR + 117 )
#define CSSM_DL_DATA_GETFIRST_FAIL           ( CSSM_DL_BASE_ERROR + 118 )
#define CSSM_DL_DATA_GETNEXT_FAIL            ( CSSM_DL_BASE_ERROR + 119 )
#define CSSM_DL_NO_DATA_FOUND                ( CSSM_DL_BASE_ERROR + 120 )
#define CSSM_DL_INVALID_AUTHENTICATION       ( CSSM_DL_BASE_ERROR + 121 )
#define CSSM_DL_DATA_ABORT_QUERY_FAIL        ( CSSM_DL_BASE_ERROR + 122 )
#define CSSM_DL_DATA_DELETE_FAIL             ( CSSM_DL_BASE_ERROR + 123 )
#define CSSM_DL_INTERNAL_ERROR               ( CSSM_DL_BASE_ERROR + 124 )
#define CSSM_DL_PARAM_INVALID_VALUE          ( CSSM_DL_BASE_ERROR + 125 )
#define CSSM_DL_ACCESS_ERROR                 ( CSSM_DL_BASE_ERROR + 126 )


#endif /* _CSSMERR_H */
