/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef JNH_OBJECTSTORE_H_
#define JNH_OBJECTSTORE_H_

// Jonah ObjectStore

#include <ObjectCache.h>
#include <ObjectStore.h>
#include <ObjectDefs.h>
#include <pkiTask.h>
#include <inimsg.h>

EXPORTFN(uint32,
         JnhInitializeOs,
         (int size = 10));
// The initialization process will call this routine, after having initialized 
// the IniFile.

EXPORTFN(uint32,
         JnhStoreObject,
         (ObjStoreData * objectPtr, uint32 objClass, uint32 * key));
// storeObject saves the provided object in the backing-store,
// and returns the new key.  This is how new objects are placed
// in the objectstore.  The objectstore does not take ownership 
// of the object designated by objectPtr;  A subsequent getObject
// operation using this key will result in a new in-memory object 
// being created.  Therefore the caller should discard the 
// original object after making this call.  If the objectCache
// keeps its own in-memory copy of the object, that copy shall 
// be marked unlocked and unmodified.

EXPORTFN(uint32,
         JnhCreateObject,
         (uint32 objClass, ObjStoreData ** objectPtr, uint32 * key));
// createObject creates a new object, assigns a objectstore key to it,
// and returns the new key and object, which is marked locked and modified.  
// The objectStore owns the object designated by objectPtr, so the caller
// must not destroy it.  


EXPORTFN(uint32,
         JnhGetObject,
         (uint32 key, uint32 * objClass, const ObjStoreData ** objectPtr));  
// getObject retrieves a read-only pointer to the object whose 
// key is <key>, reading the object from backing-store if 
// necessary.  The object will be locked, and the cache must 
// retain the object until it is explicitly deleted by a call 
// to deleteObject(), or unlocked by a call to unlockObject() 
// or discardObject().  If the object was read from disk by 
// this call, its <modified> flag will be cleared; if it 
// was in-memory its <modified> flag will be unchanged.

EXPORTFN(uint32,
         JnhGetTransientData,
         (uint32 key, TransientData ** transientData));  
// getObject retrieves a pointer to the transient data associated
// with the object whose key is <key>, reading the object from 
// backing-store if necessary.  The object will be locked, and 
// the cache must retain the object until it is explicitly deleted 
// by a call to deleteObject(), or unlocked by a call to 
// unlockObject() or discardObject().  If the object was read 
// from disk by this call, its <modified> flag will be cleared; 
// if it was in-memory its <modified> flag will be unchanged.

EXPORTFN(uint32,
         JnhLockObject,
         (uint32 key));
// Lock the object

EXPORTFN(uint32,
         JnhGetObjectModify,
         (uint32 key, uint32 * objClass, ObjStoreData ** objectPtr));  
// getObjectModify retrieves a pointer to the object whose key 
// is <key>, reading the object from backing-store if necessary.
// The object must already be locked.
// be set.

EXPORTFN(uint32,
         JnhGetObjectFlags,
         (uint32 key, uint32 * objClass));
// getObjectFlags returns the flags associated with the specified
// object.

EXPORTFN(uint32,
         JnhSetObjectFlags,
         (uint32 key, uint32 objClass));
// setObjectFlags sets the flags associated with the specified
// object.  The object must be locked and marked for modification.

EXPORTFN(uint32,
         JnhUnlockObject,
         (uint32 key));  
EXPORTFN(uint32,
         JnhDiscardObject,
         (uint32 key));  
// discard any changes that may have been made to the in-memory
// object.  After either of these calls, the caller must make 
// a lockObject and a getObject call before it may access the 
// object again.  The semantics of these calls are identical. 
// The distinction between the two functions is that discardObject 
// indicates that the caller has no subsequent intent to activate 
// the object, while unlockObject indicates that subsequent access
// is likely.  This may affect whether the objectCache implements
// the function simply by deleting the in-memory object, or (if 
// the object's <modified> flag is set) by re-reading its contents 
// from disk, although either implementation will work for either 
// function.  After either call, if the object is retained in memory,
// it will be unlocked and its <modified> flag cleared.
  
EXPORTFN(uint32,
         JnhSynchObject,
         (uint32 key));
// synchObject replaces the designated object in the backing-store.
// If the object is not locked, an error should be returned and no 
// action performed.  If the object's <modified> flag is not set, 
// an error should be returned, and no action performed.  On 
// succesful completion, the object's <modified> flag is cleared, 
// and the object is unlocked.
  
EXPORTFN(uint32,
         JnhDeleteObject,
         (uint32 key));
// deleteObject deletes the designated object, both from memory and
// from the backing-store.  The object may be locked or unlocked
// prior to this call, and the state of its <modified> flag is
// not significant.

EXPORTFN(uint32,
         JnhListActiveObjects,
         (void (* callback)(uint32 key, uint32 objClassSt)));
// Run through the database, calling <callback> for every object whose 
// objClass is active

EXPORTFN(uint32,
         JnhListSurrogateObjects,
         (void (* callback)(uint32 key, uint32 objClassSt)));
// Run through the database, calling <callback> for every object whose 
// objClass is surrogate

EXPORTFN(uint32,
         JnhListObjectsByClass,
         (uint32 objClass, void (* callback)(uint32 key, uint32 objClassSt)));
// Run through the database, calling <callback> for every object
// whose objClass intersects the specified class (masked with ObjClAll)

EXPORTFN(uint32,
         JnhListObjectsByState,
         (uint32 objClass, void (* callback)(uint32 key, uint32 objClassSt)));
// Run through the database, calling <callback> for every object
// whose state matches the specified state (masked with ObjStAll)



#endif