/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef JONAH_INI_
#define JONAH_INI_

// This header defines operations on the Jonah initializtion
// oprerations.  Most of these concern access to data stored in 
// the INIfile, but there are also routines that embody the 
// knowledge as to whether we are running as an end-entity, a
// RA or a CA.
//
// The INIfile operated on will depend on whether this is a client 
// App, the RA or the CA, but components that need to put stuff
// in an initialization file can just use these routines and
// not care what file (or other storage mechanism) is actually 
// being used.  Of course, CA-type information should only be
// stored or retrieved by a server that's running as a CA.


#include <platform.h>
#include <StrngLst.h>

#define Ini_EE 0
#define Ini_RA 1
#define Ini_CA 2

EXPORTFN(bool, APILINKAGE IniInitialize,
         (int server_type = Ini_EE));
// Only one thread should invoke IniInitialize, and no other 
// JONAH_INI routines should be invoked until IniInitialize
// has returned.


EXPORTFN(bool, APILINKAGE IniAmICA,
         (void));
// Return true if this server is operating as a CA.

EXPORTFN(bool, APILINKAGE IniAmIRA,
         (void));
// Return true if this server is operating as an RA.

EXPORTFN(bool, APILINKAGE IniReadString,
         (const char * section, 
          const char * key,
          char * buffer,
          size_t bufferLength,
          const char * defaultValue = NULL));

EXPORTFN (bool,
          IniReadInteger,
          (const char * section,
           const char * key,
           int & value,
           int defaultValue = 0));

EXPORTFN(bool,
         IniReadBoolean,
         (const char * section,
          const char * key,
          bool & value,
          bool defaultValue = false));

EXPORTFN(bool,
         IniWriteString,
         (const char * section,
          const char * key,
          const char * value));

EXPORTFN(bool,
         IniWriteInteger,
         (const char * section,
          const char * key,
          int value));

EXPORTFN(bool,
         IniWriteBoolean,
         (const char * section,
          const char * key,
          bool value));

// getSections returns a list of all the sections in the file.
EXPORTFN(void,
         IniGetSections,
         (StringList & sl));

// getKeys returns a list of all the keys in the specified section.
// The function returns true if the section was found, false if not.
EXPORTFN(bool,
         IniGetKeys,
         (const char * section,
          StringList & sl));

// WriteFile returns true if the file was written succesfully.
// WriteFile is automatically called on program termination
// if there are un-written changes.
EXPORTFN(bool,
         IniWriteFile,
         (void));


#endif
