/* SCCSID: fwk/cssm/internal.h, dss_cdsa_fwk, fwk_rel1, rel1_level1 1.9 8/10/97 10:42:45 */
/*-----------------------------------------------------------------------
**      File:   INTERNAL.H
**
** Copyright (c) 1995, 1996 Intel Corporation. All rights reserved.
**-----------------------------------------------------------------------
*/
/* 
    * INTEL CONFIDENTIAL 
    * This file, software, or program is supplied under the terms of a 
    * license agreement or nondisclosure agreement with Intel Corporation 
    * and may not be copied or disclosed except in accordance with the 
    * terms of that agreement. This file, software, or program contains 
    * copyrighted material and/or trade secret information of Intel 
    * Corporation, and must be treated as such. Intel reserves all rights 
    * in this material, except as the license agreement or nondisclosure 
    * agreement specifically indicate. 
    */ 
/* 
    * WARNING: EXPORT RESTRICTED. 
    * This software listing contains cryptographic methods and technology. 
    * It is export restricted by the Office of Defense Trade Controls, United 
    * States Department of State and cannot be downloaded or otherwise 
    * exported or re-exported (i) into (or to a national or resident of) Cuba, 
    * Iraq, Libya, Yugoslavia, North Korea, Iran, Syria or any other country 
    * to which the US has embargoed goods; or (ii) to anyone on the US 
    * Treasury Department's list of Specially Designated Nationals or the US 
    * Commerce Department's Table of Denial Orders. By downloading or using 
    * this product, you are agreeing to the foregoing and you are representing 
    * and warranting that you are not located in, under the control of, or a 
    * national or resident of any such country or on any such list. 
    */ 

#ifndef _INTERNAL_H
#define _INTERNAL_H

#include "cssmport.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define BUFSIZE 80
#define MAX_REG 256

/* Simple hash table scheme to store internal context structures
 */

/* Change to a more generic hash function - if needed */
#define CTXFACTOR	1103515245L
#define CTXOFFSET	12345
#define CTXMASK	    0x7f
#define CTXSHIFT	16
#define HashContext(a) ((((int)(a)*CTXFACTOR+CTXOFFSET)>>CTXSHIFT)&CTXMASK)

#define	CTXTABLESZ	 CTXMASK+1
#define CMUTEXNAMESZ 64
#define CMUTEXNAME   "CTXLOCK"

typedef void * (*CSSM_MALLOC) (uint32, void *);
typedef void * (*CSSM_REALLOC) (void *, uint32, void *);
typedef void (*CSSM_FREE) (void *, void *);
typedef void * (*CSSM_CALLOC) (uint32, uint32, void*);

typedef CSSM_RETURN  (*ADDIN_AUTH_FUNC_PTR) (char *, char *);

#include "cssmspi.h"
 
CSSM_RETURN CSSMAPI CSSM_InitError (void);
CSSM_RETURN CSSMAPI CSSM_DestroyError (void);

extern CSSM_GUID cssm_GUID;
extern CSSM_FREE app_free;
extern CSSM_MALLOC app_malloc; 
extern CSSM_REALLOC app_realloc; 
extern CSSM_CALLOC app_calloc;
extern void *memRef;

typedef enum cssm_rand_type {
    CSSM_CCHANDLE = 0,
    CSSM_ADDIN = 1
} cssm_RAND_TYPE;

/* Plugin Handle Chain Structure */
typedef struct internalMemoryJT {
    CSSM_HANDLE Handle;
    CSSM_API_MEMORY_FUNCS_PTR MemoryFunctions;
    uint32 Application;
    CSSM_NOTIFY_CALLBACK Notification;
    uint32 SubServiceID;
    uint32 SubServiceFlags;
    struct internalMemoryJT *Next;
} cssm_INTERNALMEMORYJT, *cssm_INTERNALMEMORYJT_PTR;


typedef struct IntModuleList {
    CSSM_GUID GUID;                /* Name of Plug-in */
    cssm_INTERNALMEMORYJT_PTR AppMemory; /* Handles issued for add-in */
    CSSM_LIB_HANDLE LibHandle;     /* Handle to actual library */
    BOOL AddinInitialized;
    uint32 ServiceSummary;
    BOOL ThreadSafe;
    HANDLE MultiTaskMutex;            /* Mutex for functions in Addin */
    struct IntModuleList* Next;     /* Next Plug-in in list */
    CSSM_REGISTRATION_INFO_PTR AddInJT;   /* Entry point into the Add-in functions */
} cssm_INTERNALMODULELIST, *cssm_INTERNALMODULELIST_PTR;

CSSM_SPI_MEMORY_FUNCS InternalMemoryFuncs;

/* Define constants representing each callback function
 * index here.
 */

CSSM_RETURN CSSMAPI CSSMVerifyComponents (void);
CSSM_RETURN CSSMAPI cssm_CheckInit (void);
CSSM_RETURN CSSMAPI cssm_AddInInstall (CSSM_SERVICE_MASK AddInType,
                                 const char * pName,
                                 const char * pFileName,
                                 const char * pLocation,
                                 const CSSM_GUID_PTR GUID,
                                 const void * Info);
CSSM_RETURN CSSMAPI cssm_ModuleInstall (
                                 const char *ModuleName,
                                 const char *ModuleFileNames,
                                 const char *ModulePathName,
                                 const CSSM_GUID_PTR GUID,
                                 const CSSM_MODULE_INFO_PTR ModuleDescription,
                                 const void * Reserved1,
                                 const CSSM_DATA_PTR Reserved2);
CSSM_RETURN CSSMAPI cssm_AddInUninstall (CSSM_SERVICE_MASK AddInType,
                                          const CSSM_GUID_PTR GUID);
CSSM_RETURN CSSMAPI cssm_ModuleUninstall (const CSSM_GUID_PTR GUID);
CSSM_RETURN CSSMAPI cssm_RegWriteData (CSSM_SERVICE_MASK AddInType,
                         const char * szMSCLName,
                         const char * szDllName,
                         const char * szLocation,
                         const CSSM_GUID_PTR GUID,
                         const void *Info,
                         const uint32 *pServiceMask,
                         uint32 *pMessages,
                         sint32 NumberMessages);
CSSM_RETURN CSSMAPI cssm_RegWriteModule (
                                 const char *ModuleName,
                                 const char *ModuleFileName,
                                 const char *ModulePathName,
                                 const CSSM_GUID_PTR GUID,
                                 const CSSM_MODULE_INFO_PTR ModuleDescription,
                                 const void * Reserved1,
                                 const CSSM_DATA_PTR Reserved2);
CSSM_API_MEMORY_FUNCS_PTR CSSMAPI cssm_GetMemory (CSSM_HANDLE handle);
CSSM_HANDLEINFO_PTR cssm_GetHandleInfo(CSSM_HANDLE hModule);

CSSM_RETURN CSSMAPI cssm_FreeTPSubService (CSSM_TPSUBSERVICE_PTR Info);
CSSM_RETURN CSSMAPI cssm_FreeCSPSubService (CSSM_CSPSUBSERVICE_PTR Info);
CSSM_RETURN CSSMAPI cssm_FreeDLSubService (CSSM_DLSUBSERVICE_PTR Info);
CSSM_RETURN CSSMAPI cssm_FreeCLSubService (CSSM_CLSUBSERVICE_PTR Info);

CSSM_RETURN cssm_FreeModule (const CSSM_MODULE_INFO_PTR ModuleDescription);

CSSM_RETURN CSSMAPI cssm_RegReadDefaultDatabase (char * szDBName);
CSSM_RETURN CSSMAPI cssm_RegWriteDefaultDatabase(char * szDBName);
CSSM_RETURN CSSMAPI cssm_RegCreateDatabase(char * szDBName,
                             char * szDBLocation);
CSSM_RETURN CSSMAPI cssm_RegReadDatabaseLocation(char * szDBName,
                                   char * szDBLocation);
CSSM_RETURN CSSMAPI cssm_RegRemoveAddIn (CSSM_SERVICE_MASK AddInType,
                                const CSSM_GUID_PTR GUID);
CSSM_RETURN CSSMAPI cssm_RegRemoveModule (const CSSM_GUID_PTR GUID);
CSSM_RETURN CSSMAPI cssm_RegReadDatabaseList(char ***DBlist);
CSSM_LIST_PTR CSSMAPI cssm_RegReadModuleList (CSSM_SERVICE_MASK UsageMask,
                                             CSSM_BOOL MatchAll);
CSSM_SERVICE_MASK CSSMAPI cssm_RegReadUsage (const CSSM_GUID_PTR GUID);
CSSM_MODULE_INFO_PTR CSSMAPI cssm_RegReadModuleInfo (const CSSM_GUID_PTR ModuleGUID,
                                                 CSSM_SERVICE_MASK UsageMask,
                                                 uint32 SubserviceID,
                                                 CSSM_INFO_LEVEL InfoLevel); 
CSSM_RETURN CSSMAPI cssm_RegWriteModuleInfo (char *regKey,
                                             CSSM_MODULE_INFO_PTR ModuleDescription);
CSSM_CSSMINFO_PTR CSSMAPI cssm_RegReadCSSMInfo (void);
CSSM_RETURN cssm_GetModuleByHandle (CSSM_HANDLE hAddIn, 
                                   uint32 *ServiceID,
                                   cssm_INTERNALMODULELIST_PTR *ModuleRecord);
CSSM_REGISTRATION_INFO_PTR CSSMAPI cssm_GetModuleCallBackByHandle (
                                         CSSM_HANDLE hAddIn);


/* Management interface functions */
CSSM_RETURN CSSMAPI cssm_RemoveAddInRecord (const CSSM_GUID_PTR GUID);
CSSM_RETURN CSSMAPI cssm_NewModuleRecord(const CSSM_GUID_PTR GUID,
                                 const CSSM_REGISTRATION_INFO_PTR FunctionTable);
CSSM_RETURN CSSMAPI cssm_LoadAddInByName(char * pAddInName,
                            uint32 AddInType,
                            CSSM_HANDLE *phAddIn);
CSSM_RETURN CSSMAPI cssm_UnloadAddInByHandle(CSSM_HANDLE hAddIn,
                                CSSM_SERVICE_MASK AddInType);
void * CSSMAPI cssm_GetAddInCallBackByHandle (CSSM_HANDLE hAddIn,
                                              CSSM_SERVICE_MASK AddInType);
CSSM_HANDLE CSSMAPI cssm_ModuleAttach (const CSSM_GUID_PTR GUID,
                                      CSSM_VERSION_PTR pVersion,
                                      const CSSM_API_MEMORY_FUNCS_PTR MemoryFunc
,
                                      uint32 SubServiceID,
                                      uint32 SubServiceFlags,
                                      uint32 Application,
                                      const CSSM_NOTIFY_CALLBACK Notification,
                                      CSSM_EVENT_TYPE eventType,
                                      CSSM_EVENT_TYPE detachEventType);
CSSM_RETURN CSSMAPI cssm_AddInDetach (CSSM_HANDLE AddInHandle,
                                      CSSM_EVENT_TYPE eventType);
CSSM_RETURN CSSMAPI cssm_RegGetLocation (const CSSM_GUID_PTR GUID, 
                                 char *path);

CSSM_MODULE_INFO_PTR cssm_dynamic_getinfo (const CSSM_GUID_PTR GUID,
                                           CSSM_SERVICE_MASK UsageMask,
                                           uint32 SubserviceID,
                                           CSSM_INFO_LEVEL InfoLevel);

uint32 cssm_Rand (cssm_RAND_TYPE type);
CSSM_RETURN cssm_CheckAPIMemFuncs (
                              const CSSM_API_MEMORY_FUNCS_PTR MemoryFunctions);
cssm_INTERNALMEMORYJT_PTR cssm_FindMemory (CSSM_HANDLE handle, 
                                           cssm_INTERNALMODULELIST_PTR AddInHead);
CSSM_SERVICE_MASK CSSMAPI cssm_GetUsageMask (CSSM_HANDLE ModuleHandle);
CSSM_GUID_PTR CSSMAPI cssm_GetGUIDFromHandle (CSSM_HANDLE ModuleHandle);

CSSM_RETURN cssm_CheckCopy (void *Dest, void *Src, uint32 size);
HANDLE CSSMAPI cssm_GetMultitaskMutexHandle (CSSM_HANDLE hAddIn,
                                              CSSM_SERVICE_MASK AddInType);

BOOL CSSMAPI cssm_CheckThreadSafe (CSSM_HANDLE hAddIn,
                                              CSSM_SERVICE_MASK AddInType);
void CSSMAPI cssm_GetAddInName (CSSM_SERVICE_MASK AddInType,
                                char *AddInName);

void CSSMAPI cssm_GUIDToStr (const CSSM_GUID_PTR GUID, char *ID);
CSSM_RETURN CSSMAPI cssm_RegReadBinary (char *regKey, char *Label,
                                        void *Bin, uint32 Len);

CSSM_BOOL CSSMAPI cssm_RegAddinIsDynamic (const CSSM_GUID_PTR GUID);
void cssm_CleanUp (void);

CSSM_RETURN CSSMAPI cssm_RegReadVersion (char *regKey, char *Label,
                                         uint32 *Major, uint32 *Minor);

CSSM_RETURN CSSMAPI cssm_GenerateCredentialPathAndSection(char* szdllPath, char* szCredentialPath, char* szSection);

#ifdef __cplusplus
}
#endif

#endif // _INTERNAL_H
