/* SCCSID: fwk/cssm/install.c, dss_cdsa_fwk, fwk_rel2, dss_971010 1.2 10/10/97 10:41:12 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*-----------------------------------------------------------------------
 *      File:   INSTALL.C
 *
 */
/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */
/*
 * WARNING: EXPORT RESTRICTED.
 * This software listing contains cryptographic methods and technology.
 * It is export restricted by the Office of Defense Trade Controls, United
 * States Department of State and cannot be downloaded or otherwise
 * exported or re-exported (i) into (or to a national or resident of) Cuba,
 * Iraq, Libya, Yugoslavia, North Korea, Iran, Syria or any other country
 * to which the US has embargoed goods; or (ii) to anyone on the US
 * Treasury Department's list of Specially Designated Nationals or the US
 * Commerce Department's Table of Denial Orders. By downloading or using
 * this product, you are agreeing to the foregoing and you are representing
 * and warranting that you are not located in, under the control of, or a
 * national or resident of any such country or on any such list.
 */

#include "cssm.h"
#include "cssmport.h"
#include "internal.h"
extern HANDLE hCssmRegistryMutex;

/*---------------------------------------------------------------
 *
 *Name: CSSM_GetHandleInfo
 *
 *Description:
 *   Returns a CSSM_HANDLEINFO structure describing the
 *   attributes of the passed handle
 *
 *Parameters:
 *   hModule (input) - Handle of the module to get information
 *                       about.
 *
 *Returns:
 *   Information structure if successful; NULL if an error.
 *
 *-------------------------------------------------------------*/
CSSM_HANDLEINFO_PTR CSSMAPI CSSM_GetHandleInfo(CSSM_HANDLE hModule)
{
	CSSM_HANDLEINFO_PTR	rc;
    /* clear the error */

    CSSM_ClearError ();

    rc = cssm_GetHandleInfo(hModule);
	return(rc);
}

/*---------------------------------------------------------------
 *
 *Name: CSSM_ModuleInstall
 *
 *Description:
 *   Updates the registry with information on the addin module
 *
 *Parameters:
 *   ModuleName (input) - Name of addin module
 *   ModuleFileName (input) - Name of file implementing addin module
 *   ModulePathName (input) - Path to file implementing addin module
 *   GUID (input) - GUID of addin module
 *   ModuleDescription (input) - pointet to structure that describes addin
 *   Reserved1 (input) - TBD
 *   Reserved2 (input) - TBD
 *
 *Returns:
 *   CSSM_OK - Update registry with module information
 *   CSSM_FAIL - unable to update registry
 *
 *-------------------------------------------------------------*/
CSSM_RETURN CSSMAPI CSSM_ModuleInstall (
                                 const char *ModuleName,
                                 const char *ModuleFileNames,
                                 const char *ModulePathName,
                                 const CSSM_GUID_PTR GUID,
                                 const CSSM_MODULE_INFO_PTR ModuleDescription,
                                 const void * Reserved1,
                                 const CSSM_DATA_PTR Reserved2)
{
    CSSM_MUTEX retMutex;
    CSSM_RETURN ret = CSSM_FAIL;

    /* clear the error */

    CSSM_ClearError ();

    /* Locks mutex to prevent two threads updating
       registry at the same time */
    if (hCssmRegistryMutex != NULL) {
        retMutex = cssm_LockMutex (hCssmRegistryMutex, CSSM_INFINITE_WAIT);

        if (retMutex != CSSM_MUTEX_LOCKED) {
            // cssm error is set
            return(ret);
        }
    } else {
        CSSM_SetError(&cssm_GUID,CSSM_INVALID_MUTEX_PTR);
        return(ret);
    }

    ret = cssm_ModuleInstall (ModuleName, ModuleFileNames, ModulePathName,
                              GUID, ModuleDescription, Reserved1, Reserved2);

    if (hCssmRegistryMutex != NULL)
        retMutex = cssm_UnlockMutex(hCssmRegistryMutex);
	if (retMutex != CSSM_MUTEX_UNLOCKED) {
		// cssm error is set
		ret = CSSM_FAIL;
	}

    return(ret);
}

/*---------------------------------------------------------------
 *
 *Name: CSSM_ModuleUninstall
 *
 *Description:
 *   Remove from registry the information associated with GUID
 *
 *Parameters:
 *   GUID (input) - GUID of addin module
 *
 *Returns:
 *   CSSM_OK - Update registry with module information
 *   CSSM_FAIL - unable to update registry
 *
 *-------------------------------------------------------------*/
CSSM_RETURN CSSMAPI CSSM_ModuleUninstall (const CSSM_GUID_PTR GUID)
{
    CSSM_RETURN ret = CSSM_FAIL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    /* Locks mutex to prevent two threads updating
       registry at the same time */
    if(hCssmRegistryMutex != NULL) {
        retMutex = cssm_LockMutex (hCssmRegistryMutex, CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            // cssm error is set
            return(ret);
        }
    } else {
        CSSM_SetError(&cssm_GUID,CSSM_INVALID_MUTEX_PTR);
        return(ret);
    }

    ret = cssm_ModuleUninstall (GUID);

    if(hCssmRegistryMutex != NULL)
        retMutex = cssm_UnlockMutex(hCssmRegistryMutex);
	if (retMutex != CSSM_MUTEX_UNLOCKED) {
		// cssm error is set
		ret = CSSM_FAIL;
	}

    return(ret);

}
