/* SCCSID: fwk/cssm/context.h, dss_cdsa_fwk, fwk_rel2, dss_971210 1.3 12/10/97 17:21:09 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*-----------------------------------------------------------------------
 *      File:   CONTEXT.H
 *
 * Copyright (c) 1995, 1996 Intel Corporation. All rights reserved.
 *-----------------------------------------------------------------------
*/
/* 
    * WARNING: EXPORT RESTRICTED. 
    * This software listing contains cryptographic methods and technology. 
    * It is export restricted by the Office of Defense Trade Controls, United 
    * States Department of State and cannot be downloaded or otherwise 
    * exported or re-exported (i) into (or to a national or resident of) Cuba, 
    * Iraq, Libya, Yugoslavia, North Korea, Iran, Syria or any other country 
    * to which the US has embargoed goods; or (ii) to anyone on the US 
    * Treasury Department's list of Specially Designated Nationals or the US 
    * Commerce Department's Table of Denial Orders. By downloading or using 
    * this product, you are agreeing to the foregoing and you are representing 
    * and warranting that you are not located in, under the control of, or a 
    * national or resident of any such country or on any such list. 
    */ 
#ifndef CONTEXT_H
#define CONTEXT_H

#ifdef __cplusplus
extern "C"
{
#endif

#include "internal.h"

typedef struct cssm_InternalContext {
    CSSM_CONTEXT_PTR Context;
    CSSM_CSP_HANDLE CSPHandle;
    CSSM_CC_HANDLE ContextHandle;
} cssm_INTERNALCONTEXT, *cssm_INTERNALCONTEXT_PTR;

/* Context table entry */
typedef struct _CtxHashEntry {
	struct _CtxHashEntry  *next;
	cssm_INTERNALCONTEXT_PTR  cssmCtxPtr;
} CtxHashEntry, *CtxHashEntryPtr;

/* The table itself has locks for each list (hash bucket). This is a
 * manageable level of locking which in practice should mean essentially
 * little lock contention. A single lock for the whole table,is adequate 
 * but seems unduly restrictive.
 */
typedef struct _CtxHashTable {
	HANDLE			lock;	// one lock per hash bucket 
	CtxHashEntryPtr	head;
} CtxHashTable, *CtxHashTablePtr;

CSSM_RETURN cssm_InitContextTable(void);
CSSM_RETURN cssm_CleanContextTable(void);
cssm_INTERNALCONTEXT_PTR cssm_LookupCONTEXT(CSSM_CC_HANDLE ccHandle);
CSSM_RETURN cssm_InstallCONTEXT(cssm_INTERNALCONTEXT_PTR pContext);
CSSM_RETURN cssm_RemoveCONTEXT(CSSM_CC_HANDLE ccHandle);
cssm_INTERNALCONTEXT_PTR cssm_LookupAndLockBucket(CSSM_CC_HANDLE ccHandle, int *index);
CSSM_RETURN cssm_UnlockBucket(int index);
CSSM_RETURN cssm_UpdateContextPtr(CSSM_CC_HANDLE	ccHandle, 
								  CSSM_CONTEXT_PTR newContext);


CSSM_CONTEXT_PTR cssm_CreateContext (CSSM_CONTEXT_TYPE Class, 
                                     uint32 AlgorithmID);
CSSM_CC_HANDLE CSSMAPI cssm_InsertContext (CSSM_CONTEXT_PTR Context, 
                                           CSSM_CSP_HANDLE CSPHandle);
CSSM_CONTEXT_PTR cssm_DuplicateContext (CSSM_CONTEXT_PTR Context, 
                                       CSSM_CALLOC local_calloc, 
                                       CSSM_FREE local_free, void *mem_ref);
void CSSMAPI cssm_FreeIntContext (cssm_INTERNALCONTEXT_PTR IntContext,
								  CSSM_EVENT_TYPE event,
								  CSSM_BOOL	flag);
void CSSMAPI cssm_FreeAttributes (uint32 NumberOfAttributes, 
                                 CSSM_CONTEXT_ATTRIBUTE_PTR Attributes,
                                 CSSM_FREE local_free, void *mem_ref,
                                 uint32 Free);
CSSM_RETURN CSSMAPI cssm_CreateAttribute (CSSM_CONTEXT_ATTRIBUTE_PTR *Attributes,
                                          uint32 NumberAttributes);
CSSM_RETURN CSSMAPI cssm_AddAttribute (CSSM_CONTEXT_ATTRIBUTE_PTR Attributes,
                                       CSSM_ATTRIBUTE_TYPE type,
                                       void *Data);
CSSM_BOOL cssm_IsBadCryptoKeyPtr (CSSM_KEY_PTR Key);
CSSM_BOOL cssm_IsBadCryptoDataPtr (CSSM_CRYPTO_DATA_PTR Data);
CSSM_RETURN cssm_UpdateContext (CSSM_CONTEXT_PTR Context, 
                                CSSM_CONTEXT_ATTRIBUTE_PTR Attribute);
CSSM_RETURN cssm_DelContextAttr (CSSM_CONTEXT_PTR Context, 
                                 CSSM_CONTEXT_ATTRIBUTE_PTR Attribute);
CSSM_CSP_HANDLE cssm_FindCSPHandle (CSSM_CC_HANDLE CCHandle);
void CSSMAPI cssm_FreeContext (CSSM_CONTEXT_PTR Context);

#ifdef __cplusplus
}
#endif

#endif
