/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef PKIXVALIDATOR_H_
#define PKIXVALIDATOR_H_

//------------------------------------------------------------
// includes
//------------------------------------------------------------

#include <time.h>
#include "cssmport.h"
#include "cssm.h"
#include "cssmspi.h"
#include "cssmtpi.h"
#include "cssmcspi.h"
#include "tpexception.h"
#include "jonahtpmsg.h"
#include "pkixcertcrl.h"
#include "pkixnameconstraints.h"
#include "pkixpolicyconstraints.h"
#include "pkixevidence.h"

      
//------------------------------------------------------------
// class: pkix_validator
//------------------------------------------------------------

class pkix_validator {

public:

   //------------------------------------------------------------
   // constructor 
   //
   // Inputs:
   // 
   // (a)  a certification path of length n;
   //
   // (b)  a set of initial policy identifiers (each comprising a
   //      sequence of policy element identifiers), which identifies one or
   //      more certificate policies, any one of which would be acceptable
   //      for the purposes of certification path processing, or the special
   //      value "any-policy";
   //
   // (c)  the current date/time; and
   //
   // (d)  the time, T, for which the validity of the path should be
   //      determined.
   //
   // Note:
   //
   //      We need a CSSM CSP handle to perform signature 
   //      verifications.  Later, when we support CRLs, we will 
   //      also need CSSM_DL_DB_LIST_PTR (a list of data sources) 
   //      to perform CRL retrieval.  We do not use a CDSA certificate 
   //      library (CL).
   //
   //------------------------------------------------------------

   pkix_validator(time_t                currentTime,
                  time_t                validationTime,
                  pkix_certificate*     certificationPath,
                  int                   certificationPathLength,
                  const PolicyState&    initialPolicySet,
                  CSSM_CSP_HANDLE       cspHandle,
                  CSSM_DL_DB_LIST_PTR   DBList = NULL);

   // destructor

   ~pkix_validator();

   // perform PKIX certification path validation on inputs

   void validateCertificationPath();

   // retrieve evidenced gathered during validation

   PKIXEvidence getEvidence();

private:

   //------------------------------------------------------------
   // private interfaces
   //------------------------------------------------------------

   // certificate validation routines

   void validateLinkInChain            (pkix_certificate& subject, pkix_certificate& issuer);
   void validateCertificateSignature   (pkix_certificate& subject, pkix_certificate& issuer);
   void validateValidity               (pkix_certificate& subject);
   void validateVersionUsage           (pkix_certificate& subject);
   void validateCertificateExtensions  (pkix_certificate& subject, pkix_certificate& issuer);

   // name constraints

   void validateNameChaining           (pkix_certificate& subject, pkix_certificate& issuer);
   void validateNameConstraints        (pkix_certificate& subject);
   void validateNoMinMaxInSubtrees     (GeneralSubtrees& trees);
   void validateOnlySupportedNameForms (GeneralNames& altNames);
   void validateOnlySupportedNameForms (GeneralSubtrees& trees);
   void validateOnlySupportedNameForms (GeneralName& name);
   void enforceNameConstraintsState    (pkix_certificate& subject);
   void updateNameConstraintsState     (pkix_certificate& subject);

   // policy constraints

   void validateCertificatePolicies    (pkix_certificate& subject);
   void enforcePolicyConstraintsState  (pkix_certificate& subject);
   void updatePolicyConstraintsState   (pkix_certificate& subject);
   void validatePolicyConstraints      (PolicyConstraint& policyConstraints);

   // other extension checking

   void validateAuthorityKeyIdentifier (pkix_certificate& subject, pkix_certificate& issuer);
   void validateSubjectKeyIdentifier   (pkix_certificate& subject);
   void validateBasicConstraints       (pkix_certificate& subject);
   void validateKeyUsage               (pkix_certificate& subject);

   // CRL validation routines

   void validateCertificateNotOnCRL    (pkix_certificate& subject, pkix_certificate& issuer);
   void getBestCRL                     (pkix_certificate& issuer, pkix_crl& crl, bool& found);
   void validateCRL                    (pkix_crl& crl, pkix_certificate& issuer);
   void validateCRLExtensions          (pkix_crl& crl, pkix_certificate& issuer);
   void validateCRLSignature           (pkix_crl& crl, pkix_certificate& issuer);

   // CRL extension checking

   void validateAuthorityKeyIdentifier (pkix_crl& crl, pkix_certificate& issuer);

   // common certificate and CRL validation routines

   void validateAuthorityKeyIdentifier (XAuthorityKeyIdentifier& authorityKeyIdentifier, bool isCritical, pkix_certificate& issuer);
   void validateIssuerAltName          (XIssuerAltName& issuerAltName, bool isCritical, pkix_certificate& issuer);
   void validateInnerOuterAlgorithmsAgree
                                       (AlgorithmIdentifier& inner, AlgorithmIdentifier& outer);

   // helpers

   int  pathLength     ()        const;
   int  chainPosition  ()        const;
   void chainPosition  (int i)        ;

   // utilities

   void convertDNToGeneralName(asn_x500name& name, GeneralName& gname);

   //------------------------------------------------------------
   // member data
   //------------------------------------------------------------

   time_t              _currentTime;
   time_t              _validationTime;
   pkix_certificate*   _path;
   int                 _pathLength;
   PKIXEvidence        _evidence;
   int                 _currentChainPosition;

   // member data: CSSM

   CSSM_CSP_HANDLE     _cspHandle;
   CSSM_DL_DB_LIST_PTR _DBList;

   // member data: state information

   PermittedState      _permittedNameSet;
   ExcludedState       _excludedNameSet;
   PolicyState         _userPolicySet;
   PolicyState         _authPolicySet;
   int                 _explicitPolicy;
   int                 _policyMappingInhibit;

};

#endif   // PKIXVALIDATOR_H_
