/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*
 *  Notes:
 *    Abstract the concept of a certificate policy set, which can 
 *    represent "any-policy", or zero or more policies.  Conceptually,
 *    "any-policy" means all possible policies (including no policy).
 */

#include "functiontrace.h"
#include "pkixpolicyconstraints.h"
#include "tpexception.h"

void display();

// constructor

PolicyState::PolicyState()
:  _numOfPolicies(-1),
   _oids(0)
{
   // Every policy set is initially the universl set (ANY-POLICY)
}

PolicyState::PolicyState(const PolicyState& toBeCopied)
:  _numOfPolicies(toBeCopied._numOfPolicies),
   _oids(0)
{
   commonCopy(toBeCopied);
}

PolicyState& PolicyState::operator=(const PolicyState& toBeCopied)
{
   if (this != &toBeCopied)
   {
      delete [] _oids;
      _oids = 0;
      _numOfPolicies = toBeCopied._numOfPolicies;
      commonCopy(toBeCopied);
   }
   return *this;
}

void 
PolicyState::commonCopy(const PolicyState& toBeCopied)
{
   if (toBeCopied._oids)
   {
      _oids = new asn_oid[_numOfPolicies];
      for (int i = 0; i < _numOfPolicies; i++)
      {
         buffer_t copyBuffer;
         toBeCopied._oids[i].write(copyBuffer);
         _oids[i].read(copyBuffer);
      }
   }
}

PolicyState::PolicyState(const XCertificatePolicies& certificatePolicies)
:  _numOfPolicies(-1),
   _oids(0)
{
   int status;

   try
   {
      _numOfPolicies = certificatePolicies.get_child_count();
      _oids = new asn_oid[_numOfPolicies];

      for (int i = 0; i < _numOfPolicies; i++)
      {
         buffer_t copyBuffer;
         if ((status = certificatePolicies[i]->policyIdentifier.write(copyBuffer)) != 0)
            throw TPASNException(status);
         if ((status = _oids[i].read(copyBuffer)) != 0)
            throw TPASNException(status);
      }

   }
   catch (TPASNException&)
   {
      delete _oids;
      throw;
   }
}


//------------------------------------------------------------
// intersect routines: current set has OID intersection with 
// XCertificatePolicies extension or other policy set?
//------------------------------------------------------------

bool          
PolicyState::intersects(const PolicyState& policySet) const
{
   // universal set intersects with any policy

   if ( isAnyPolicy() || policySet.isAnyPolicy() )
      return true;

   // finite sets to deal with

   for (int i = 0; i < _numOfPolicies; i++)
      for (int j = 0; j < policySet._numOfPolicies; j++)
         if ( _oids[i] == policySet._oids[j] )
            return true;
   return false;
}

bool          
PolicyState::intersects(const XCertificatePolicies& certificatePolicies) const
{
   // universal set intersects with any policies

   if ( isAnyPolicy() )
      return true;

   // finite sets to deal with

   for (int i = 0; i < _numOfPolicies; i++)
      for (int j = 0; j < certificatePolicies.get_child_count(); j++)
         if (_oids[i] == certificatePolicies[j]->policyIdentifier)
            return true;
   return false;
}

//------------------------------------------------------------
// intersection routines: what is intersection of current set 
// and XCertificatePolicies extension or other policy set?
//------------------------------------------------------------

PolicyState 
PolicyState::intersection(const PolicyState& policySet) const
{
   if ( isAnyPolicy() || policySet.isAnyPolicy() )
      return PolicyState();

   for (int i = 0; i < _numOfPolicies; i++)
   {
      for (int j = 0; j < policySet._numOfPolicies; j++)
         if ( _oids[i] == policySet._oids[j] )
            ; // finish me
   }
   return PolicyState();
}

PolicyState 
PolicyState::intersection(const XCertificatePolicies& x) const
{
   // TO DO:
   return PolicyState();
}

PolicyState::~PolicyState()
{
   delete [] _oids; 
}

bool
PolicyState::isAnyPolicy() const
{
   // -1 is sential value that indicates ANY-POLICY
   return _numOfPolicies == -1 ? true : false;
}
#include <stdio.h>

void 
PolicyState::display()
{
   int status = 0;

   for (int i = 0; i < _numOfPolicies; i++)
   {
      buffer_t displayMe;
      if ((status = _oids[i].display(displayMe)) != 0)
         throw "eat me";
      printf("%s\n", displayMe.data);
   }
}
