/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

//------------------------------------------------------------
// includes
//------------------------------------------------------------

#include "functiontrace.h"
#include "pkixcertcrl.h"


//------------------------------------------------------------
// Misc:
//------------------------------------------------------------

bool 
pkix_crl::isExtensionsPresent()
{ 
   if (!_init) init();
   return _isExtensionsPresent;
}


//------------------------------------------------------------
// Extension: AuthorityKeyIdentifier
//------------------------------------------------------------

bool 
pkix_crl::isAuthorityKeyIdentifierPresent() 
{ 
   if (!_init) init();
   return _isAuthorityKeyIdentifierPresent;
}

bool 
pkix_crl::isAuthorityKeyIdentifierCritical() 
{ 
   if (!_init) init();
   return _isAuthorityKeyIdentifierCritical;
}

XAuthorityKeyIdentifier& 
pkix_crl::authorityKeyIdentifier()     
{
   if (!_init) init(); 
   return _XAuthorityKeyIdentifier;
}


//------------------------------------------------------------
// Extension: IssuerAlternativeName
//------------------------------------------------------------

bool 
pkix_crl::isIssuerAlternativeNamePresent() 
{ 
   if (!_init) init();
   return _isIssuerAlternativeNamePresent;
}

bool 
pkix_crl::isIssuerAlternativeNameCritical() 
{ 
   if (!_init) init();
   return _isIssuerAlternativeNameCritical;
}

XIssuerAltName& 
pkix_crl::issuerAltName()     
{
   if (!_init) init(); 
   return _XIssuerAltName;
}


//------------------------------------------------------------
// Extension: CRLNumber
//------------------------------------------------------------

bool 
pkix_crl::isCRLNumberPresent() 
{ 
   if (!_init) init();
   return _isCRLNumberPresent;
}

bool 
pkix_crl::isCRLNumberCritical() 
{ 
   if (!_init) init();
   return _isCRLNumberCritical;
}

XCRLNumber& 
pkix_crl::crlNumber()     
{
   if (!_init) init(); 
   return _XCRLNumber;
}


//------------------------------------------------------------
// Extension: DeltaCRLIndicator
//------------------------------------------------------------

bool 
pkix_crl::isDeltaCRLIndicatorPresent() 
{ 
   if (!_init) init();
   return _isDeltaCRLIndicatorPresent;
}

bool 
pkix_crl::isDeltaCRLIndicatorCritical() 
{ 
   if (!_init) init();
   return _isDeltaCRLIndicatorCritical;
}

XDeltaCRLIndicator& 
pkix_crl::deltaCRLIndicator()     
{
   if (!_init) init(); 
   return _XDeltaCRLIndicator;
}


//------------------------------------------------------------
// method: init
//------------------------------------------------------------

int 
pkix_crl::init()
{
   TPTRACE(jonahtp_trace_info, "void pkix_crl::init()");

   int status = 0;

   _init = true;

   // Extensions checking

   if (tbsCertList.crlExtensions.is_present())
   {
      _isExtensionsPresent = true;
   }

   if (!_isExtensionsPresent)
   {
      return status;
   }

   // Known X.509/PKIX CRL extensions

   unsigned long AuthorityKeyIdentifier_val[4]     = {2,5,29,35};
   unsigned long IssuerAlternativeName_val[4]      = {2,5,29,18};
   unsigned long CRLNumber_val[4]                  = {2,5,29,20};
   unsigned long DeltaCRLIndicator_val[4]          = {2,5,29,27};

   // variables to hold encoding extracted from x509_extension

   unsigned char* p;
   uint32         bc;
   r_buffer_t     encoding;

   int children = tbsCertList.crlExtensions.value.get_child_count();
   for (int i = 0; i < children ; i++)
   {
      x509_Extension* child = tbsCertList.crlExtensions.value[i];

      //------------------------------------------------------------
      // AuthorityKeyIdentifier
      //------------------------------------------------------------
      if (child->extnID.is_equal(AuthorityKeyIdentifier_val, 4))
      {
         _isAuthorityKeyIdentifierPresent = true;
         child->critical.get_value(_isAuthorityKeyIdentifierCritical);
         if ((status = child->extnValue.get_value(p, bc)) != 0)
            return status;
         encoding.data = p; encoding.data_len = bc;
         if ((status = _XAuthorityKeyIdentifier.read(encoding)) != 0)
            return status;
      }
      //------------------------------------------------------------
      // IssuerAlternativeName
      //------------------------------------------------------------
      else if (child->extnID.is_equal(IssuerAlternativeName_val, 4))
      {
         _isIssuerAlternativeNamePresent = true;
         child->critical.get_value(_isIssuerAlternativeNameCritical);
         if ((status = child->extnValue.get_value(p, bc)) != 0)
            return status;
         encoding.data = p; encoding.data_len = bc;
         if ((status = _XIssuerAltName.read(encoding)) != 0)
            return status;
      }  
      //------------------------------------------------------------
      // CRLNumber
      //------------------------------------------------------------
      else if (child->extnID.is_equal(CRLNumber_val, 4))
      {
         _isCRLNumberPresent = true;
         child->critical.get_value(_isCRLNumberCritical);
         if ((status = child->extnValue.get_value(p, bc)) != 0)
            return status;
         encoding.data = p; encoding.data_len = bc;
         if ((status = _XCRLNumber.read(encoding)) != 0)
            return status;
      }  
      //------------------------------------------------------------
      // DeltaCRLIndicator
      //------------------------------------------------------------
      else if (child->extnID.is_equal(DeltaCRLIndicator_val, 4))
      {
         _isDeltaCRLIndicatorPresent = true;
         child->critical.get_value(_isDeltaCRLIndicatorCritical);
         if ((status = child->extnValue.get_value(p, bc)) != 0)
            return status;
         encoding.data = p; encoding.data_len = bc;
         if ((status = _XDeltaCRLIndicator.read(encoding)) != 0)
            return status;
      }  
   }
   return status;
}
