/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef PKIXCERTCRL_H_
#define PKIXCERTCRL_H_

//------------------------------------------------------------
// includes
//------------------------------------------------------------

#include "x509.h"


//------------------------------------------------------------
// class: pkix_certificate
//------------------------------------------------------------

class pkix_certificate : public x509_certificate {

public:

   // constructor

   pkix_certificate() 
      : _subjectIsNull(false),
        _isIssuerNull(false),
        _isIssuerUniqueIDPresent(false),
        _isSubjectUniqueIDPresent(false),
        _isExtensionsPresent(false),
        _isEmailAddressPresent(false),
        _isAuthorityKeyIdentifierPresent(false),
        _isAuthorityKeyIdentifierCritical(false),
        _isSubjectKeyIdentifierPresent(false),
        _isSubjectKeyIdentifierCritical(false),
        _isKeyUsagePresent(false),
        _isKeyUsageCritical(false),
        _isPrivateKeyUsagePeriodPresent(false),
        _isPrivateKeyUsagePeriodCritical(false),
        _isCertificatePoliciesPresent(false),
        _isCertificatePoliciesCritical(false),
        _isPolicyMappingsPresent(false),
        _isPolicyMappingsCritical(false),
        _isSubjectAlternativeNamePresent(false),
        _isSubjectAlternativeNameCritical(false),
        _isIssuerAlternativeNamePresent(false),
        _isIssuerAlternativeNameCritical(false),
        _isBasicConstraintsPresent(false),
        _isBasicConstraintsCritical(false),
        _isNameConstraintsPresent(false),
        _isNameConstraintsCritical(false),
        _isPolicyConstraintsPresent(false),
        _isPolicyConstraintsCritical(false),
        _isCRLDistributionPointsPresent(false),
        _isCRLDistributionPointsCritical(false),
        _init(false),
        x509_certificate()
   {}

   // destructor

   ~pkix_certificate() {}

   // utiliy acccessors for PKIX tbsCertficate fields

   bool  isSubjectNull();
   bool  isIssuerNull();
   bool  isIssuerUniqueIDPresent();
   bool  isSubjectUniqueIDPresent();
   bool  isExtensionsPresent();

   // utility accessors for legacy PKCS-9 EmailAttribute check

   bool  containsEmailAddress();

   // utility accessors for PKIX extensions

   bool  isAuthorityKeyIdentifierPresent();
   bool  isAuthorityKeyIdentifierCritical();

   bool  isSubjectKeyIdentifierPresent();
   bool  isSubjectKeyIdentifierCritical();

   bool  isKeyUsagePresent();
   bool  isKeyUsageCritical();

   bool  isPrivateKeyUsagePeriodPresent();
   bool  isPrivateKeyUsagePeriodCritical();

   bool  isCertificatePoliciesPresent(); 
   bool  isCertificatePoliciesCritical(); 

   bool  isPolicyMappingsPresent();
   bool  isPolicyMappingsCritical();

   bool  isSubjectAlternativeNamePresent();
   bool  isSubjectAlternativeNameCritical();

   bool  isIssuerAlternativeNamePresent();
   bool  isIssuerAlternativeNameCritical();

   bool  isSubjectDirectoryAttributesPresent();
   bool  isSubjectDirectoryAttributesCritical();

   bool  isBasicConstraintsPresent();
   bool  isBasicConstraintsCritical();

   bool  isNameConstraintsPresent();
   bool  isNameConstraintsCritical();

   bool  isPolicyConstraintsPresent();
   bool  isPolicyConstraintsCritical();

   bool  isExtendedKeyUsagePresent();
   bool  isExtendedKeyUsageCritical();

   bool  isCRLDistributionPointsPresent();
   bool  isCRLDistributionPointsCritical();

   bool  isAuthorityInfoAccessPresent();
   bool  isAuthorityInfoAccessCritical();

   // email accessor: use containsEmailAdress first!

   GeneralName& emailAddress();

   // extension accessors; you must check extension exists first!

   XAuthorityKeyIdentifier& authorityKeyIdentifier();
   XSubjectKeyIdentifier&   subjectKeyIdentifier();
   XKeyUsage&               keyUsage();
   XPrivateKeyUsagePeriod&  privateKeyUsagePeriod();
   XCertificatePolicies&    certificatePolicies();
   XPolicyMappings&         policyMappings();
   XsubjectAltName&         subjectAltName();
   XIssuerAltName&          issuerAltName();
   XBasicConstraints&       basicConstraints();
   XNameConstraints&        nameConstraints();
   PolicyConstraint&        policyConstraints();
   CRLDistributionPoints&   cRLDistributionPoints();

private:

   // initialization routines

   int init();
   int populate_emailAddress();

   // member data

   bool _subjectIsNull;
   bool _isIssuerNull;
   bool _isIssuerUniqueIDPresent;
   bool _isSubjectUniqueIDPresent;
   bool _isExtensionsPresent;
   bool _isEmailAddressPresent;
   bool _isAuthorityKeyIdentifierPresent;
   bool _isAuthorityKeyIdentifierCritical;
   bool _isSubjectKeyIdentifierPresent;
   bool _isSubjectKeyIdentifierCritical;
   bool _isKeyUsagePresent;
   bool _isKeyUsageCritical;
   bool _isPrivateKeyUsagePeriodPresent;
   bool _isPrivateKeyUsagePeriodCritical;
   bool _isCertificatePoliciesPresent;
   bool _isCertificatePoliciesCritical;
   bool _isPolicyMappingsPresent;
   bool _isPolicyMappingsCritical;
   bool _isSubjectAlternativeNamePresent;
   bool _isSubjectAlternativeNameCritical;
   bool _isIssuerAlternativeNamePresent;
   bool _isIssuerAlternativeNameCritical;
   bool _isBasicConstraintsPresent;
   bool _isBasicConstraintsCritical;
   bool _isNameConstraintsPresent;
   bool _isNameConstraintsCritical;
   bool _isPolicyConstraintsPresent;
   bool _isPolicyConstraintsCritical;
   bool _isCRLDistributionPointsPresent;
   bool _isCRLDistributionPointsCritical;

   bool _init;

   XAuthorityKeyIdentifier    _XAuthorityKeyIdentifier;
   XSubjectKeyIdentifier      _XSubjectKeyIdentifier;
   XKeyUsage                  _XKeyUsage;
   XPrivateKeyUsagePeriod     _XPrivateKeyUsagePeriod;
   XCertificatePolicies       _XCertificatePolicies;
   XPolicyMappings            _XPolicyMappings;
   XsubjectAltName            _XsubjectAltName;
   XIssuerAltName             _XIssuerAltName;
   XBasicConstraints          _XBasicConstraints;
   XNameConstraints           _XNameConstraints;
   PolicyConstraint           _PolicyConstraint;
   CRLDistributionPoints      _CRLDistributionPoints;
   GeneralName                _emailAddress;

};


//------------------------------------------------------------
// class: pkix_crl
//------------------------------------------------------------

class pkix_crl : public CertificateList {

public:

   pkix_crl() 
      : _isExtensionsPresent(false),
        _isAuthorityKeyIdentifierPresent(false),
        _isAuthorityKeyIdentifierCritical(false),
        _isIssuerAlternativeNamePresent(false),
        _isIssuerAlternativeNameCritical(false),
        _isCRLNumberPresent(false),
        _isCRLNumberCritical(false),
        _isDeltaCRLIndicatorPresent(false),
        _isDeltaCRLIndicatorCritical(false),
        _init(false),
        CertificateList()
   {}

   ~pkix_crl() {}

   bool  isExtensionsPresent();

   bool  isAuthorityKeyIdentifierPresent();
   bool  isAuthorityKeyIdentifierCritical();

   bool  isIssuerAlternativeNamePresent();
   bool  isIssuerAlternativeNameCritical();

   bool  isCRLNumberPresent();
   bool  isCRLNumberCritical();

   bool  isDeltaCRLIndicatorPresent();
   bool  isDeltaCRLIndicatorCritical();

   XAuthorityKeyIdentifier& authorityKeyIdentifier();
   XIssuerAltName&          issuerAltName();
   XCRLNumber&              crlNumber();
   XDeltaCRLIndicator&      deltaCRLIndicator();

private:

   int init();

   bool _isExtensionsPresent;

   bool _isAuthorityKeyIdentifierPresent;
   bool _isAuthorityKeyIdentifierCritical;

   bool _isIssuerAlternativeNamePresent;
   bool _isIssuerAlternativeNameCritical;

   bool _isCRLNumberPresent;
   bool _isCRLNumberCritical;

   bool _isDeltaCRLIndicatorPresent;
   bool _isDeltaCRLIndicatorCritical;

   bool _init;

   XAuthorityKeyIdentifier  _XAuthorityKeyIdentifier;
   XIssuerAltName           _XIssuerAltName;
   XCRLNumber               _XCRLNumber;
   XDeltaCRLIndicator       _XDeltaCRLIndicator;

};


#endif   // PKIXCERTCRL_H_





