/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

//------------------------------------------------------------
// includes
//------------------------------------------------------------

#include "tpexception.h"
#include "oidchecker.h"


// class: oid_node

class oid_node {
public:
   oid_node* left;
   oid_node* right;
   asn_oid value;
   buffer_t display;
   oid_node(asn_oid& toCopy);
   int compare(asn_oid& toCompare);
   static oid_node* addtree(oid_node* p, asn_oid& value);
   static void deletetree(oid_node* root);
};


//------------------------------------------------------------
// constructor
//------------------------------------------------------------

oid_node::oid_node(asn_oid& toCopy)
{
   int status = 0;

   left  = NULL;
   right = NULL;

   buffer_t copyBuffer;

   // copy encoding

   if ((status = toCopy.write(copyBuffer)) != 0)
      throw TPASNException(status);
   if ((status = value.read(copyBuffer)) != 0)
      throw TPASNException(status);

   // copy display 

   if ((status = value.display(display)) != 0)
      throw TPASNException(status);
}


//------------------------------------------------------------
// method: compare
//------------------------------------------------------------

int 
oid_node::compare(asn_oid& toCompare)
{
   int status = 0;

   if (toCompare == value)
      return 0;

   buffer_t toCompareDisplay;
   if ((status = toCompare.display(toCompareDisplay)) != 0)
      throw TPASNException(status);

   if (display.data_len == toCompareDisplay.data_len)
   {
      return memcmp(display.data, toCompareDisplay.data, display.data_len);
   }
   else if (display.data_len > toCompareDisplay.data_len)
   {
      int cond = memcmp(display.data, toCompareDisplay.data, toCompareDisplay.data_len);
      return cond == 0 ? 1 : cond;
   }
   else
   {
      int cond = memcmp(display.data, toCompareDisplay.data, display.data_len);
      return cond == 0 ? -1 : cond;
   }
}


//------------------------------------------------------------
// method: addtree
//------------------------------------------------------------

oid_node* 
oid_node::addtree(oid_node* p, asn_oid& value)
{
   int condition;

   if (p == NULL) 
   {
      p = new oid_node(value);
   } 
   else if (( condition = p->compare(value)) == 0) 
   {
      throw "duplicate extension";
   } 
   else if (condition < 0) 
   {
      p->left = addtree(p->left, value);
   } 
   else 
   {
      p->right = addtree(p->right, value);
   }
   return p;
}


//------------------------------------------------------------
// method: deletetree
//------------------------------------------------------------

void
oid_node::deletetree(oid_node* root)
{
   if (root->left)
   {
      deletetree(root->left);
      delete root->left;
   }
   if (root->right)
   {
      deletetree(root->right);
      delete root->right;
   }
}


// class: OIDChecker

//------------------------------------------------------------
// constructor
//------------------------------------------------------------

OIDChecker::OIDChecker()
: root(NULL)
{
}


//------------------------------------------------------------
// destructor
//------------------------------------------------------------

OIDChecker::~OIDChecker()
{
   if (root)
   {
      oid_node::deletetree(root);
      delete root;
   }
}


//------------------------------------------------------------
// method: insert
//------------------------------------------------------------

int
OIDChecker::insert(asn_oid& toBeInserted)
{
   try
   {
      root = oid_node::addtree(root, toBeInserted);
   }
   catch (char*)
   {
      return 0;
   }
   return 1;
}
