/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*************************************************************************************
 *
 * COMPONENT_NAME: CSP - IBMCYLINKCSP (Software Service Provider)
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All rights reserved
 * Licensed materials - Property of IBM
 *
 */

/*
 * FILE: info.c
 *
 * This file contains routines necessary for module registration.
 *
 ***********************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ibmcylinkcsp.hpp>
#include <ibmcylinkcsp_reginfo.hpp>
#include <install_addin.h>
#include <toolkit.h>
//#include "saferkey.hpp"

CSSM_GUID						TempGUID = IBMCYLINKCSP_GUID;
CSSM_MODULE_INFO				CssmModuleInfo;
CSSM_SERVICE_INFO				CssmServiceInfo;
CSSM_CSPSUBSERVICE				CspSubServiceList[IBMCYLINKCSP_NUMBER_OF_SUBSERVICES];
CSSM_CSP_WRAPPEDPRODUCT_INFO*	pCssmWrappedProduct;

// Key length range
CSSM_RANGE	CssmDSARange	= {DH_LENGTH_MIN * 8, DSS_LENGTH_MAX * 8};
CSSM_RANGE	CssmDESRange	= {DES_EFFECTIVE_KEY_LENGTH * 8, DES_EFFECTIVE_KEY_LENGTH * 8};
CSSM_RANGE	Cssm2DESRange	= {2 * DES_EFFECTIVE_KEY_LENGTH * 8, 2 * DES_EFFECTIVE_KEY_LENGTH * 8};
CSSM_RANGE	Cssm3DESRange	= {3 * DES_EFFECTIVE_KEY_LENGTH * 8, 3 * DES_EFFECTIVE_KEY_LENGTH * 8};
CSSM_RANGE	CssmSAFERRange	= {8 * 8, 16 * 8};
CSSM_RANGE	CssmDHRange		= {DH_LENGTH * 8, DH_LENGTH * 8};
//CSSM_RANGE	CssmDHRange		= {DH_LENGTH_MIN * 8, 1024 * 8};


// KeyGen attribute lists
CSSM_CONTEXT_ATTRIBUTE			CssmKeyGenDSAAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmDSARange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmKeyGenDESAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmDESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmKeyGen2DESAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&Cssm2DESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmKeyGen3DESAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&Cssm3DESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmKeyGenSAFERAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmSAFERRange}
};

// Signature attribute lists
CSSM_CONTEXT_ATTRIBUTE			CssmSignatureDSAAttrList[1] = 
{
	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmDSARange}
};

// Symmetric attribute lists
CSSM_CONTEXT_ATTRIBUTE			CssmSymmetricDESAttrList[17] = 
{
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBCPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC64},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFBPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB64},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB8},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFBPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB64},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECBPad},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECB64},

	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmDESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmSymmetric2DESAttrList[5] = 
{
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBCPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC64},

	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&Cssm2DESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmSymmetric3DESAttrList[5] = 
{
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBCPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC64},

	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&Cssm3DESRange}
};

CSSM_CONTEXT_ATTRIBUTE			CssmSymmetricSAFERAttrList[17] = 
{
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBCPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CBC64},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFBPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB64},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_CFB8},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFBPadIV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB_IV8},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_OFB64},

	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECBPad},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECB},
	{CSSM_ATTRIBUTE_MODE,				sizeof(uint32),		(char*)CSSM_ALGMODE_ECB64},

	{CSSM_ATTRIBUTE_KEY_LENGTH_RANGE,	sizeof(CSSM_RANGE),	(char*)&CssmSAFERRange}
};

// Context list
CSSM_CONTEXT					CssmContextList[] = 
{
	{CSSM_ALGCLASS_DIGEST, CSSM_ALGID_SHA1,				0,	0, NULL},

	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_DSA,				0,	1, CssmKeyGenDSAAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_DES,				0,	1, CssmKeyGenDESAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_3DES,				0,	1, CssmKeyGen3DESAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_3DES_3KEY,		0,	1, CssmKeyGen3DESAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_3DES_2KEY,		0,	1, CssmKeyGen2DESAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_3DES_1KEY,		0,	1, CssmKeyGenDESAttrList},
	{CSSM_ALGCLASS_KEYGEN, CSSM_ALGID_SAFER,			0,	1, CssmKeyGenSAFERAttrList},

	{CSSM_ALGCLASS_DERIVEKEY, CSSM_ALGID_DH,			0,	0, NULL},

	{CSSM_ALGCLASS_RANDOMGEN, CSSM_ALGID_SHARandom,		0,	0, NULL},

	{CSSM_ALGCLASS_SIGNATURE, CSSM_ALGID_SHA1WithDSA,	0,	1, CssmSignatureDSAAttrList},
	
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_DES,			0,	2, CssmSymmetricDESAttrList},
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_3DES,			0,	2, CssmSymmetric3DESAttrList},
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_3DES_3KEY,		0,	2, CssmSymmetric3DESAttrList},
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_3DES_2KEY,		0,	2, CssmSymmetric2DESAttrList},
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_3DES_1KEY,		0,	2, CssmSymmetricDESAttrList},
	{CSSM_ALGCLASS_SYMMETRIC, CSSM_ALGID_SAFER,			0,	2, CssmSymmetricSAFERAttrList},
};


CSSM_RETURN GetModuleGUID(CSSM_GUID **ModuleGUID)
{
	*ModuleGUID = &TempGUID;
	return (CSSM_OK);
}

CSSM_RETURN FreeModuleGUID(CSSM_GUID **ModuleGUID)
{
	return (CSSM_OK);
}

/*****************************************************************************
 * Function: GetModuleInfo
 * 
 * Sets up ModuleInfo data structure.
 *
 * Input: ModuleInfo - pointer to locatio where the pointer to the ModuleInfo 
 *					   data structure will be stored
 *
 * Output: ModuleInfo
 *
 * Returns: CSSM_OK or CSSM_FAIL
 *
 * History:
 *
 *			Identifier			Date			Description
 *
 */
CSSM_RETURN GetModuleInfo(CSSM_MODULE_INFO **ModuleInfo)
{

	//
	// Set up ModuleInfo
	//
	CssmModuleInfo.Version.Major = IBMCYLINKCSP_MAJOR_VERSION;
	CssmModuleInfo.Version.Minor = IBMCYLINKCSP_MINOR_VERSION;

	CssmModuleInfo.CompatibleCSSMVersion.Major = CSSM_MAJOR;
	CssmModuleInfo.CompatibleCSSMVersion.Minor = CSSM_MINOR;

	if (strlen(IBMCYLINKCSP_DESCRIPTION) > CSSM_MODULE_STRING_SIZE)
	{
		printf("IBMCYLINKCSP_DESCRIPTION length exceeds buffer size.\n");
		return CSSM_FAIL;
	}
	strcpy(CssmModuleInfo.Description, IBMCYLINKCSP_DESCRIPTION); 
	
	if (strlen(IBMCYLINKCSP_VENDOR) > CSSM_MODULE_STRING_SIZE)
	{
		printf("IBMCYLINKCSP_VENDOR length exceeds buffer size.\n");
		return CSSM_FAIL;
	}
	strcpy(CssmModuleInfo.Vendor, IBMCYLINKCSP_VENDOR); 
	
	CssmModuleInfo.Flags = IBMCYLINKCSP_FLAGS; //CSSM_MODULE_THREADSAFE | CSSM_MODULE_EXPORTABLE;
	CssmModuleInfo.ServiceMask = IBMCYLINKCSP_SERVICE_MASK; //CSSM_SERVICE_CSP;
	CssmModuleInfo.NumberOfServices = IBMCYLINKCSP_NUMBER_OF_SERVICES; //1;
	CssmModuleInfo.ServiceList = &CssmServiceInfo;
	CssmModuleInfo.Reserved = NULL;

	//
	// Set up ServiceInfo for CSP
	//
	if (strlen(IBMCYLINKCSP_DESCRIPTION) > CSSM_MODULE_STRING_SIZE)
	{
		printf("IBMCYLINKCSP_DESCRIPTION length exceeds buffer size.\n");
		return CSSM_FAIL;
	}
	strcpy(CssmServiceInfo.Description, IBMCYLINKCSP_DESCRIPTION); 

	CssmServiceInfo.Type = IBMCYLINKCSP_SERVICE_TYPE; //CSSM_SERVICE_CSP;
	CssmServiceInfo.Flags = IBMCYLINKCSP_SERVICE_FLAGS; //CSSM_SERVICE_ISWRAPPEDPRODUCT;
	CssmServiceInfo.NumberOfSubServices = IBMCYLINKCSP_NUMBER_OF_SUBSERVICES; //1;
	CssmServiceInfo.CspSubServiceList = CspSubServiceList;
	CssmServiceInfo.Reserved = IBMCYLINKCSP_SERVICE_RESERVED; //NULL;

	CspSubServiceList[0].SubServiceId = 0;
	if (strlen(IBMCYLINKCSP_DESCRIPTION) > CSSM_MODULE_STRING_SIZE)
	{
		printf("IBMCYLINKCSP_DESCRIPTION length exceeds buffer size.\n");
		return CSSM_FAIL;
	}
	strcpy(CspSubServiceList[0].Description, IBMCYLINKCSP_DESCRIPTION); 
    CspSubServiceList[0].CspFlags = IBMCYLINKCSP_SUBSERVICE_CSP_FLAGS; //0;
    CspSubServiceList[0].CspCustomFlags = IBMCYLINKCSP_SUBSERVICE_CSPCUSTOM_FLAGS; //0;
    CspSubServiceList[0].AccessFlags = IBMCYLINKCSP_SUBSERVICE_ACCESS_FLAGS; //0;
    CspSubServiceList[0].CspType = IBMCYLINKCSP_CSPTYPE; //CSSM_CSP_SOFTWARE;
	CspSubServiceList[0].SoftwareCspSubService.NumberOfCapabilities = sizeof(CssmContextList) / sizeof(CSSM_CONTEXT);
	CspSubServiceList[0].SoftwareCspSubService.CapabilityList = CssmContextList;
	CspSubServiceList[0].SoftwareCspSubService.Reserved = IBMCYLINKCSP_SUBSERVICE_RESERVED; //NULL;

	pCssmWrappedProduct = &CspSubServiceList[0].WrappedProduct;
	pCssmWrappedProduct->StandardVersion.Major = IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_VERSION_MAJOR; //0;
	pCssmWrappedProduct->StandardVersion.Minor = IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_VERSION_MINOR; //0;
	strcpy (pCssmWrappedProduct->StandardDescription, IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_DESCRIPTION/*"N/A"*/);
	pCssmWrappedProduct->ProductVersion.Major = IBMCYLINKCSP_WRAPPED_PRODUCT_PRODUCT_VERSION_MAJOR; //1;
	pCssmWrappedProduct->ProductVersion.Minor = IBMCYLINKCSP_WRAPPED_PRODUCT_PRODUCT_VERSION_MINOR; //0;
	strcpy (pCssmWrappedProduct->ProductDescription, IBMCYLINKCSP_WRAPPED_PRODUCT_DESCRIPTION);
	strcpy (pCssmWrappedProduct->ProductVendor, IBMCYLINKCSP_WRAPPED_PRODUCT_VENDOR);
	pCssmWrappedProduct->ProductFlags = IBMCYLINKCSP_WRAPPED_PRODUCT_FLAGS; //0;

	*ModuleInfo = &CssmModuleInfo;
	return (CSSM_OK);
}

CSSM_RETURN FreeModuleInfo(CSSM_MODULE_INFO **ModuleInfo)
{
	return (CSSM_OK);
}
