
/*************************************************************************************
 *
 * COMPONENT_NAME: CL - JonahCL (Jonah Certificate Library)
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All rights reserved
 * Licensed materials - Property of IBM
 *
 */

/*
 * FILE: info.c
 *
 * This file contains routines necessary for module registration.
 *
 ***********************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#include "install_addin.h"
#include "..\JonahCL.h"

CSSM_MODULE_INFO                                CssmModuleInfo;
CSSM_SERVICE_INFO                               CssmCLInfo;
CSSM_CLSUBSERVICE                               CssmCLSubservice;



CSSM_RETURN GetModuleGUID(CSSM_GUID **ModuleGUID)
{
	*ModuleGUID = &JONAHCL_GUID;
	return (CSSM_OK);
}

CSSM_RETURN FreeModuleGUID(CSSM_GUID **ModuleGUID)
{
	return (CSSM_OK);
}


CSSM_RETURN GetModuleInfo(CSSM_MODULE_INFO **ModuleInfo)
{

	
	CssmCLSubservice.SubServiceId                           = 0;
	strcpy (CssmCLSubservice.Description,"X509v3 DER creation, verification, signing");
	CssmCLSubservice.CertType                                       = CSSM_CERT_X_509v3;
	CssmCLSubservice.CertEncoding                           = CSSM_CERT_ENCODING_DER;
	CssmCLSubservice.AuthenticationMechanism        = CSSM_AUTHENTICATION_NONE;
	CssmCLSubservice.NumberOfTemplateFields         = 0;
	CssmCLSubservice.CertTemplates                          = NULL;
	CssmCLSubservice.NumberOfTranslationTypes       = 0;
	CssmCLSubservice.CertTranslationTypes           = NULL ;
	memset( &CssmCLSubservice.WrappedProduct, 0, sizeof(CssmCLSubservice.WrappedProduct) );

	strcpy( CssmCLInfo.Description, "X.509v3 Certificate Library");
	CssmCLInfo.Type                                 = CSSM_SERVICE_CL;
	CssmCLInfo.Flags                                = 0;
	CssmCLInfo.NumberOfSubServices  = 1;
	CssmCLInfo.ClSubServiceList             = &CssmCLSubservice;
	
	CssmModuleInfo.Version.Major                            = JONAHCL_MAJOR_VERSION;
	CssmModuleInfo.Version.Minor                            = JONAHCL_MINOR_VERSION;
	CssmModuleInfo.CompatibleCSSMVersion.Major      = CSSM_MAJOR;
	CssmModuleInfo.CompatibleCSSMVersion.Minor      = CSSM_MINOR;
	strcpy(CssmModuleInfo.Description, "Jonah PKIX Certificate Library");
	strcpy(CssmModuleInfo.Vendor, "Iris Associates");
	CssmModuleInfo.Flags                                            = 0;
	CssmModuleInfo.ServiceMask                                      = CSSM_SERVICE_CL;
	CssmModuleInfo.NumberOfServices                         = 1;
	CssmModuleInfo.ServiceList                                      = &CssmCLInfo;

	
	*ModuleInfo = &CssmModuleInfo;
	return (CSSM_OK);
}

CSSM_RETURN FreeModuleInfo(CSSM_MODULE_INFO **ModuleInfo)
{
	return (CSSM_OK);
}
