/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <pkcs.h>
#include <crypto.h>

#ifndef min
#define min(a,b)	((a) < (b) ? (a) : (b))
#endif

#ifndef max
#define max(a,b)	((a) < (b) ? (b) : (a))
#endif

#ifndef compare_oid
#define compare_oid(b, s)	memcmp(b.data, s, max(b.data_len, strlen(s)))
#endif

#ifndef compare_oid_p
#define compare_oid_p(b, s)	memcmp(b->data, s, max(b->data_len, strlen(s)))
#endif

#define ASEncryptedCI(i)	as[i]->content.value.encryptedData.encryptedContentInfo

int
PFX::read(unsigned char *password, r_buffer_t &buf)
{
  buffer_t		contentType;
  buffer_t		p12Alg;
  buffer_t		bagType;
  buffer_t		pbeData;
  buffer_t		bagData;
  buffer_t		certType;
  buffer_t		kd;
  buffer_t		safe(ASN_SECRET);
  buffer_t		salt;
  buffer_t		certBuf;
  buffer_t		asBuf;
  buffer_t		encData;
  uint32		status = 0;
  uint32		asCount = 0;
  uint32		scCount = 0;
  uint32		scnt = 0;
  uint32		cnt = 0;
  uint32		tpLen;
  unsigned char		*tp = NULL;
  long			version = 0;
  long			icnt = 0;
  PrivateKeyInfo	*key = NULL;
  KeyBag		kb;
  x509_certificate	*certPtr = NULL;
  CertBag		cb;
  pkcs_12PbeParams	pbe;
  AuthenticatedSafes	as;
  SafeContents		sc;
  
  if ((status = asn_sequence::read(buf)) != 0) {
    return status;
  }
  if (( status = this->version.get_value(version)) != 0) {
    return status;
  }
  // We only support V3 PKCS #12 files
  if (version != PKCS12_V3) {
    return ASN_PKCS12_BAD_VERSION; 
  }
  if ((status = authSafes.content.value.data.write(asBuf))) {
    return status;
  }
  if ((status = as.read(asBuf)) != 0) {
    return status;
  }
  asCount = as.get_child_count();
  for(cnt = 0; cnt < asCount ; cnt++) {
      contentType.clear();
      safe.clear();
      as[cnt]->contentType.display(contentType);
      if (compare_oid(contentType, PKCS7_ENCRYPTED_DATA_ID) == 0) {
	contentType.clear();
	ASEncryptedCI(cnt).contentType.display(contentType);
	p12Alg.clear();
	ASEncryptedCI(cnt).contentEncryptionAlgorithm.algorithm.
	  display(p12Alg);
	pbeData.clear();
	ASEncryptedCI(cnt).contentEncryptionAlgorithm.parameters.
	  write(pbeData);
	ASEncryptedCI(cnt).encryptedContent.get_value(tp, tpLen);
	encData.clear();
	encData.append(tp, tpLen);
	if ((status = pbe.read(pbeData))) {
	  return status;
	}
	pbe.iterationCount.get_value(icnt);
	pbe.salt.get_value(tp, tpLen);
	salt.clear();
	salt.append(tp, tpLen);
	if ((status = CR_PKCS12DecryptContent(p12Alg, salt, icnt, password, 
					      encData, safe))) { 
	  return status;
	}
      } else if (compare_oid(contentType, PKCS7_DATA_ID) == 0) {
	as[cnt]->content.value.data.get_value(tp, tpLen);
	safe.append(tp, tpLen);
      } else { // XXX 
	printf("Content Type  = %.*s\n", contentType.data_len, 
	       contentType.data);
      }
      sc.empty();
      if ((status = sc.read(safe)) != 0) {
	return status;
      }
      scCount = sc.get_child_count();
      for(scnt = 0; scnt < scCount; scnt++) {
	bagType.clear();
	sc[scnt]->bagType.display(bagType);
	if (compare_oid(bagType, PKCS12_CERTBAG) == 0) {
	  bagData.clear();
	  if ((status = sc[scnt]->bagContent.value.write(bagData))) {
	    return status;
	  }
	  if ((status = cb.read(bagData))) {
	    return status;
	  }
	  certType.clear();
	  cb.certType.display(certType);
	  if (compare_oid(certType, PKCS9_CERTTYPE_X509) != 0) {
	    return -1; //XXX
	  }
	  if ((status = cb.cert.value.write(certBuf))) {
	    return status;
	  }
	  certPtr = certList.add_child();
	  if ((status = certPtr->read(certBuf))) {
	    return status;
	  }
	} else if (compare_oid(bagType, PKCS12_SHROUDED_KEYBAG) == 0) {
	} else if (compare_oid(bagType, PKCS12_KEYBAG) == 0) {
	  bagData.clear();
	  sc[0]->bagContent.write(bagData);
	  if ((status = kb.read(bagData))) {
	    return status;
	  }
	  kd.clear();
	  kb.write(kd);
	  key = keyList.add_child();
	  key->read(kd);
	} else if (compare_oid(bagType, PKCS12_CRLBAG) == 0) {
	  continue;
	} else if (compare_oid(bagType, PKCS12_SECRETBAG) == 0) {
	  continue;
	} else if (compare_oid(bagType, PKCS12_SAFECONTENTSBAG) == 0) {
	  continue;
	} else {
	  printf("OID = %.*s\n", bagType.data_len, bagType.data);
	  return -1; // XXX
	}
      }
  }
  return 0;
}
