﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Helpers;
using System.Threading;

namespace TreeSample {
    public class Tree {
        public Tree left = null;
        public Tree right = null;
        public int depth = 0;
        public int data = 0;

        private static bool verbose = true;

        ////////////////////////////////////////////////////////////////////////////////
        //
        // erzeugt Last und gibt die Thread-ID aus
        //
        public int ProcessItem() {
            if (verbose) {
                Console.Write("{0} ", ThreadId.CurrentThread);
            }
            Thread.SpinWait(400000);   // anstatt einer echten Berechnung
            return data;
        }

        public static Tree CreateSomeTree(int depth, int start) {
            Tree tree = new Tree();
            tree.depth = depth;
            tree.data = start;

            if (depth > 0) {
                tree.left = CreateSomeTree(depth - 1, start + 1);
                tree.right = CreateSomeTree(depth - 1, start + 1);
            }
            return tree;
        }
    }
}
