﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Helpers;

namespace Quicksort {
    class Quicksort {
        
        // diese Paramter für Performance-Tests verwenden
        static int SIZE = 10000000;
        static int GRAINSIZE = 10;
        static int THRESHOLD = 100;
        static int MAXRAND = 10000000;

        // diese Parameter zum Testen und Anzeigen der Sortierung einkommentieren
        //static int SIZE = 100;
        //static int GRAINSIZE = 1;
        //static int THRESHOLD = 10;
        //static int MAXRAND = 1000;

        static void Main(string[] args) {
            Console.WriteLine("starting Quicksort sample...");

            
            // Array erzeugen und mit beliebigen Werten füllen
            int[] array1, array2;
            array1 = new int[SIZE];
            Random rand = new Random();
            for (int i = 0; i < array1.Length; i++) {
                array1[i] = rand.Next(MAXRAND);
            }
            array2 = (int[])array1.Clone();

            TestRunner.Runtest(() => QuickSort(array1, 0, SIZE - 1));
            if (array1.Length < 255) PrintArray(array1); // bei großen Arrays wird das Ergebnis nicht ausgegeben
            TestRunner.Runtest(() => QuickSortParallel(array2, 0, SIZE - 1));
            if (array2.Length < 255) PrintArray(array2); // bei großen Arrays wird das Ergebnis nicht ausgegeben

            Console.WriteLine("done. Press any key.");
            Console.ReadKey();
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // sequenzieller Quicksort, Parameter sind linker und rechter Index des 
        // Teilarrays
        //
        public static void QuickSort(int[] a, int left, int right) {
            if (right - left>= GRAINSIZE) {
                int pivotNewIndex = Partition(a, left, right);

                QuickSort(a, left, pivotNewIndex - 1);
                QuickSort(a, pivotNewIndex + 1, right);

            } else {
                InsertionSort(a, left, right + 1);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // paralleler Quicksort, Parameter sind linker und rechter Index des Teilarrays
        //
        public static void QuickSortParallel(int[] a, int left, int right) {
            if (right - left >= GRAINSIZE) {
                int pivotNewIndex = Partition(a, left, right);

                if (right - left >= THRESHOLD) {
                    Parallel.Invoke(
                        () => QuickSortParallel(a, left, pivotNewIndex - 1),
                        () => QuickSortParallel(a, pivotNewIndex + 1, right)
                    );
                } else {
                    QuickSortParallel(a, left, pivotNewIndex - 1);
                    QuickSortParallel(a, pivotNewIndex + 1, right);
                }

            } else {
                InsertionSort(a, left, right + 1);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // Array teilen
        //
        private static int Partition(int[] a, int left, int right) {
            int pivotValue = a[left];  
            Swap(a, left, right);
            int storeIndex = left;
            for (int i = left; i < right; i++)
                if (a[i] <= pivotValue)
                    Swap(a, i, storeIndex++);
            Swap(a, storeIndex, right);
            return storeIndex;
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // zwei Werte in einem Array vertauschen
        //
        private static void Swap(IList<int> list, int indexA, int indexB) {
            int tmp = list[indexA];
            list[indexA] = list[indexB];
            list[indexB] = tmp;
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // Insertion Sort Algorithm
        //
        private static void InsertionSort(int[] a, int l, int r) {
            for (int i = l+2; i < r; i++) {
                int value = a[i];
                int j = i-1;
                while ((j >= 0) && (a[j] > value)) {
                    a[j+1] = a[j];
                    j--;
                }
                a[j + 1] = value;
            }
        }

        ////////////////////////////////////////////////////////////////////////////////
        //
        // Array ausgeben
        //
        private static void PrintArray(Array a) {
            for (int i = 0; i < a.Length; i++) {
                Console.Write(a.GetValue(i));
                if (i < a.Length - 1) Console.Write(", ");
            }
            Console.WriteLine();
        }
    }
}
