﻿using System;
using System.Threading.Tasks;
using Helpers;

////////////////////////////////////////////////////////////////////////////////
// False-Sahring-Demo
// angeleht an das Beispiel aus "Patterns for Parallel Programming: 
// Understanding and Applying Parallel Patterns with the .NET Framework 4"
// von Stephen Toub, Seite 44, 
// http://www.microsoft.com/downloads/details.aspx?FamilyID=86b3d32b-ad26-4bb8-a3ae-c1637026c3ee&displaylang=en
//
namespace FalseSharing {

    class FalseSharingSample {

        static void Main(string[] args) {
            TestRunner.Runtest(() => Sequential());
            TestRunner.Runtest(() => WithFalseSharing());
            TestRunner.Runtest(() => WithoutFalseSharing());
            Console.WriteLine("done. Press any key.");
            Console.ReadKey();
        }

        static void Sequential() {
            Random rand1 = new Random(), rand2 = new Random();
            int[] results1 = new int[20000000], results2 = new int[20000000];
            for (int i = 0; i < results1.Length; i++)
                results1[i] = rand1.Next();
            for (int i = 0; i < results2.Length; i++)
                results2[i] = rand2.Next();
        }

        static void WithFalseSharing() {
            Random rand1 = new Random(), rand2 = new Random();
            int[] results1 = new int[20000000], results2 = new int[20000000];
            Parallel.Invoke(
                () => {
                    for (int i = 0; i < results1.Length; i++)
                        results1[i] = rand1.Next();
                },
            () => {
                for (int i = 0; i < results2.Length; i++)
                    results2[i] = rand2.Next();
            });
        }

        static void WithoutFalseSharing() {
            int[] results1, results2;
            Parallel.Invoke(
                () => {
                    Random rand1 = new Random();
                    results1 = new int[20000000];
                    for (int i = 0; i < results1.Length; i++)
                        results1[i] = rand1.Next();
                },
                () => {
                    Random rand2 = new Random();
                    results2 = new int[20000000];
                    for (int i = 0; i < results2.Length; i++)
                        results2[i] = rand2.Next();
                });
        }
    }
}
