' Beispiele 
' Autor: Holger Schwichtenberg
' http://www.komponenten.info

Imports System.Xml
Imports System.Xml.XPath

Module XPATH_MOD


  ' === Beispiel fr XPath-Navigator
  Public Sub XPATHNavi()
  Const DATEI As String = "..\daten\counter.xml"
    Dim name As String, wert As String

    Dim doc As XPathDocument = New XPathDocument(DATEI)
    Dim nav As XPathNavigator = doc.CreateNavigator()
    Dim nav2 As XPath.XPathNavigator

    ' === Pfad
    Const XPATH = "*//url"

    ' --- Selektion der URL-Elemente
    Dim iterator As XPathNodeIterator = nav.Select(XPATH)
    out("Anzahl gefundener Knoten:" & iterator.Count)

    ' --- Schleife ber alle URL-Elemente
    While (iterator.MoveNext())
      nav2 = iterator.Current
      ' --- Auslesen des Attributs "Name" der URL
      name = nav2.GetAttribute("name", "")
      ' --- Navigation zum Unterlement "Count"
      Dim it2 As XPathNodeIterator = nav2.Select("count")
      it2.MoveNext()
      ' --- Auslesen des Inhalts von Count 
      wert = it2.Current.Value
      'it2.Current.Value = 0 nicht erlaubt!
      out(name & "=" & wert)
    End While
  End Sub



  ' === Rekursive Ausgabe eines XPathNavigators
  Public Sub XPATH_Rekursiv_ausgeben(ByVal nav As XPathNavigator, ByVal ebene As Integer)

    Select Case nav.NodeType
      Case XPathNodeType.Element
        out(Space(ebene) & nav.LocalName)
      Case XPathNodeType.Text
        out(Space(ebene) & nav.Value)
    End Select

    If (nav.MoveToFirstChild()) Then
      Do
        XPATH_Rekursiv_ausgeben(nav, ebene + 1)
      Loop While (nav.MoveToNext())

      nav.MoveToParent()
      If (nav.NodeType = XPathNodeType.Element) Then
        'Console.WriteLine("X: </{0}>", nav.Name)
      End If
    End If

  End Sub

  ' === Rekursive Traversierung eines XPathNavigators
  Public Sub XPATH_Rekursiv(ByVal nav As XPathNavigator)
    If (nav.MoveToFirstChild()) Then
      If nav.HasAttributes Then
        nav.MoveToFirstAttribute()
      End If
      Do ' --- Schleife ber alle Kinden
        XPATH_Rekursiv(nav)
      Loop While (nav.MoveToNext())
      nav.MoveToParent() ' --- Cursor wieder eine Ebene hher
    End If
  End Sub

  ' === Geschwindigkeitstest fr XPath-Navigator
 Public Sub xpath_speed_XPathDocument()
  Const DATEI As String = "..\daten\preisliste.xml"
  ts("XPath_XPathDocument:laden")
  Dim doc As XPathDocument = New XPathDocument(DATEI)
  Dim nav As XPathNavigator = doc.CreateNavigator()
  te()
  ts("XPath_XPathDocument:Durchlauf")
  XPATH_Rekursiv(nav)
  te()
 End Sub

 ' === Geschwindigkeitstest fr XPath-Navigator
 Public Sub xpath_speed_XMLDocument()
  Const DATEI As String = "..\daten\preisliste.xml"
  ts("XPath_XMLDocument:laden")
  Dim doc As New XmlDocument
  doc.Load(DATEI)
  Dim nav As XPathNavigator = doc.CreateNavigator()
  te()
  ts("XPath_XMLDocument:Durchlauf")
  XPATH_Rekursiv(nav)
  te()
 End Sub



End Module
