/*
 * Created on Jun 29, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.util.VectorCalculations;

public class CollisionRater extends BaseTargetRater {
    private static final int THRUST_PREDICTION_INTERVAL = 70;

    private static final double DISTANCE_PREDICTED_THRUST_THRESHOLD = 50;

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList,
            RatedTarget target) {
        double curDistance = VectorCalculations.getDistance(gameStatus.getShip(), target.getTarget());

        // Only rate closer to 300
        if (curDistance < 300) {

            double diffAngle = VectorCalculations.getAngleBetween(gameStatus.getShip().getDirectionVector(), VectorCalculations.getDifference(gameStatus.getShip().getDirectionVector(), target.getTarget().getPosition().getCurVector()));

            // If candidate is not in front (within +/- 45 degrees)
            if (diffAngle > Math.PI / 4) {
                com.dkaedv.asteroids.data.Vector predVector1 = target.getTarget().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL);
                com.dkaedv.asteroids.data.Vector predVector2 = target.getTarget().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 2);
                com.dkaedv.asteroids.data.Vector predVector3 = target.getTarget().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 3);
                com.dkaedv.asteroids.data.Vector predVector4 = target.getTarget().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 4);

                double predDist1 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL), predVector1);
                double predDist2 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 2), predVector2);
                double predDist3 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 3), predVector3);
                double predDist4 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(THRUST_PREDICTION_INTERVAL * 4), predVector4);

                if (predDist1 < DISTANCE_PREDICTED_THRUST_THRESHOLD
                        || predDist2 < DISTANCE_PREDICTED_THRUST_THRESHOLD
                        || predDist3 < DISTANCE_PREDICTED_THRUST_THRESHOLD
                        || predDist4 < DISTANCE_PREDICTED_THRUST_THRESHOLD) {

                    rateIt(target, 100);
                }
            }
        }

    }

}
