/*
 * Created on Jun 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.util.VectorCalculations;

public class AngleRater extends BaseTargetRater {
    private Log log = LogFactory.getLog(AngleRater.class);

    // TODO Find the correct value
    double maxAngle = 3;

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target) {

        Ship ship = gameStatus.getShip();

        Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(ship.getPosition().getCurVector(), target.getTarget().getPosition().getCurVector());
        double angle = VectorCalculations.getAngleBetween(ship.getDirectionVector(), vectorToTarget);
        double angleAbsDiff = Math.abs(ship.getDirectionAngle() - Math.atan2(vectorToTarget.y, vectorToTarget.x));

        // If not in front add 180 degrees
        if (angleAbsDiff > Math.PI) {
            angle += Math.PI / 2;
        }

        if (angle > maxAngle) {
            log.debug ("Increasing max angle to " + angle);
            maxAngle = angle;
        }

        double score = (1 -(angle / maxAngle)) * 100;
        rateIt(target, (int) score);
    }

}
