/*
 * Created on Apr 21, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.ki.rater.BaseTargetRater;
import com.dkaedv.asteroids.util.DistanceComparator;
import com.dkaedv.asteroids.util.VectorCalculations;

public class MultiWeightingStrategy extends BaseStrategy {
    private Log log = LogFactory.getLog(MultiWeightingStrategy.class);

    /**
     * Target raters, configure by spring.
     */
    private List<BaseTargetRater> raters;

    // Recalculate targeting if target is away more than this distance
    private final static double TARGET_RECALC_DISTANCE = 100;


    private long runtime = 0;

    @Override
    public void run() {
        while (true) {
            doProcessing();

            try {
                gameStatus.waitForUpdate();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void doProcessing() {
        long startTime = System.currentTimeMillis();

        if (gameStatus.getShip() != null) {
            Ship ship = gameStatus.getShip();

            // Build the list of target candidates (Asteroids + UFO)
            List<IPositionable> targetCandidates = new java.util.Vector<IPositionable>();
            targetCandidates.addAll(gameStatus.getAsteroids());

            if (gameStatus.getUfo() != null)
                targetCandidates.add(gameStatus.getUfo());

            // Sort the candidates by distance
            Collections.sort(targetCandidates, new DistanceComparator(gameStatus.getShip()));

            if (targetCandidates.size() > 0) {

                IPositionable lastTarget = null;
                if (targetList.getFirstTarget() != null) {
                    lastTarget = targetList.getFirstTarget();
                }

                IPositionable firstTarget = lastTarget;

                // Targets are now sorted by distance
                if (lastTarget == null
                        || VectorCalculations.getDistance(ship, lastTarget) > TARGET_RECALC_DISTANCE
                        || !targetCandidates.contains(lastTarget)) {
                    // Recalc target only if last target moved out of range


                    // Save a first target with lowest score (0)
                    firstTarget = targetCandidates.get(0);
                    RatedTarget firstRatedTarget = new RatedTarget(firstTarget);

                    // Run through possible targets
                    for (IPositionable targetCandidate : targetCandidates) {
                        RatedTarget ratedCandidate = new RatedTarget(targetCandidate);

                        // Rate targets
                        for (BaseTargetRater rater : raters) {
                            rater.rateTarget(gameStatus, targetList, ratedCandidate);
                        }

                        // Update first target if score is heigher
                        if (ratedCandidate.getRating() > firstRatedTarget.getRating()) {
                            firstRatedTarget = ratedCandidate;
                            firstTarget = ratedCandidate.getTarget();
                        }
                    }

                } else {
                    // Keep the same target as before
                    // Nothing to do because firstTarget == lastTarget
                }
                targetCandidates.remove(firstTarget);

                synchronized (targetList) {
                    targetList.getTargets().clear();
                    targetList.getTargets().add(firstTarget);
                    targetList.getTargets().addAll(targetCandidates);
                }
            } else {
                // No target candidates
                synchronized (targetList) {
                    targetList.getTargets().clear();
                }
            }
        }

        runtime = System.currentTimeMillis() - startTime;
        //log.debug("Runtime: " + runtime + "ms");
    }


    /**
     * @param raters the raters to set
     */
    public void setRaters(List<BaseTargetRater> raters) {
        this.raters = raters;
    }

}
