/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.ki.rater.BaseTargetRater;

public class ScoreRater
extends BaseTargetRater {
    private static final double MAX_SCORE = 1000.0;
    private static final double SCORE_ASTEROID_BIG = 20.0;
    private static final double SCORE_ASTEROID_MEDIUM = 50.0;
    private static final double SCORE_ASTEROID_SMALL = 100.0;
    private static final double SCORE_UFO_SMALL = 1000.0;
    private static final double SCORE_UFO_BIG = 200.0;

    public void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target) {
        IPositionable innerTarget = target.getTarget();
        double score = 0.0;
        if (innerTarget instanceof Asteroid) {
            Asteroid asteroid = (Asteroid)innerTarget;
            switch (asteroid.getRadius() / 4) {
                case 8: {
                    score = 20.0;
                    break;
                }
                case 4: {
                    score = 50.0;
                    break;
                }
                case 2: {
                    score = 100.0;
                }
            }
        } else if (innerTarget instanceof Ufo) {
            Ufo ufo = (Ufo)innerTarget;
            switch (ufo.getRadius()) {
                case 15: {
                    score = 200.0;
                    break;
                }
                case 8: {
                    score = 1000.0;
                }
            }
        }
        int rating = (int)(score / 1000.0 * 100.0);
        this.rateIt(target, rating);
    }
}

