/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.ki.rater.BaseTargetRater;
import com.dkaedv.asteroids.util.VectorCalculations;

public class CollisionRater
extends BaseTargetRater {
    private static final int THRUST_PREDICTION_INTERVAL = 70;
    private static final double DISTANCE_PREDICTED_THRUST_THRESHOLD = 50.0;

    public void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target) {
        double diffAngle;
        double curDistance = VectorCalculations.getDistance(gameStatus.getShip(), target.getTarget());
        if (curDistance < 300.0 && (diffAngle = VectorCalculations.getAngleBetween(gameStatus.getShip().getDirectionVector(), VectorCalculations.getDifference(gameStatus.getShip().getDirectionVector(), target.getTarget().getPosition().getCurVector()))) > 0.7853981633974483) {
            Vector predVector1 = target.getTarget().getPosition().getPredictedVector(70L);
            Vector predVector2 = target.getTarget().getPosition().getPredictedVector(140L);
            Vector predVector3 = target.getTarget().getPosition().getPredictedVector(210L);
            Vector predVector4 = target.getTarget().getPosition().getPredictedVector(280L);
            double predDist1 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(70L), predVector1);
            double predDist2 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(140L), predVector2);
            double predDist3 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(210L), predVector3);
            double predDist4 = VectorCalculations.getDistance(gameStatus.getShip().getPosition().getPredictedVector(280L), predVector4);
            if (predDist1 < 50.0 || predDist2 < 50.0 || predDist3 < 50.0 || predDist4 < 50.0) {
                this.rateIt(target, 100);
            }
        }
    }
}

