/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Shot;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.net.KeysDatagram;
import com.dkaedv.asteroids.util.DistanceComparator;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.util.Collections;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollisionProtector
extends Thread {
    private Log log = LogFactory.getLog(CollisionProtector.class);
    protected GameStatus gameStatus;
    protected KeysDatagram keysDatagram;
    protected TargetList targetList;
    private static final double DISTANCE_THRESHOLD = 25.0;
    private static final double DISTANCE_THRUST_THRESHOLD = 300.0;
    private static final double DISTANCE_PREDICTED_THRUST_THRESHOLD = 50.0;
    private static final int THRUST_PREDICTION_INTERVAL = 70;
    private static final double DISTANCE_SHOT_THRESHOLD = 40.0;
    private static final boolean ENABLE_THRUST = false;

    public void run() {
        while (true) {
            this.doProcessing();
            try {
                this.gameStatus.waitForUpdate();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void doProcessing() {
        boolean statusUpdated = false;
        Vector<IDrawable> collCandidates = new Vector<IDrawable>();
        collCandidates.addAll(this.gameStatus.getAsteroids());
        if (this.gameStatus.getUfo() != null) {
            collCandidates.add(this.gameStatus.getUfo());
        }
        if (collCandidates.size() > 0 && this.gameStatus.getShip() != null) {
            Collections.sort(collCandidates, new DistanceComparator(this.gameStatus.getShip().getPosition().getCurVector()));
            IPositionable collObj = (IPositionable)collCandidates.get(0);
            double minDistance = VectorCalculations.getDistance(this.gameStatus.getShip().getPosition().getCurVector(), collObj.getPosition().getCurVector());
            if (collObj instanceof Asteroid) {
                minDistance -= (double)((Asteroid)collObj).getRadius();
            }
            if (collObj instanceof Ufo) {
                minDistance -= (double)((Ufo)collObj).getRadius();
            }
            if (minDistance < 25.0) {
                this.log.warn("Warping for collision protection");
                this.keysDatagram.warp(1L);
                this.gameStatus.setCollisionStatus(3);
                statusUpdated = true;
            }
            Vector<Shot> shots = new Vector<Shot>();
            shots.addAll(this.gameStatus.getShots());
            if (shots.size() > 0 && this.gameStatus.getShip() != null && this.gameStatus.getUfo() != null) {
                double lastDistance;
                Collections.sort(shots, new DistanceComparator(this.gameStatus.getShip().getPosition().getCurVector()));
                IPositionable shot = (IPositionable)shots.get(0);
                minDistance = VectorCalculations.getDistance(this.gameStatus.getShip().getPosition().getCurVector(), shot.getPosition().getCurVector());
                if (minDistance < 40.0 && shot.getPosition().getLastVector() != null && System.currentTimeMillis() - shot.getPosition().getLastVector().timestamp > 50L && ((Shot)shot).getType() == 2 && minDistance < (lastDistance = VectorCalculations.getDistance(this.gameStatus.getShip().getPosition().getCurVector(), shot.getPosition().getLastVector()))) {
                    this.log.warn("Warping for collision protection - shot moving towards me");
                    this.keysDatagram.warp(1L);
                }
            }
        }
        if (!statusUpdated) {
            this.gameStatus.setCollisionStatus(1);
            statusUpdated = true;
        }
    }

    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }

    public void setKeysDatagram(KeysDatagram keysDatagram) {
        this.keysDatagram = keysDatagram;
    }

    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }
}

