/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.data;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Position;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Asteroid
implements IPositionable,
IDrawable {
    private int scaleFactor = 0;
    private int type = 0;
    private Position position;
    public static final int NORMAL_SCALE = 8;
    private static final GeneralPath PATH0 = new GeneralPath();
    private static final GeneralPath PATH1 = new GeneralPath();
    private static final GeneralPath PATH2 = new GeneralPath();
    private static final GeneralPath PATH3 = new GeneralPath();
    private static final Shape[] SHAPES;

    public Asteroid(int curX, int curY, int type, int scaleFactor) {
        this.position = new Position(curX, curY);
        this.type = type;
        this.scaleFactor = scaleFactor;
    }

    public Position getPosition() {
        return this.position;
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(Color.gray);
        AffineTransform trafo = new AffineTransform(this.getDrawScale(), 0.0f, 0.0f, this.getDrawScale(), this.position.getCurVector().x, this.position.getCurVector().y);
        g.draw(trafo.createTransformedShape(SHAPES[this.type - 1]));
        this.getPosition().draw(g, textG);
    }

    private int getDrawScale() {
        switch (this.scaleFactor) {
            case 0: {
                return 8;
            }
            case 15: {
                return 4;
            }
            case 14: {
                return 2;
            }
        }
        return 8;
    }

    public int getRadius() {
        return 4 * this.getDrawScale();
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public int getType() {
        return this.type;
    }

    static {
        PATH0.moveTo(1.0f, 0.0f);
        PATH0.lineTo(4.0f, 1.0f);
        PATH0.lineTo(4.0f, 2.0f);
        PATH0.lineTo(1.0f, 4.0f);
        PATH0.lineTo(-2.0f, 4.0f);
        PATH0.lineTo(-1.0f, 3.0f);
        PATH0.lineTo(-4.0f, 3.0f);
        PATH0.lineTo(-4.0f, -1.0f);
        PATH0.lineTo(-2.0f, -4.0f);
        PATH0.lineTo(1.0f, -3.0f);
        PATH0.lineTo(2.0f, -4.0f);
        PATH0.lineTo(4.0f, -2.0f);
        PATH0.closePath();
        PATH1.moveTo(3.0f, 0.0f);
        PATH1.lineTo(4.0f, 2.0f);
        PATH1.lineTo(2.0f, 4.0f);
        PATH1.lineTo(0.0f, 2.0f);
        PATH1.lineTo(-2.0f, 4.0f);
        PATH1.lineTo(-4.0f, 2.0f);
        PATH1.lineTo(-4.0f, -2.0f);
        PATH1.lineTo(-2.0f, -4.0f);
        PATH1.lineTo(1.0f, -4.0f);
        PATH1.lineTo(4.0f, -2.0f);
        PATH1.closePath();
        PATH2.moveTo(4.0f, 1.0f);
        PATH2.lineTo(2.0f, 4.0f);
        PATH2.lineTo(-1.0f, 4.0f);
        PATH2.lineTo(-4.0f, 1.0f);
        PATH2.lineTo(-2.0f, 0.0f);
        PATH2.lineTo(-4.0f, -1.0f);
        PATH2.lineTo(-2.0f, -4.0f);
        PATH2.lineTo(0.0f, -1.0f);
        PATH2.lineTo(0.0f, -4.0f);
        PATH2.lineTo(2.0f, -4.0f);
        PATH2.lineTo(4.0f, -1.0f);
        PATH2.closePath();
        PATH3.moveTo(2.0f, 1.0f);
        PATH3.lineTo(4.0f, 2.0f);
        PATH3.lineTo(2.0f, 4.0f);
        PATH3.lineTo(0.0f, 3.0f);
        PATH3.lineTo(-2.0f, 4.0f);
        PATH3.lineTo(-4.0f, 2.0f);
        PATH3.lineTo(-3.0f, 0.0f);
        PATH3.lineTo(-4.0f, -2.0f);
        PATH3.lineTo(-2.0f, -4.0f);
        PATH3.lineTo(-1.0f, -3.0f);
        PATH3.lineTo(2.0f, -4.0f);
        PATH3.lineTo(4.0f, -1.0f);
        PATH3.closePath();
        SHAPES = new Shape[]{PATH1, PATH3, PATH2, PATH0};
    }
}

