/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import de.uhingen.kielkopf.andreas.UdpHandler;
import de.uhingen.kielkopf.andreas.UdpInterpreter;
import de.uhingen.kielkopf.andreas.modell.Drawable;

/**
 * @author andreas
 * 
 */
public class Display extends JPanel implements ActionListener {
    /**
     * 
     */
    private static final long serialVersionUID = 7968786031990545433L;
    private Timer             timer;
    private JTextField        infotextfield    = null;
    private int               displaytime      = 50;

    /**
     * This is the default constructor
     */
    public Display() {
        super();
        initialize();
    }
    /**
     * This method initializes this
     * 
     * @return void
     */
    private void initialize() {
        setSize(400, 400);
        setBackground(Color.black);
        setLayout(new GridBagLayout());
        timer = new Timer(displaytime, this);
        timer.start();
    }
    /*
     * (non-Javadoc)
     * 
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(final ActionEvent arg0) {
        try {
            UdpInterpreter.barier_display.reset();
            UdpInterpreter.barier_display.await(displaytime >> 1, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (BrokenBarrierException e) {
            System.err.println("z");
        } catch (TimeoutException e) {}
        repaint();
    }
    /**
     * 
     */
    private void displayInfo() {
        if (infotextfield != null) infotextfield.setText(Drawable.getDrawlistsize() + " objects +"
                + Drawable.getCachelistsize() + " cache");
    }
    /*
     * (non-Javadoc)
     * 
     * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
     */
    @Override
    protected void paintComponent(final Graphics arg0) {
        final Graphics2D g = (Graphics2D) arg0;
        try {
            double scale = Math.min(getHeight(), getWidth()) / 1024.0;
            g.setColor(getBackground());
            g.fillRect(0, 0, getWidth(), getHeight());
            g.setColor(Color.red);
            // g.translate(0, getHeight() - 1);
            g.scale(scale, scale);
            g.setColor(getForeground());
            g.drawRect(0, 0, 1023, 1023);
            g.setFont(getFont().deriveFont(25.1f));
            // if (Drawable.listclean.tryAcquire()) {
            ArrayList<Drawable> drawlist = UdpInterpreter.getCleanlist();
            if (drawlist != null) {
                for (final Drawable object : drawlist) {
                    object.draw(g);
                }
            }
            // }
        } catch (final RuntimeException e) {
            e.printStackTrace();
        } // finally { Drawable.listclean.release(); }
    }
    /**
     * @param textField_display
     */
    public void setInfoTextfield(JTextField textField_display) {
        infotextfield = textField_display;
    }
}
