/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.modell;

import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.MouseInputListener;
import de.uhingen.kielkopf.andreas.UdpInterpreter;

/**
 * @author andreas Beschreibt die Bewegung eines Zielobjekts
 */
public class Ziel extends FlugKoerper {
    private static Ziel                ziel     = null;
    private static Schiff              schiff   = null;
    private static ArrayList<Drawable> drawlist = null;
    private static Drawable            erg      = null;

    /**
     * @return es kann jeweils nur ein Ziel geben
     * 
     */
    public static synchronized Ziel getZielVector() {
        if (ziel == null) ziel = new Ziel();
        if (schiff == null) schiff = Schiff.getSchiff();
        // Drawable.listclean.acquireUninterruptibly();
        try {
            UdpInterpreter.barier_ziel.reset();
            UdpInterpreter.barier_ziel.await(50, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {} catch (BrokenBarrierException e) {
            System.err.println("z");
        } catch (TimeoutException e) {}
        drawlist = UdpInterpreter.getCleanlist();
        erg = null;
        int min_gefahr = -10;
        int gefahr;
        UFOsuche: for (Drawable drawable : drawlist) { // ouch
            if (drawable.isUFO()) {
                gefahr = 1800;
                if (gefahr > min_gefahr) {
                    erg = drawable;
                    min_gefahr = gefahr;
                }
            } else if (drawable.isAsteroid()) {
                gefahr = schiff.bewerteGefahr(drawable);
                if (gefahr > min_gefahr) {
                    erg = drawable;
                    min_gefahr = gefahr;
                }
            } else {
                gefahr = 0;
            }
            drawable.setGefahr(gefahr); // schaltet bisherige Ziele ab
        }
        if (erg != null) {
            ziel.pos = erg.pos;
            ziel.dpos = erg.dpos;
            // Drawable.zielwinkel = Math.atan2(ziel.pos.y, ziel.pos.x);
            /*
             * ziel.pos.x = erg.getX0(); ziel.pos.y = erg.getY0(); ziel.pos.z = erg.Time0();
             * ziel.dpos.x = erg.getdX(); ziel.dpos.y = erg.getdY(); ziel.dpos.z = erg.dTime();
             */
            erg.setGefahr(1000);
        }
        Drawable.listclean.release();
        return (erg == null) ? null : ziel;
    }
}
