/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.modell;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

/**
 * @author andreas
 * 
 */
public class Drawable extends FlugKoerper {
    private int                              xdelta       = 0;
    private int                              ydelta       = 0;
    public static double                     winkel       = 0;
    public static double                     zielwinkel   = 0;
    private static int                       wx           = 0;
    private static int                       wy           = 0;
    private int                              gsf;
    /** @deprecated */
    private Color                            farbe        = Color.lightGray;
    private Bild                             bild         = Bild.unbekannt;
    private int                              gefahr       = 0;
    /** @deprecated */
    private int                              nr;
    private static int                       labs_xpos    = 0;
    private static int                       labs_ypos    = 0;
    private static int                       labs_gsf     = 0;
    private static long                      udptimestamp = 0;
    private static long                      udptdd;
    public static Semaphore                  listclean    = new Semaphore(1);
    /** @deprecated */
    private static final ArrayList<Drawable> drawList     = new ArrayList<Drawable>();
    /** @deprecated */
    private static final ArrayList<Drawable> cleanlist    = new ArrayList<Drawable>();
    /** @deprecated */
    private static final ArrayList<Drawable> cachelist    = new ArrayList<Drawable>();

    /**
     */
    public Drawable() {
        size = 2;
    }
    /**
     * @param test
     */
    public Drawable(final Bild test) {
        bild = test;
        size = 2;
    }
    /**
     * @param test
     * @param gsf2
     */
    public Drawable(Bild test, int gsf2) {
        bild = test;
        size = 2;
        gsf = gsf2;
    }

    public enum Bild {
        Asteroid1(0x08F3, Color.blue),
        Asteroid2(0x08FF, Color.blue),
        Asteroid3(0x090D, Color.blue),
        Asteroid4(0x091A, Color.blue), //
        Schuss(15, Color.red),
        UFO(0x0929, Color.magenta), //
        ich(12, Color.green), //
        Explosion3(0x0880, Color.yellow),
        Explosion2(0x0896, Color.yellow),
        Explosion1(0x08B5, Color.yellow),
        Explosion0(0x08D0, Color.yellow), //
        Copyright_1979_ATARI_INC(0x0852, Color.white),
        Raumschiff(0x0A6D, Color.darkGray), //
        O(0xADD), _(0xB2C), _1(0xB2E), _2(0xB32), _3(0xB3A), _4(0xB41), _5(0xB48), _6(0xB4F),
        _7(0xB56),
        _8(0xB5B),
        _9(0xB63), //
        __(0x0B26), //
        A(0xA78), B(0xA80), C(0xA8D), D(0xA93), E(0xA9B), F(0xAA3), G(0xAAA), H(0xAB3), I(0xABA), J(0xAC1), K(0xAC7),
        L(0xACD), M(0xAD2), N(0xAD8), P(0xAE3), Q(0xAEA), R(0xAF3), S(0xAFB), T(0xB02), U(0xB08), V(0xB0E), W(0xB13),
        X(0xB1A), Y(0xB1F), Z(0xB26), //
        Highscores(4, Color.orange), //
        unbekannt(0x0FFF, Color.darkGray);
        public final int   w;
        public final Color c;

        Bild(final int wert) {
            w = wert;
            c = Color.lightGray;
        }
        Bild(final int wert, final Color color) {
            w = wert;
            c = color;
        }
        public static Bild search(final int wert) {
            for (final Bild bild : Bild.values()) {
                if (bild.w == wert) return bild;
            }
            return Bild._;
        }
        public boolean isText() {
            return ((ordinal() >= Bild.Raumschiff.ordinal()) & (ordinal() <= Bild.Z.ordinal()));
        }
    }

    /**
     * @param g
     */
    public void draw(final Graphics2D g) {
        if (bild == Bild.ich) { // Vectoren für Schiff ausgeben
            g.setColor(Color.gray);
            int y = (int) (300.0 * Math.sin(winkel));
            int x = (int) (300.0 * Math.cos(winkel));
            g.drawLine(pos.x, pos.y, pos.x + x, pos.y + y);
            g.setColor(Color.darkGray);
            y = (int) (300.0 * Math.sin(zielwinkel));
            x = (int) (300.0 * Math.cos(zielwinkel));
            g.drawLine(pos.x, pos.y, pos.x + x, pos.y + y);
        }
        g.setColor(bild.c);
        final String s = bild.name();
        switch (s.length()) {
            case 1:// Buchstaben
                if (!s.startsWith("_")) g.drawString(s, pos.x, pos.y);
                break;
            case 2:// Zahlen
                String zahl = s.substring(1, 2);
                if (!zahl.equals("_")) g.drawString(zahl, pos.x, pos.y);
                break;
            case 6:// Schuss
                if (naeherung <= 0) {
                    g.setColor(Color.green);
                    // size=(int) (naeherung/-20);
                    //size = 2;
                    g.fillOval(pos.x - size / 2, pos.y - size / 2, size, size);
                } else {
                    g.setColor(Color.yellow);
                    // size = (int) (naeherung/5);
                    g.fillOval(pos.x - size * 2, pos.y - size * 2, size * 4, size * 4);
                }
               // g.drawString(String.valueOf(nr), pos.x, pos.y);
                break;
            default:
                if (gefahr > 0) g.setColor(new Color(gefahr >> 2, 1, 100));
                if (gefahr > 700) {
                    if (gefahr >= 1000) g.setColor(Color.red);
                    if (isUFO()) g.setColor(Color.orange);
                    g.fillOval(pos.x - size / 2, pos.y - size / 2, size, size);
                    if (bild.c != Color.white) {
                        int x = pos.x;
                        int y = pos.y;
                        // g.drawLine(x, y, x + xdelta, y + ydelta);
                        // if ((bild.c == Color.blue) && (dpos.z > 0)) {
                        if (gefahr > 0) {
                            for (int zukunft = 500; zukunft < 2500; zukunft += 500) {
                                x = getX0(zukunft);
                                y = getY0(zukunft);
                                g.drawLine(x, y, x + 1, y + 1);
                            }
                            /*
                             * final int bx = (int) (200l * dpos.x / dpos.z); final int by = (int)
                             * (200l * dpos.y / dpos.z); for (long i = 0; i < 20; i++) { x += bx; y +=
                             * by; x %= 1000; y %= 1000; g.drawLine(x, y, x + 1, y + 1); }
                             */
                        }
                    }
                } else {
                    g.drawOval(pos.x - size / 2, pos.y - size / 2, size, size);
                }
        }
    }
    /**
     * @param w0
     */
    public static Drawable JSRL(final int w0) {
        final Bild test = Bild.search(w0 & 0x0FFF);
        if (test == Bild.unbekannt) return null;
        final Drawable drawable = getCachedDrawable(test);
        switch (test) {
            case Copyright_1979_ATARI_INC:
                drawable.pos.x = 400;
                drawable.pos.y = 1000;
                break;
            case A:
            case B:
            case C:
            case D:
            case E:
            case F:
            case G:
            case H:
            case I:
            case J:
            case K:
            case L:
            case M:
            case N:
            case O:
            case P:
            case Q:
            case R:
            case S:
            case T:
            case U:
            case V:
            case W:
            case X:
            case Y:
            case Z:
            case _:
            case _1:
            case _2:
            case _3:
            case _4:
            case _5:
            case _6:
            case _7:
            case _8:
            case _9:
                labs_xpos += 18;
                break;
            case Raumschiff:
            case __:
                // case SK:
            case Explosion0:
            case Explosion1:
            case Explosion2:
            case Explosion3:
                break;
            case UFO:// UFO
                drawable.size = 40;
                break;
            case Asteroid1:
            case Asteroid2:
            case Asteroid3:
            case Asteroid4:
                switch (labs_gsf) {
                    case 0x0E:
                        drawable.size = 20;
                        break;
                    case 0x00:
                        drawable.size = 80;
                        break;
                    case 0x0F:
                        drawable.size = 40;
                        break;
                    default:
                        break;
                }
                break;
            case unbekannt:
            default:
                System.out.println(Integer.toHexString(w0 & 0x0FFF) + " ");
                break;
        }
        return drawable;
    }
    /**
     * @param test
     * @return
     * @Deprecated
     */
    private static Drawable getCachedDrawable(final Bild test) {
        Drawable erg = null;
        int bisheriger_abstand = 4000;
        cache_search: for (final Drawable d : cachelist) {
            if (d.bild == test) {
                final int abstand = naehe(d.pos.x, d.pos.y, labs_xpos, labs_ypos);
                if (abstand < bisheriger_abstand) {
                    erg = d;
                    bisheriger_abstand = abstand;
                    if (test == Bild.ich) break cache_search;
                    // System.out.print(" "+bisheriger_abstand);
                }
            }
        }
        // System.out.println();
        if (erg != null) {
            cachelist.remove(erg);
        } else {
            erg = new Drawable(test);
        }
        if (bisheriger_abstand < 200) {
            erg.xdelta = naehe(erg.pos.x, labs_xpos);
            erg.ydelta = naehe(erg.pos.y, labs_ypos);
            erg.dpos.x += erg.xdelta;
            erg.dpos.y += erg.ydelta;
            erg.dpos.z += udptdd;
        } else {
            erg.reset();
        }
        erg.pos.x = labs_xpos;
        erg.pos.y = labs_ypos;
        erg.gsf = labs_gsf;
        drawList.add(erg);
        return erg;
    }
    /**
     * @param w0
     * @param w1
     */
    public static void LABS(final int w0, final int w1) {
        labs_xpos = w1 & 0x03ff;
        labs_ypos = 0x03FF - (w0 & 0x03ff);
        labs_gsf = w1 >> 12;
    }
    /**
     * @param w0
     * @param w1
     * @return
     */
    public static Drawable VCTR(final int w0, final int w1) {
        // VCTR((w1 & 0x0400) == 0 ? pos.x : -pos.x, (w0 & 0x0400) == 0 ? pos.y : -pos.y, dz,
        // opcode);
        final int dz = w1 >> 12;
        if (dz == 0) return null;
        final Drawable erg = getCachedDrawable(Bild.search(dz));
        if (erg.bild == Bild.ich) {
            // if (count_ich() == 1) {
            if ((w0 >> 12) == 6) {
                if ((wx == 0) & (wy == 0)) {
                    int x = (w1 & 0x03FF);
                    wx = -(((w1 & 0x0400) == 0) ? -x : x);
                    int y = (w0 & 0x03FF);
                    wy = -(((w0 & 0x0400) == 0) ? y : -y);
                } else {
                    int x = (w1 & 0x03FF);
                    wx += (((w1 & 0x0400) == 0) ? -x : x);
                    int y = (w0 & 0x03FF);
                    wy += (((w0 & 0x0400) == 0) ? y : -y);
                    double w = Math.atan2(wy, wx);
                    // System.out.println("x=" + wx + " y=" + wy + " w=" + winkel);
                    Schiff.getSchiff().aktualisierePos(erg, w);
                }
            }
        }
        return erg;
    }
    /**
     * @return
     * @Deprecated
     */
    private static int count_ich() {
        int count = 0;
        for (final Drawable d : drawList) {
            if (d.isIch()) count++;
        }
        return count;
    }
    /**
     * @return
     */
    private boolean isIch() {
        return (bild == Bild.ich);
    }
    /**
     * 
     */
    public void reset() {
        // farbe = Color.lightGray;
        naeherung=0;
        size = 2;
        pos.x = 0;
        pos.y = 0;
        xdelta = 0;
        ydelta = 0;
        dpos.z = 0;
        dpos.x = 0;
        dpos.y = 0;
        gefahr = 0;
    }
    /**
     * @param nr
     *            the nr to set
     * @deprecated
     */
    public void setNr(final int nr) {
        this.nr = nr;
    }
    /**
     * @param timestamp
     * @deprecated
     */
    public static void clearList(final long timestamp) {
        for (final Drawable d : drawList) {
            cachelist.add(d);
        }
        drawList.clear();
        if (udptimestamp != 0) udptdd = (timestamp - udptimestamp);
        udptimestamp = timestamp;
        wx = 0;
        wy = 0;
    }
    /**
     * 
     * @return
     * @deprecated
     */
    public static ArrayList<Drawable> getDrawlist() {
        return cleanlist;
    }
    /**
     * 
     * @return
     * @deprecated
     */
    public static int getDrawlistsize() {
        return drawList.size();
    }
    /**
     * @return
     * @deprecated
     */
    public static int getCachelistsize() {
        return cachelist.size();
    }
    /**
     * @deprecated
     */
    public static void clearCache() {
        for (final Drawable d : cachelist) {
            d.reset();
        }
        listclean.acquireUninterruptibly();
        cleanlist.clear();
        cleanlist.addAll(drawList);
        listclean.release();
    }
    private static int naehe(final int x, final int y, final int x2, final int y2) {
        final int dx = naehe(x, x2);
        final int dy = naehe(y, y2);
        return Math.abs(dx) + Math.abs(dy);
    }
    /**
     * @param y
     * @param y2
     * @return
     */
    private static int naehe(final int x2, final int x) {
        int dx = x - x2;
        if (dx > 500) dx -= 1000;
        if (dx < -500) dx += 1000;
        return dx;
    }
    /**
     * @return
     */
    public boolean isUFO() {
        return (bild == Bild.UFO);
    }
    /**
     * @return
     */
    public boolean isAsteroid() {
        return ((bild == Bild.Asteroid1) || (bild == Bild.Asteroid2) || (bild == Bild.Asteroid3) || (bild == Bild.Asteroid4));
    }
    /**
     * @return the ziel
     */
    public int getGefahr() {
        return gefahr;
    }
    /**
     * @param gefahr
     *            the ziel to set
     */
    public void setGefahr(final int gefahr) {
        this.gefahr = (gefahr < 1) ? 0 : (gefahr > 1000) ? 1000 : gefahr;
    }
    /**
     * @return
     */
    public long Time0() {
        return udptimestamp;
    }
    /**
     * @return the winkel
     */
    public static double getWinkel() {
        return winkel;
    }
    /**
     * @param i
     */
    public void setSize(int s) {
        size = s;
    }
    /**
     * @return
     */
    public boolean ismeinSchiff() {
        return bild == Bild.ich;
    }
    /**
     * @param test
     * @return
     */
    public boolean isBild(Bild test) {
        return bild == test;
    }
    /**
     * @param gsf2
     * @return
     */
    public boolean isGsf(int gsf2) {
        return gsf == gsf2;
    }
    /**
     * @param labs_gsf2
     */
    public void setGsf(int labs_gsf2) {
        gsf = labs_gsf2;
    }
    /**
     * @return
     */
    public boolean isSchuss() {
        return bild == Bild.Schuss;
    }
}
