/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import de.uhingen.kielkopf.andreas.modell.Drawable;
import de.uhingen.kielkopf.andreas.modell.FlugKoerper;
import de.uhingen.kielkopf.andreas.modell.Schiff;
import de.uhingen.kielkopf.andreas.modell.Drawable.Bild;

/**
 * @author andreas
 * 
 */
public class UdpInterpreter {
    /**
     * wird nach dem empfang aufgerufen, bevor ein neues Paket angefordert wird
     */
    private static byte                ping_analyse = -2;
    private static byte[]              udpPacket    = null;
    // private static int x; private static int y;
    private static int                 labs_xpos;
    private static int                 labs_ypos;
    private static int                 labs_gsf;
    private static Semaphore           listclean    = new Semaphore(1);
    // eine jederzeit den aktuellen Stand repräsentierende Liste
    private static ArrayList<Drawable> cleanlist    = new ArrayList<Drawable>();
    private static ArrayList<Drawable> cachelist    = new ArrayList<Drawable>();

    public static void analysePacket(byte[] packet, long deltaPacketTime) {
        // nur neue Pakete verarbeiten
        if (Arrays.equals(packet, udpPacket)) return;
        // Platz für Kopie vorbereiten
        if (udpPacket == null) udpPacket = new byte[UdpHandler.UDP_LEN_EMPF];
        if (udpPacket.length != packet.length) return;
        // Kopie anfertigen
        System.arraycopy(packet, 0, udpPacket, 0, udpPacket.length);
        // Kopie analysieren
        cachelist = (ArrayList<Drawable>) cleanlist.clone();
        ArrayList<Drawable> ergliste = new ArrayList<Drawable>();
        int ergNr = 0;
        wx = 0;
        wy = 0;
        Drawable erg;
        try {
            interpreter: for (int zeiger = 0; zeiger < udpPacket.length;) {
                erg = null;
                final int b0 = udpPacket[zeiger++] & 0x0FF;
                final int b1 = udpPacket[zeiger++] & 0x0FF;
                final int w0 = b0 + (b1 << 8);
                final int opcode = w0 >> 12;
                if (opcode <= 0x0A) {// 2 Word-Befehle
                    final int b2 = udpPacket[zeiger++] & 0x0FF;
                    final int b3 = udpPacket[zeiger++] & 0x0FF;
                    final int w1 = b2 + (b3 << 8);
                    switch (opcode) {
                        case 0x0A:// LABS Strahl positionieren
                            interpretLABS(w0, w1);
                            break;
                        default: // VCTR langer Vector
                            erg = interpretVCTR(w0, w1, ergNr, deltaPacketTime, opcode);
                            break;
                    }
                } else { // 1 Word-Befehle
                    switch (opcode) {
                        case 0x0b:// HALT - Programmende
                            // System.out.println("---");
                            break interpreter;
                        case 0x0c:// JSRL - Subroutine aufrufen
                            erg = interpretJSRL(w0, ergNr, deltaPacketTime);
                        case 0x0d:// RTSL - Return
                        case 0x0e:// JMPL - Unbedingter Sprung
                        case 0x0f:// SVEC - kurzer Vector
                        default:
                            break;
                    }
                }
                if ((erg != null) && (!ergliste.contains(erg))) {
                    ergNr++;
                    ergliste.add(erg);
                }
            }
        } catch (RuntimeException e1) {}
        listclean.acquireUninterruptibly();
        cleanlist = ergliste;
        listclean.release();
        try {
            barier_ziel.await(1, TimeUnit.MICROSECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (BrokenBarrierException e) {} catch (TimeoutException e) {}
        try {
            barier_winkel.await(1, TimeUnit.MICROSECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (BrokenBarrierException e) {} catch (TimeoutException e) {}
        try {
            barier_display.await(1, TimeUnit.MICROSECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (BrokenBarrierException e) {} catch (TimeoutException e) {}
    }

    public static CyclicBarrier barier_ziel    = new CyclicBarrier(2);
    public static CyclicBarrier barier_display = new CyclicBarrier(2);
    public static CyclicBarrier barier_winkel  = new CyclicBarrier(2);

    // public static CyclicBarrier barier_schiff = new CyclicBarrier(2);
    /**
     * @return Kopie einer aktuellen Liste
     */
    public static ArrayList<Drawable> getCleanlist() {
        return (ArrayList<Drawable>) cleanlist.clone();
    }
    /**
     * Das ist die vermutliche Position des nächsten Elementes
     * 
     * @param w0
     * @param w1
     */
    private static void interpretLABS(final int w0, final int w1) {
        labs_xpos = w1 & 0x03ff;
        labs_ypos = 0x03FF - (w0 & 0x03ff);
        labs_gsf = w1 >> 12;
    }
    /**
     * @param w0
     * @param ergNr
     * @param deltaPacketTime
     * @return
     */
    private static Drawable interpretJSRL(final int w0, int ergNr, long deltaPacketTime) {
        // ermittle die gezeichnete Grafik
        final Bild test = Drawable.Bild.search(w0 & 0x0FFF);
        if (test == Bild.unbekannt) return null;
        // suche im Cache nach diesem Flugkörper
        final Drawable drawable = getCachedDrawable(test, labs_gsf, ergNr, deltaPacketTime, 0);
        if (test.isText()) {
            labs_xpos += 18;
        } else {
            switch (test) {
                case Copyright_1979_ATARI_INC:
                    drawable.setPos(400, 1000);
                    break;
                case UFO:// UFO
                    drawable.setSize(40);
                    break;
                case Asteroid1:
                case Asteroid2:
                case Asteroid3:
                case Asteroid4:
                    switch (labs_gsf) {
                        case 0x0E:
                            drawable.setSize(20);
                            break;
                        case 0x0F:
                            drawable.setSize(40);
                            break;
                        case 0x00:
                        default:
                            drawable.setSize(80);
                            break;
                    }
                    break;
                case Explosion0:
                case Explosion1:
                case Explosion2:
                case Explosion3:
                    break;
                case unbekannt:
                default:
                    System.out.println(Integer.toHexString(w0 & 0x0FFF) + " ");
                    break;
            }
        }
        return drawable;
    }

    private static int wy;
    private static int wx;

    /**
     * @param w0
     * @param w1
     * @param ergNr
     * @param deltaPacketTime
     * @param opcode
     * @return
     */
    private static Drawable interpretVCTR(final int w0, final int w1, int ergNr, long deltaPacketTime, int opcode) {
        // VCTR((w1 & 0x0400) == 0 ? pos.x : -pos.x, (w0 & 0x0400) == 0 ? pos.y : -pos.y, dz,
        // opcode);
        final int dz = w1 >> 12;
        if (dz == 0) return null;
        final Drawable erg = getCachedDrawable(Bild.search(dz), labs_gsf, ergNr, deltaPacketTime, opcode);
        if (erg.ismeinSchiff()) {
            if ((w0 >> 12) == 6) {
                erg.setSize(Schiff.SCHIFFSIZE);
                if ((wx == 0) & (wy == 0)) { // erster Vektor
                    int dx = (w1 & 0x03FF);
                    wx = -(((w1 & 0x0400) == 0) ? -dx : dx);
                    int dy = (w0 & 0x03FF);
                    wy = -(((w0 & 0x0400) == 0) ? dy : -dy);
                } else {// zweiter Vector
                    int dx = (w1 & 0x03FF);
                    wx += (((w1 & 0x0400) == 0) ? -dx : dx);
                    int dy = (w0 & 0x03FF);
                    wy += (((w0 & 0x0400) == 0) ? dy : -dy);
                    double w = Math.atan2(wy, wx);
                    // System.out.println("x=" + wx + " y=" + wy + " w=" + winkel);
                    Schiff.getSchiff().aktualisierePos(erg, w);
                    // try {
                    // barier_schiff.await(1, TimeUnit.MICROSECONDS);
                    // } catch (InterruptedException e) {} catch (BrokenBarrierException e) {} catch
                    // (TimeoutException e) {}
                }
            }
        }
        return erg;
    }
    /**
     * @param test
     * @param nr
     * @param gsf
     * @param deltaPacketTime
     * @param opcode
     * @return
     */
    private static Drawable getCachedDrawable(final Bild test, int gsf, int ergnr, long deltaPacketTime, int opcode) {
        Drawable erg = null;
        int bisheriger_abstand = 4000;
        cache_search: for (final Drawable d : cachelist) {
            if (!d.isBild(test)) continue cache_search; // Das Bild muss gleich sein
            if (!d.isSchuss()) {
                if (!d.isGsf(gsf)) continue cache_search; // Die Größe muss gleich sein
            }
            final int abstand = d.getPos().Abstand(labs_xpos, labs_ypos, 1024);
            if (abstand < bisheriger_abstand) {
                erg = d;
                bisheriger_abstand = abstand;
                if (test == Bild.ich) break cache_search;
                // System.out.print(" "+bisheriger_abstand);
            }
        }
        // System.out.println();
        if (erg != null) {
            cachelist.remove(erg);
        } else {
            erg = new Drawable(test, gsf);
        }
        if (bisheriger_abstand < 20) {
            erg.addDelta(labs_xpos, labs_ypos, deltaPacketTime, 1024);
        } else {
            erg.reset();
        }
        erg.setPos(labs_xpos, labs_ypos);
        erg.setGsf(labs_gsf);
        if (erg.isSchuss()) {
            erg.setNr(ergnr);
        }
        return erg;
    }
}